/*
 * Decompiled with CFR 0.152.
 */
package com.eleksploded.lavadynamics.storage;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.event.world.WorldEvent;

public class CheckedStorage {
    List<Chunk> chunks = new CopyOnWriteArrayList<Chunk>();
    String fileName = "LD_CheckedStorage";
    int dimID;

    public CheckedStorage(int dimIDin) {
        this.dimID = dimIDin;
    }

    File getFile() {
        String tmp = DimensionManager.getCurrentSaveRootDirectory() + "/";
        tmp = DimensionManager.getProvider((int)this.dimID).getSaveFolder() != null ? tmp + DimensionManager.getProvider((int)this.dimID).getSaveFolder() + "/" + this.fileName : tmp + this.fileName;
        return new File(tmp);
    }

    public void load(WorldEvent.Load event) {
        if (event.getWorld().field_73011_w.getDimension() != this.dimID) {
            return;
        }
        try {
            if (this.getFile().exists()) {
                Path path = this.getFile().toPath();
                for (String in : Files.readAllLines(path)) {
                    String[] tmp = in.split("\\|");
                    this.chunks.add(event.getWorld().func_72964_e(Integer.valueOf(tmp[0]).intValue(), Integer.valueOf(tmp[1]).intValue()));
                }
            } else {
                this.getFile().createNewFile();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("Error loading CheckedStorage. Please report this on the github page.");
        }
    }

    public void save(WorldEvent.Save event) {
        if (event.getWorld().field_73011_w.getDimension() != this.dimID) {
            return;
        }
        try {
            if (this.getFile().exists()) {
                Path path = this.getFile().toPath();
                ArrayList<String> list = new ArrayList<String>();
                for (Chunk chunk : this.chunks) {
                    String tmp = chunk.field_76635_g + "|" + chunk.field_76647_h;
                    if (!list.contains(tmp)) {
                        list.add(tmp);
                    }
                    this.getFile().delete();
                    this.getFile().createNewFile();
                    Files.write(path, list, new OpenOption[0]);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("Error saving CheckedStorage. Please report this on the github page.");
        }
    }

    public boolean isChecked(Chunk chunk) {
        return this.chunks.contains(chunk);
    }

    public void addChecked(Chunk chunk) {
        if (!this.chunks.contains(chunk)) {
            this.chunks.add(chunk);
        }
    }
}

