/*
 * Decompiled with CFR 0.152.
 */
package com.eleksploded.lavadynamics.storage;

import com.eleksploded.lavadynamics.LavaConfig;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.event.world.WorldEvent;

public class VolcanoStorage {
    List<Chunk> chunks = new CopyOnWriteArrayList<Chunk>();
    Map<Chunk, Integer> tops = new HashMap<Chunk, Integer>();
    String fileName = "LD_VolcanoStorage";
    int dimID;

    public VolcanoStorage(int dimid) {
        this.dimID = dimid;
    }

    File getFile() {
        String tmp = DimensionManager.getCurrentSaveRootDirectory() + "/";
        tmp = DimensionManager.getProvider((int)this.dimID).getSaveFolder() != null ? tmp + DimensionManager.getProvider((int)this.dimID).getSaveFolder() + "/" + this.fileName : tmp + this.fileName;
        return new File(tmp);
    }

    public void load(WorldEvent.Load event) {
        if (event.getWorld().field_73011_w.getDimension() != this.dimID) {
            return;
        }
        try {
            if (this.getFile().exists()) {
                Path path = this.getFile().toPath();
                for (String in : Files.readAllLines(path)) {
                    String[] tmp = in.split("\\|");
                    Chunk chunk = event.getWorld().func_72964_e(Integer.valueOf(tmp[0]).intValue(), Integer.valueOf(tmp[1]).intValue());
                    this.chunks.add(chunk);
                    this.tops.put(chunk, Integer.valueOf(tmp[2]));
                }
            } else {
                this.getFile().createNewFile();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("Error loading VolcanoStorage. Please report this on the github page.");
        }
    }

    public void save(WorldEvent.Save event) {
        if (event.getWorld().field_73011_w.getDimension() != this.dimID) {
            return;
        }
        try {
            if (this.getFile().exists()) {
                Path path = this.getFile().toPath();
                ArrayList<String> list = new ArrayList<String>();
                for (Chunk chunk : this.chunks) {
                    String tmp = chunk.field_76635_g + "|" + chunk.field_76647_h + "|" + this.tops.get(chunk);
                    if (!list.contains(tmp)) {
                        list.add(tmp);
                    }
                    this.getFile().delete();
                    this.getFile().createNewFile();
                    Files.write(path, list, new OpenOption[0]);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("Error saving VolcanoStorage. Please report this on the github page.");
        }
    }

    public boolean isVolcano(Chunk chunk) {
        if (!this.chunks.isEmpty()) {
            return this.chunks.contains(chunk);
        }
        return false;
    }

    public int getTop(Chunk chunk) {
        if (this.tops.containsKey(chunk)) {
            return this.tops.get(chunk);
        }
        return 0;
    }

    public void addVolcano(Chunk chunk, int top) {
        this.chunks.add(chunk);
        this.tops.put(chunk, top);
    }

    public boolean isVolcanoInRange(Chunk chunk) {
        BlockPos spawnpos;
        int xIn = (chunk.func_76632_l().func_180332_e() - chunk.func_76632_l().func_180334_c()) / 2 + chunk.func_76632_l().func_180334_c();
        int zIn = (chunk.func_76632_l().func_180330_f() - chunk.func_76632_l().func_180333_d()) / 2 + chunk.func_76632_l().func_180333_d();
        if (!LavaConfig.volcano.spawnChunks && (spawnpos = new BlockPos(chunk.func_177412_p().func_175694_M().func_177958_n(), 70, chunk.func_177412_p().func_175694_M().func_177952_p())).func_185332_f(xIn, 70, zIn) <= (double)LavaConfig.volcano.spawnDistance) {
            return true;
        }
        for (Chunk chunkIn : this.chunks) {
            int z;
            int x = (chunkIn.func_76632_l().func_180332_e() - chunkIn.func_76632_l().func_180334_c()) / 2 + chunkIn.func_76632_l().func_180334_c();
            BlockPos pos = new BlockPos(x, 70, z = (chunkIn.func_76632_l().func_180330_f() - chunkIn.func_76632_l().func_180333_d()) / 2 + chunkIn.func_76632_l().func_180333_d());
            if (!(pos.func_185332_f(xIn, 70, zIn) <= (double)LavaConfig.volcano.distance)) continue;
            return true;
        }
        return false;
    }

    public List<Chunk> getList() {
        return this.chunks;
    }
}

