/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.dogslie.common.core;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.WeakHashMap;
import me.ichun.mods.dogslie.common.LetSleepingDogsLie;
import me.ichun.mods.ichunutil.common.iChunUtil;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1493;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_310;
import net.minecraft.class_3417;
import org.jetbrains.annotations.NotNull;

public abstract class EventHandlerClient {
    public Random rand = new Random();
    public WeakHashMap<class_1493, WolfInfo> wolfInfo = new WeakHashMap();

    public EventHandlerClient() {
        iChunUtil.eC().registerClientTickEndListener(this::onClientTickEnd);
        iChunUtil.eC().registerOnClientDisconnectListener(client -> this.onClientDisconnected());
    }

    public void onEntityJoinLevel(class_1937 level, class_1297 entity) {
        class_1493 wolf;
        if (level.field_9236 && entity instanceof class_1493 && !this.wolfInfo.containsKey(wolf = (class_1493)entity)) {
            this.wolfInfo.put(wolf, new WolfInfo(LetSleepingDogsLie.config.dogsSpawnLying && class_310.method_1551().field_1719 != null && class_310.method_1551().field_1719.field_6012 < 20));
        }
    }

    public void onClientTickEnd(class_310 client) {
        if (!client.method_1493()) {
            this.wolfInfo.entrySet().removeIf(e -> !((WolfInfo)e.getValue()).tick((class_1493)e.getKey()));
        }
    }

    public void onLevelLoad() {
        class_310.method_1551().execute(this::clean);
    }

    public void onClientDisconnected() {
        class_310.method_1551().execute(this::clean);
    }

    public void clean() {
        this.wolfInfo.clear();
    }

    @NotNull
    public WolfInfo getWolfInfo(class_1493 wolf) {
        return this.wolfInfo.computeIfAbsent(wolf, w -> new WolfInfo(LetSleepingDogsLie.config.dogsSpawnLying && class_310.method_1551().field_1719 != null && class_310.method_1551().field_1719.field_6012 < 20));
    }

    public class WolfInfo {
        public int sitTime;
        public String[] setPoses = null;

        public WolfInfo(boolean lying) {
            this.sitTime = lying ? LetSleepingDogsLie.config.timeBeforeLie : 0;
        }

        public boolean tick(class_1493 parent) {
            if (parent.method_31481()) {
                return false;
            }
            if (parent.method_6172()) {
                List ents;
                boolean isLying = this.isLying();
                ++this.sitTime;
                if (!isLying && this.isLying() && class_310.method_1551().field_1719 != null && class_310.method_1551().field_1719.field_6012 > 20) {
                    parent.method_5770().method_8486(parent.method_23317(), parent.method_23318() + (double)parent.method_5751(), parent.method_23321(), class_3417.field_14807, parent.method_5634(), 0.4f, parent.method_6109() ? (parent.method_6051().method_43057() - parent.method_6051().method_43057()) * 0.2f + 1.5f : (parent.method_6051().method_43057() - parent.method_6051().method_43057()) * 0.2f + 1.0f, false);
                }
                LetSleepingDogsLie.GetsUpFor getsUpFor = LetSleepingDogsLie.config.getsUpTo;
                if (parent.field_6012 % 10 == 0 && getsUpFor != LetSleepingDogsLie.GetsUpFor.NOBODY && LetSleepingDogsLie.config.rangeBeforeGettingUp > 0.1 && (ents = parent.method_5770().method_8335((class_1297)parent, parent.method_5829().method_1014(LetSleepingDogsLie.config.rangeBeforeGettingUp))).stream().anyMatch(entity -> (getsUpFor == LetSleepingDogsLie.GetsUpFor.OWNER && entity instanceof class_1309 && parent.method_6171((class_1309)entity) || getsUpFor == LetSleepingDogsLie.GetsUpFor.PLAYERS && entity instanceof class_1657 && !entity.method_7325() || getsUpFor == LetSleepingDogsLie.GetsUpFor.ANY_LIVING_ENTITY && entity instanceof class_1309 && (!(entity instanceof class_1657) || !entity.method_7325())) && parent.method_6057(entity))) {
                    if (isLying) {
                        parent.method_5770().method_8486(parent.method_23317(), parent.method_23318() + (double)parent.method_5751(), parent.method_23321(), class_3417.field_14724, parent.method_5634(), 0.4f, parent.method_6109() ? (parent.method_6051().method_43057() - parent.method_6051().method_43057()) * 0.2f + 1.5f : (parent.method_6051().method_43057() - parent.method_6051().method_43057()) * 0.2f + 1.0f, false);
                    }
                    this.sitTime = 0;
                    this.setPoses = null;
                }
            } else {
                this.sitTime = 0;
                this.setPoses = null;
            }
            return true;
        }

        public boolean isLying() {
            return this.sitTime > LetSleepingDogsLie.config.timeBeforeLie;
        }

        public String[] getCompatiblePoses(class_1493 parent) {
            if (this.setPoses == null) {
                String[] poses = new String[2];
                ArrayList<String> front = new ArrayList<String>();
                ArrayList<String> rear = new ArrayList<String>();
                for (String s : LetSleepingDogsLie.config.enabledPoses) {
                    if (s.startsWith("foreleg") && (!parent.method_6109() || s.equalsIgnoreCase("forelegSprawledBack") || s.equalsIgnoreCase("forelegSide"))) {
                        front.add(s);
                    }
                    if (!s.startsWith("hindleg")) continue;
                    rear.add(s);
                }
                if (front.isEmpty()) {
                    if (!parent.method_6109()) {
                        front.add("forelegStraight");
                        front.add("forelegSprawled");
                        front.add("forelegSkewed");
                    }
                    front.add("forelegSprawledBack");
                    front.add("forelegSide");
                }
                if (rear.isEmpty()) {
                    rear.add("hindlegStraight");
                    rear.add("hindlegStraightBack");
                    rear.add("hindlegSprawled");
                    rear.add("hindlegSprawledBack");
                    rear.add("hindlegSide");
                }
                if (EventHandlerClient.this.rand.nextBoolean()) {
                    poses[0] = (String)front.get(EventHandlerClient.this.rand.nextInt(front.size()));
                    poses[1] = (String)rear.get(EventHandlerClient.this.rand.nextInt(rear.size()));
                } else {
                    poses[1] = (String)rear.get(EventHandlerClient.this.rand.nextInt(rear.size()));
                    poses[0] = (String)front.get(EventHandlerClient.this.rand.nextInt(front.size()));
                }
                if (poses[0].endsWith("Side") && poses[1].endsWith("Side")) {
                    String side = EventHandlerClient.this.rand.nextBoolean() ? "L" : "R";
                    poses[0] = poses[0] + side;
                    poses[1] = poses[1] + side;
                } else {
                    if (poses[0].endsWith("Side") || poses[0].endsWith("Skewed")) {
                        poses[0] = poses[0] + (EventHandlerClient.this.rand.nextBoolean() ? "L" : "R");
                    }
                    if (poses[1].endsWith("Side")) {
                        poses[1] = poses[1] + (EventHandlerClient.this.rand.nextBoolean() ? "L" : "R");
                    }
                }
                this.setPoses = poses;
            }
            return this.setPoses;
        }
    }
}

