/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.dogslie.mixin;

import me.ichun.mods.dogslie.common.LetSleepingDogsLie;
import me.ichun.mods.dogslie.common.core.EventHandlerClient;
import net.minecraft.client.model.WolfModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.animal.Wolf;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={WolfModel.class})
public abstract class WolfModelMixin {
    @Shadow
    @Final
    @Mutable
    private ModelPart head;
    @Shadow
    @Final
    @Mutable
    private ModelPart realHead;
    @Shadow
    @Final
    @Mutable
    private ModelPart body;
    @Shadow
    @Final
    @Mutable
    private ModelPart rightHindLeg;
    @Shadow
    @Final
    @Mutable
    private ModelPart leftHindLeg;
    @Shadow
    @Final
    @Mutable
    private ModelPart rightFrontLeg;
    @Shadow
    @Final
    @Mutable
    private ModelPart leftFrontLeg;
    @Shadow
    @Final
    @Mutable
    private ModelPart tail;
    @Shadow
    @Final
    @Mutable
    private ModelPart realTail;
    @Shadow
    @Final
    @Mutable
    private ModelPart upperBody;

    @Inject(method={"createMeshDefinition"}, at={@At(value="HEAD")}, cancellable=true)
    private static void dogslie$createMeshDefinition(CubeDeformation cubeDeformation, CallbackInfoReturnable<MeshDefinition> cir) {
        MeshDefinition mesh = new MeshDefinition();
        PartDefinition root = mesh.getRoot();
        PartDefinition head = root.addOrReplaceChild("head", CubeListBuilder.create(), PartPose.offset((float)-1.0f, (float)13.5f, (float)-7.0f));
        head.addOrReplaceChild("real_head", CubeListBuilder.create().texOffs(0, 0).addBox(-2.0f, -3.0f, -2.0f, 6.0f, 6.0f, 4.0f, cubeDeformation).texOffs(16, 14).addBox(-2.0f, -5.0f, 0.0f, 2.0f, 2.0f, 1.0f).texOffs(16, 14).addBox(2.0f, -5.0f, 0.0f, 2.0f, 2.0f, 1.0f).texOffs(0, 10).addBox(-0.5f, 0.0f, -5.0f, 3.0f, 3.0f, 4.0f), PartPose.ZERO);
        root.addOrReplaceChild("body", CubeListBuilder.create().texOffs(18, 14).addBox(-3.0f, -2.0f, -3.0f, 6.0f, 9.0f, 6.0f, cubeDeformation), PartPose.offsetAndRotation((float)0.0f, (float)14.0f, (float)2.0f, (float)1.5707964f, (float)0.0f, (float)0.0f));
        root.addOrReplaceChild("upper_body", CubeListBuilder.create().texOffs(21, 0).addBox(-4.0f, -3.0f, -3.0f, 8.0f, 6.0f, 7.0f, cubeDeformation), PartPose.offsetAndRotation((float)0.0f, (float)14.0f, (float)-3.0f, (float)1.5707964f, (float)0.0f, (float)0.0f));
        CubeListBuilder var4 = CubeListBuilder.create().texOffs(0, 18).addBox(-1.0f, 0.0f, -1.0f, 2.0f, 8.0f, 2.0f, cubeDeformation);
        root.addOrReplaceChild("right_hind_leg", var4, PartPose.offset((float)-1.5f, (float)23.0f, (float)7.0f));
        root.addOrReplaceChild("left_hind_leg", var4, PartPose.offset((float)1.5f, (float)23.0f, (float)7.0f));
        root.addOrReplaceChild("right_front_leg", var4, PartPose.offset((float)-1.5f, (float)23.0f, (float)-4.0f));
        root.addOrReplaceChild("left_front_leg", var4, PartPose.offset((float)1.5f, (float)23.0f, (float)-4.0f));
        PartDefinition tail = root.addOrReplaceChild("tail", CubeListBuilder.create(), PartPose.offsetAndRotation((float)-1.0f, (float)12.0f, (float)8.0f, (float)0.62831855f, (float)0.0f, (float)0.0f));
        tail.addOrReplaceChild("real_tail", CubeListBuilder.create().texOffs(9, 18).addBox(0.0f, 0.0f, -1.0f, 2.0f, 8.0f, 2.0f, cubeDeformation), PartPose.ZERO);
        cir.setReturnValue((Object)mesh);
    }

    @Inject(method={"prepareMobModel(Lnet/minecraft/world/entity/animal/Wolf;FFF)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void dogslie$prepareMobModel(Wolf wolf, float limbSwing, float limbSwingAmount, float partialTick, CallbackInfo ci) {
        this.tail.yRot = wolf.isAngry() ? 0.0f : Mth.cos((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
        this.head.setPos(-1.0f, 13.5f, -7.0f);
        this.leftFrontLeg.yRot = 0.0f;
        this.rightFrontLeg.yRot = 0.0f;
        this.leftHindLeg.yRot = 0.0f;
        this.rightHindLeg.yRot = 0.0f;
        this.leftFrontLeg.zRot = 0.0f;
        this.rightFrontLeg.zRot = 0.0f;
        this.leftHindLeg.zRot = 0.0f;
        this.rightHindLeg.zRot = 0.0f;
        this.body.yRot = 0.0f;
        this.upperBody.yRot = 0.0f;
        this.body.zRot = 0.0f;
        this.upperBody.zRot = 0.0f;
        this.realTail.zRot = 0.0f;
        if (wolf.isInSittingPose()) {
            EventHandlerClient.WolfInfo info = LetSleepingDogsLie.eventHandlerClient.getWolfInfo(wolf);
            if (info.isLying()) {
                float halfPi = 1.5707964f;
                String[] poses = info.getCompatiblePoses(wolf);
                this.upperBody.setPos(0.0f, 20.9f, -3.0f);
                this.upperBody.xRot = halfPi;
                this.upperBody.yRot = 0.0f;
                if (wolf.getName().getString().equals("iChun")) {
                    this.body.yRot = this.upperBody.yRot = ((float)wolf.tickCount + partialTick) / 3.5f;
                    this.body.zRot = this.upperBody.zRot = ((float)wolf.tickCount + partialTick) / 3.5f;
                    this.rightHindLeg.yRot = this.rightFrontLeg.yRot = ((float)wolf.tickCount + partialTick) / 3.5f;
                    this.leftHindLeg.yRot = this.leftFrontLeg.yRot = -(((float)wolf.tickCount + partialTick) / 3.5f);
                    this.rightHindLeg.zRot = this.rightFrontLeg.zRot = ((float)wolf.tickCount + partialTick) / 5.0f;
                    this.leftHindLeg.zRot = this.leftFrontLeg.zRot = -(((float)wolf.tickCount + partialTick) / 5.0f);
                }
                switch (poses[0]) {
                    case "forelegSideL": {
                        this.upperBody.setPos(0.5f, 20.9f, -3.0f);
                        this.upperBody.xRot = halfPi;
                        this.upperBody.zRot = -0.956091f;
                        this.head.setPos(-1.0f, 20.5f, -7.0f);
                        this.rightFrontLeg.setPos(-1.5f, 23.0f, -4.0f);
                        this.rightFrontLeg.xRot = -0.087266f;
                        this.rightFrontLeg.zRot = -halfPi;
                        this.leftFrontLeg.setPos(1.5f, 21.0f, -3.0f);
                        this.leftFrontLeg.xRot = 0.10472f;
                        this.leftFrontLeg.zRot = -1.320342f;
                        break;
                    }
                    case "forelegSideR": {
                        this.upperBody.setPos(-0.5f, 20.9f, -3.0f);
                        this.upperBody.xRot = halfPi;
                        this.upperBody.zRot = 0.956091f;
                        this.head.setPos(-1.0f, 20.5f, -7.0f);
                        this.rightFrontLeg.setPos(-1.5f, 21.0f, -3.0f);
                        this.rightFrontLeg.xRot = 0.10472f;
                        this.rightFrontLeg.zRot = 1.320342f;
                        this.leftFrontLeg.setPos(1.5f, 23.0f, -4.0f);
                        this.leftFrontLeg.xRot = -0.087266f;
                        this.leftFrontLeg.zRot = halfPi;
                        break;
                    }
                    case "forelegStraight": {
                        this.head.setPos(-1.0f, 19.0f, -7.0f);
                        this.rightFrontLeg.setPos(-1.5f, 23.0f, -4.0f);
                        this.rightFrontLeg.xRot = -halfPi;
                        this.leftFrontLeg.setPos(1.5f, 23.0f, -4.0f);
                        this.leftFrontLeg.xRot = -halfPi;
                        break;
                    }
                    case "forelegSprawled": {
                        this.head.setPos(-1.0f, 20.4f, -7.0f);
                        this.rightFrontLeg.setPos(-1.5f, 23.0f, -4.0f);
                        this.rightFrontLeg.xRot = -halfPi;
                        this.rightFrontLeg.yRot = 0.63739425f;
                        this.leftFrontLeg.setPos(1.5f, 23.0f, -4.0f);
                        this.leftFrontLeg.xRot = -halfPi;
                        this.leftFrontLeg.yRot = -0.63739425f;
                        break;
                    }
                    case "forelegSprawledBack": {
                        this.head.setPos(-1.0f, 21.0f, -7.0f);
                        this.rightFrontLeg.setPos(-1.5f, 23.0f, -4.0f);
                        this.rightFrontLeg.xRot = halfPi;
                        this.rightFrontLeg.yRot = -0.63739425f;
                        this.leftFrontLeg.setPos(1.5f, 23.0f, -4.0f);
                        this.leftFrontLeg.xRot = halfPi;
                        this.leftFrontLeg.yRot = 0.63739425f;
                        break;
                    }
                    case "forelegSkewedL": {
                        this.head.setPos(-1.0f, 20.0f, -7.0f);
                        this.rightFrontLeg.setPos(-1.5f, 23.0f, -4.0f);
                        this.rightFrontLeg.xRot = -halfPi;
                        this.rightFrontLeg.yRot = -0.436332f;
                        this.leftFrontLeg.setPos(1.5f, 23.0f, -4.0f);
                        this.leftFrontLeg.xRot = -halfPi;
                        this.leftFrontLeg.yRot = -0.349066f;
                        break;
                    }
                    case "forelegSkewedR": {
                        this.head.setPos(-1.0f, 20.0f, -7.0f);
                        this.rightFrontLeg.setPos(-1.5f, 23.0f, -4.0f);
                        this.rightFrontLeg.xRot = -halfPi;
                        this.rightFrontLeg.yRot = 0.349066f;
                        this.leftFrontLeg.setPos(1.5f, 23.0f, -4.0f);
                        this.leftFrontLeg.xRot = -halfPi;
                        this.leftFrontLeg.yRot = 0.436332f;
                        break;
                    }
                }
                this.body.setPos(0.0f, 20.9f, 2.0f);
                this.body.xRot = halfPi;
                this.tail.setPos(-1.0f, 19.0f, 8.0f);
                switch (poses[1]) {
                    case "hindlegSideL": {
                        this.body.setPos(0.0f, 20.9f, 2.0f);
                        this.body.xRot = halfPi;
                        this.body.zRot = -0.610865f;
                        this.tail.setPos(-2.0f, 19.8f, 8.0f);
                        this.realTail.zRot = -0.610865f;
                        this.rightHindLeg.setPos(-0.2f, 23.5f, 6.5f);
                        this.rightHindLeg.xRot = -halfPi;
                        this.rightHindLeg.yRot = -0.956091f;
                        this.leftHindLeg.setPos(1.5f, 23.0f, 7.0f);
                        this.leftHindLeg.xRot = -halfPi;
                        this.leftHindLeg.yRot = -1.365895f;
                        break;
                    }
                    case "hindlegSideR": {
                        this.body.setPos(0.0f, 20.9f, 2.0f);
                        this.body.xRot = halfPi;
                        this.body.zRot = 0.610865f;
                        this.tail.setPos(0.0f, 19.8f, 8.0f);
                        this.realTail.zRot = 0.610865f;
                        this.rightHindLeg.setPos(-1.5f, 23.0f, 7.0f);
                        this.rightHindLeg.xRot = -halfPi;
                        this.rightHindLeg.yRot = 1.365895f;
                        this.leftHindLeg.setPos(0.2f, 23.5f, 6.5f);
                        this.leftHindLeg.xRot = -halfPi;
                        this.leftHindLeg.yRot = 0.956091f;
                        break;
                    }
                    case "hindlegStraight": {
                        this.rightHindLeg.setPos(-1.5f, 23.0f, 7.0f);
                        this.rightHindLeg.xRot = -halfPi;
                        this.leftHindLeg.setPos(1.5f, 23.0f, 7.0f);
                        this.leftHindLeg.xRot = -halfPi;
                        break;
                    }
                    case "hindlegStraightBack": {
                        this.rightHindLeg.setPos(-1.5f, 23.0f, 7.0f);
                        this.rightHindLeg.xRot = halfPi;
                        this.leftHindLeg.setPos(1.5f, 23.0f, 7.0f);
                        this.leftHindLeg.xRot = halfPi;
                        break;
                    }
                    case "hindlegSprawled": {
                        this.rightHindLeg.setPos(-1.5f, 23.0f, 7.0f);
                        this.rightHindLeg.xRot = -halfPi;
                        this.rightHindLeg.yRot = 0.523599f;
                        this.leftHindLeg.setPos(1.5f, 23.0f, 7.0f);
                        this.leftHindLeg.xRot = -halfPi;
                        this.leftHindLeg.yRot = -0.523599f;
                        break;
                    }
                    case "hindlegSprawledBack": {
                        this.rightHindLeg.setPos(-1.5f, 23.0f, 7.0f);
                        this.rightHindLeg.xRot = halfPi;
                        this.rightHindLeg.yRot = -0.523599f;
                        this.leftHindLeg.setPos(1.5f, 23.0f, 7.0f);
                        this.leftHindLeg.xRot = halfPi;
                        this.leftHindLeg.yRot = 0.523599f;
                    }
                }
                if (((WolfModel)this).young) {
                    this.head.y -= (this.head.y - 13.5f) * 0.5f;
                }
            } else {
                this.upperBody.setPos(0.0f, 16.0f, -3.0f);
                this.upperBody.xRot = 1.2566371f;
                this.upperBody.yRot = 0.0f;
                this.body.setPos(0.0f, 18.0f, 0.0f);
                this.body.xRot = 0.7853982f;
                this.tail.setPos(-1.0f, 21.0f, 6.0f);
                this.rightHindLeg.setPos(-1.5f, 22.0f, 2.0f);
                this.rightHindLeg.xRot = 4.712389f;
                this.leftHindLeg.setPos(1.5f, 22.0f, 2.0f);
                this.leftHindLeg.xRot = 4.712389f;
                this.rightFrontLeg.xRot = 5.811947f;
                this.rightFrontLeg.setPos(-1.49f, 17.0f, -4.0f);
                this.leftFrontLeg.xRot = 5.811947f;
                this.leftFrontLeg.setPos(1.51f, 17.0f, -4.0f);
                this.upperBody.zRot = wolf.getBodyRollAngle(partialTick, -0.08f);
                this.body.zRot = wolf.getBodyRollAngle(partialTick, -0.16f);
                this.realTail.zRot = wolf.getBodyRollAngle(partialTick, -0.2f);
            }
        } else {
            this.body.setPos(0.0f, 14.0f, 2.0f);
            this.body.xRot = 1.5707964f;
            this.upperBody.setPos(0.0f, 14.0f, -3.0f);
            this.upperBody.xRot = this.body.xRot;
            this.tail.setPos(-1.0f, 12.0f, 8.0f);
            this.rightHindLeg.setPos(-1.5f, 16.0f, 7.0f);
            this.leftHindLeg.setPos(1.5f, 16.0f, 7.0f);
            this.rightFrontLeg.setPos(-1.5f, 16.0f, -4.0f);
            this.leftFrontLeg.setPos(1.5f, 16.0f, -4.0f);
            this.rightHindLeg.xRot = Mth.cos((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
            this.leftHindLeg.xRot = Mth.cos((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount;
            this.rightFrontLeg.xRot = Mth.cos((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount;
            this.leftFrontLeg.xRot = Mth.cos((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
            this.upperBody.zRot = wolf.getBodyRollAngle(partialTick, -0.08f);
            this.body.zRot = wolf.getBodyRollAngle(partialTick, -0.16f);
            this.realTail.zRot = wolf.getBodyRollAngle(partialTick, -0.2f);
        }
        this.realHead.zRot = wolf.getHeadRollAngle(partialTick) + wolf.getBodyRollAngle(partialTick, 0.0f);
        ci.cancel();
    }

    @Inject(method={"setupAnim(Lnet/minecraft/world/entity/animal/Wolf;FFFFF)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void dogslie$setupAnim(Wolf entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, CallbackInfo ci) {
        this.head.xRot = headPitch * ((float)Math.PI / 180);
        this.head.yRot = netHeadYaw * ((float)Math.PI / 180);
        this.tail.xRot = ageInTicks;
        if (LetSleepingDogsLie.eventHandlerClient.getWolfInfo(entity).isLying()) {
            this.tail.xRot *= 0.5796969f;
        }
        ci.cancel();
    }
}

