/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.dogslie.common.core;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.WeakHashMap;
import me.ichun.mods.dogslie.common.LetSleepingDogsLie;
import me.ichun.mods.ichunutil.common.iChunUtil;
import me.ichun.mods.ichunutil.loader.event.client.LivingRenderPreEvent;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.WolfModel;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.WolfRenderer;
import net.minecraft.client.renderer.entity.state.WolfRenderState;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Wolf;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class EventHandlerClient {
    public final LivingRenderPreEvent.LastRenderedEntitySupplier<Wolf> wolfRendered;
    public Random rand = new Random();
    public WeakHashMap<Wolf, WolfInfo> wolfInfo = new WeakHashMap();

    public EventHandlerClient() {
        this.wolfRendered = new LivingRenderPreEvent.LastRenderedEntitySupplier(event -> {
            WolfRenderer renderer;
            LivingEntityRenderer patt0$temp = event.renderer();
            return patt0$temp instanceof WolfRenderer && ((WolfModel)(renderer = (WolfRenderer)patt0$temp).getModel()).getClass().equals(WolfModel.class) && event.livingEntity() instanceof Wolf && event.renderState() instanceof WolfRenderState;
        });
        iChunUtil.eC().registerClientTickEndListener(this::onClientTickEnd);
        iChunUtil.eC().registerClientLevelLoadListener(level -> this.onLevelLoad());
        iChunUtil.eC().registerClientEntityJoinLevelListener(this::onClientEntityJoinLevel);
        iChunUtil.eC().registerOnClientDisconnectListener(client -> this.onClientDisconnected());
    }

    public void onClientEntityJoinLevel(Level level, Entity entity) {
        Wolf wolf;
        if (entity instanceof Wolf && !this.wolfInfo.containsKey(wolf = (Wolf)entity)) {
            this.wolfInfo.put(wolf, new WolfInfo(LetSleepingDogsLie.config.dogsSpawnLying && Minecraft.getInstance().cameraEntity != null && Minecraft.getInstance().cameraEntity.tickCount < 20));
        }
    }

    public void onClientTickEnd(Minecraft client) {
        if (!client.isPaused()) {
            this.wolfInfo.entrySet().removeIf(e -> !((WolfInfo)e.getValue()).tick((Wolf)e.getKey()));
        }
    }

    public void onLevelLoad() {
        Minecraft.getInstance().execute(this::clean);
    }

    public void onClientDisconnected() {
        Minecraft.getInstance().execute(this::clean);
    }

    public void clean() {
        this.wolfInfo.clear();
    }

    @NotNull
    public WolfInfo getWolfInfo(Wolf wolf) {
        return this.wolfInfo.computeIfAbsent(wolf, w -> new WolfInfo(LetSleepingDogsLie.config.dogsSpawnLying && Minecraft.getInstance().cameraEntity != null && Minecraft.getInstance().cameraEntity.tickCount < 20));
    }

    public class WolfInfo {
        public int sitTime;
        public String[] setPoses = null;

        public WolfInfo(boolean lying) {
            this.sitTime = lying ? LetSleepingDogsLie.config.timeBeforeLie : 0;
        }

        public boolean tick(Wolf parent) {
            if (parent.isRemoved()) {
                return false;
            }
            if (parent.isInSittingPose()) {
                List ents;
                boolean isLying = this.isLying();
                ++this.sitTime;
                if (!isLying && this.isLying() && Minecraft.getInstance().cameraEntity != null && Minecraft.getInstance().cameraEntity.tickCount > 20 && LetSleepingDogsLie.config.playSoundWhenLieStateChanges) {
                    parent.getCommandSenderWorld().playLocalSound(parent.getX(), parent.getY() + (double)parent.getEyeHeight(), parent.getZ(), SoundEvents.WOLF_WHINE, parent.getSoundSource(), 0.4f, parent.isBaby() ? (parent.getRandom().nextFloat() - parent.getRandom().nextFloat()) * 0.2f + 1.5f : (parent.getRandom().nextFloat() - parent.getRandom().nextFloat()) * 0.2f + 1.0f, false);
                }
                LetSleepingDogsLie.GetsUpFor getsUpFor = LetSleepingDogsLie.config.getsUpFor;
                if (parent.tickCount % 10 == 0 && getsUpFor != LetSleepingDogsLie.GetsUpFor.NOBODY && LetSleepingDogsLie.config.rangeBeforeGettingUp > 0.1 && (ents = parent.getCommandSenderWorld().getEntities((Entity)parent, parent.getBoundingBox().inflate(LetSleepingDogsLie.config.rangeBeforeGettingUp))).stream().anyMatch(entity -> (getsUpFor == LetSleepingDogsLie.GetsUpFor.OWNER && entity instanceof LivingEntity && parent.isOwnedBy((LivingEntity)entity) || getsUpFor == LetSleepingDogsLie.GetsUpFor.PLAYERS && entity instanceof Player && !entity.isSpectator() || getsUpFor == LetSleepingDogsLie.GetsUpFor.ANY_LIVING_ENTITY && entity instanceof LivingEntity && (!(entity instanceof Player) || !entity.isSpectator())) && parent.hasLineOfSight(entity))) {
                    if (isLying && LetSleepingDogsLie.config.playSoundWhenLieStateChanges) {
                        parent.getCommandSenderWorld().playLocalSound(parent.getX(), parent.getY() + (double)parent.getEyeHeight(), parent.getZ(), SoundEvents.WOLF_AMBIENT, parent.getSoundSource(), 0.4f, parent.isBaby() ? (parent.getRandom().nextFloat() - parent.getRandom().nextFloat()) * 0.2f + 1.5f : (parent.getRandom().nextFloat() - parent.getRandom().nextFloat()) * 0.2f + 1.0f, false);
                    }
                    this.sitTime = 0;
                    this.setPoses = null;
                }
            } else {
                this.sitTime = 0;
                this.setPoses = null;
            }
            return true;
        }

        public boolean isLying() {
            return this.sitTime > LetSleepingDogsLie.config.timeBeforeLie;
        }

        public String[] getCompatiblePoses(Wolf parent) {
            if (this.setPoses == null) {
                String[] poses = new String[2];
                ArrayList<String> front = new ArrayList<String>();
                ArrayList<String> rear = new ArrayList<String>();
                for (String s : LetSleepingDogsLie.config.enabledPoses) {
                    if (s.startsWith("foreleg") && (!parent.isBaby() || s.equalsIgnoreCase("forelegSprawledBack") || s.equalsIgnoreCase("forelegSide"))) {
                        front.add(s);
                    }
                    if (!s.startsWith("hindleg")) continue;
                    rear.add(s);
                }
                if (front.isEmpty()) {
                    if (!parent.isBaby()) {
                        front.add("forelegStraight");
                        front.add("forelegSprawled");
                        front.add("forelegSkewed");
                    }
                    front.add("forelegSprawledBack");
                    front.add("forelegSide");
                }
                if (rear.isEmpty()) {
                    rear.add("hindlegStraight");
                    rear.add("hindlegStraightBack");
                    rear.add("hindlegSprawled");
                    rear.add("hindlegSprawledBack");
                    rear.add("hindlegSide");
                }
                if (EventHandlerClient.this.rand.nextBoolean()) {
                    poses[0] = (String)front.get(EventHandlerClient.this.rand.nextInt(front.size()));
                    poses[1] = (String)rear.get(EventHandlerClient.this.rand.nextInt(rear.size()));
                } else {
                    poses[1] = (String)rear.get(EventHandlerClient.this.rand.nextInt(rear.size()));
                    poses[0] = (String)front.get(EventHandlerClient.this.rand.nextInt(front.size()));
                }
                if (poses[0].endsWith("Side") && poses[1].endsWith("Side")) {
                    String side = EventHandlerClient.this.rand.nextBoolean() ? "L" : "R";
                    poses[0] = poses[0] + side;
                    poses[1] = poses[1] + side;
                } else {
                    if (poses[0].endsWith("Side") || poses[0].endsWith("Skewed")) {
                        poses[0] = poses[0] + (EventHandlerClient.this.rand.nextBoolean() ? "L" : "R");
                    }
                    if (poses[1].endsWith("Side")) {
                        poses[1] = poses[1] + (EventHandlerClient.this.rand.nextBoolean() ? "L" : "R");
                    }
                }
                this.setPoses = poses;
            }
            return this.setPoses;
        }
    }
}

