/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.dogslie.common.core;

import java.util.HashMap;
import net.minecraft.Util;
import net.minecraft.client.model.geom.ModelPart;
import org.jetbrains.annotations.Nullable;

public final class ModelHelper {
    public static final HashMap<String, Pos> BASE_POS = (HashMap)Util.make(new HashMap(), m -> {
        m.put("head", new Pos(-1.0f, 13.5f, -7.0f));
        m.put("upper_body", new Pos(0.0f, 14.0f, -3.0f));
        m.put("right_front_leg", new Pos(-1.5f, 16.0f, -4.0f));
        m.put("left_front_leg", new Pos(1.5f, 16.0f, -4.0f));
        m.put("tail", new Pos(-1.0f, 12.0f, 8.0f));
        m.put("body", new Pos(0.0f, 14.0f, 2.0f));
        m.put("right_hind_leg", new Pos(-1.5f, 16.0f, 7.0f));
        m.put("left_hind_leg", new Pos(1.5f, 16.0f, 7.0f));
    });
    private static final HashMap<String, Transformation> TRANSFORMATIONS = (HashMap)Util.make(new HashMap(), m -> {
        float halfPi = 1.5707964f;
        m.put("forelegSideL", new Transformation(true, new PosRot(-1.0f, 20.5f, -7.0f), new PosRot(0.5f, 20.9f, -3.0f, Float.valueOf(halfPi), null, Float.valueOf(-0.956091f)), new PosRot(-1.5f, 23.0f, -4.0f, Float.valueOf(-0.087266f), null, Float.valueOf(-halfPi)), new PosRot(1.5f, 21.0f, -3.0f, Float.valueOf(0.10472f), null, Float.valueOf(-1.320342f))));
        m.put("forelegSideR", new Transformation(true, new PosRot(-1.0f, 20.5f, -7.0f), new PosRot(-0.5f, 20.9f, -3.0f, Float.valueOf(halfPi), null, Float.valueOf(0.956091f)), new PosRot(-1.5f, 21.0f, -3.0f, Float.valueOf(0.10472f), null, Float.valueOf(1.320342f)), new PosRot(1.5f, 23.0f, -4.0f, Float.valueOf(-0.087266f), null, Float.valueOf(halfPi))));
        m.put("forelegStraight", new Transformation(true, new PosRot(-1.0f, 19.0f, -7.0f), new PosRot(0.0f, 20.9f, -3.0f, Float.valueOf(halfPi), Float.valueOf(0.0f), null), new PosRot(-1.5f, 23.0f, -4.0f, Float.valueOf(-halfPi), null, null), new PosRot(1.5f, 23.0f, -4.0f, Float.valueOf(-halfPi), null, null)));
        m.put("forelegSprawled", new Transformation(true, new PosRot(-1.0f, 20.4f, -7.0f), new PosRot(0.0f, 20.9f, -3.0f, Float.valueOf(halfPi), Float.valueOf(0.0f), null), new PosRot(-1.5f, 23.0f, -4.0f, Float.valueOf(-halfPi), Float.valueOf(0.63739425f), null), new PosRot(1.5f, 23.0f, -4.0f, Float.valueOf(-halfPi), Float.valueOf(-0.63739425f), null)));
        m.put("forelegSprawledBack", new Transformation(true, new PosRot(-1.0f, 21.0f, -7.0f), new PosRot(0.0f, 20.9f, -3.0f, Float.valueOf(halfPi), Float.valueOf(0.0f), null), new PosRot(-1.5f, 23.0f, -4.0f, Float.valueOf(halfPi), Float.valueOf(-0.63739425f), null), new PosRot(1.5f, 23.0f, -4.0f, Float.valueOf(halfPi), Float.valueOf(0.63739425f), null)));
        m.put("forelegSkewedL", new Transformation(true, new PosRot(-1.0f, 20.0f, -7.0f), new PosRot(0.0f, 20.9f, -3.0f, Float.valueOf(halfPi), Float.valueOf(0.0f), null), new PosRot(-1.5f, 23.0f, -4.0f, Float.valueOf(-halfPi), Float.valueOf(-0.436332f), null), new PosRot(1.5f, 23.0f, -4.0f, Float.valueOf(-halfPi), Float.valueOf(-0.349066f), null)));
        m.put("forelegSkewedR", new Transformation(true, new PosRot(-1.0f, 20.0f, -7.0f), new PosRot(0.0f, 20.9f, -3.0f, Float.valueOf(halfPi), Float.valueOf(0.0f), null), new PosRot(-1.5f, 23.0f, -4.0f, Float.valueOf(-halfPi), Float.valueOf(0.349066f), null), new PosRot(1.5f, 23.0f, -4.0f, Float.valueOf(-halfPi), Float.valueOf(0.436332f), null)));
        m.put("hindlegSideL", new Transformation(false, new PosRot(-2.0f, 19.8f, 8.0f, null, null, Float.valueOf(-0.610865f)), new PosRot(0.0f, 20.9f, 2.0f, Float.valueOf(halfPi), null, Float.valueOf(-0.610865f)), new PosRot(-0.2f, 23.5f, 6.5f, Float.valueOf(-halfPi), Float.valueOf(-0.956091f), null), new PosRot(1.5f, 23.0f, 7.0f, Float.valueOf(-halfPi), Float.valueOf(-1.365895f), null)));
        m.put("hindlegSideR", new Transformation(false, new PosRot(0.0f, 19.8f, 8.0f, null, null, Float.valueOf(0.610865f)), new PosRot(0.0f, 20.9f, 2.0f, Float.valueOf(halfPi), null, Float.valueOf(0.610865f)), new PosRot(-1.5f, 23.0f, 7.0f, Float.valueOf(-halfPi), Float.valueOf(1.365895f), null), new PosRot(0.2f, 23.5f, 6.5f, Float.valueOf(-halfPi), Float.valueOf(0.956091f), null)));
        m.put("hindlegStraight", new Transformation(false, new PosRot(-1.0f, 19.0f, 8.0f), new PosRot(0.0f, 20.9f, 2.0f, Float.valueOf(halfPi), null, null), new PosRot(-1.5f, 23.0f, 7.0f, Float.valueOf(-halfPi), null, null), new PosRot(1.5f, 23.0f, 7.0f, Float.valueOf(-halfPi), null, null)));
        m.put("hindlegStraightBack", new Transformation(false, new PosRot(-1.0f, 19.0f, 8.0f), new PosRot(0.0f, 20.9f, 2.0f, Float.valueOf(halfPi), null, null), new PosRot(-1.5f, 23.0f, 7.0f, Float.valueOf(halfPi), null, null), new PosRot(1.5f, 23.0f, 7.0f, Float.valueOf(halfPi), null, null)));
        m.put("hindlegSprawled", new Transformation(false, new PosRot(-1.0f, 19.0f, 8.0f), new PosRot(0.0f, 20.9f, 2.0f, Float.valueOf(halfPi), null, null), new PosRot(-1.5f, 23.0f, 7.0f, Float.valueOf(-halfPi), Float.valueOf(0.523599f), null), new PosRot(1.5f, 23.0f, 7.0f, Float.valueOf(-halfPi), Float.valueOf(-0.523599f), null)));
        m.put("hindlegSprawledBack", new Transformation(false, new PosRot(-1.0f, 19.0f, 8.0f), new PosRot(0.0f, 20.9f, 2.0f, Float.valueOf(halfPi), null, null), new PosRot(-1.5f, 23.0f, 7.0f, Float.valueOf(halfPi), Float.valueOf(-0.523599f), null), new PosRot(1.5f, 23.0f, 7.0f, Float.valueOf(halfPi), Float.valueOf(0.523599f), null)));
    });

    public static void transformModel(String[] poses, ModelPart head, ModelPart upperBody, ModelPart rightFrontLeg, ModelPart leftFrontLeg, ModelPart tail, ModelPart body, ModelPart rightHindLeg, ModelPart legHindLeg, float ageScale) {
        Transformation frontTransformation = TRANSFORMATIONS.get(poses[0]);
        Transformation backTransformation = TRANSFORMATIONS.get(poses[1]);
        if (frontTransformation == null || backTransformation == null) {
            throw new RuntimeException("Cannot find transformation for pose: " + poses[0]);
        }
        frontTransformation.transform(head, upperBody, rightFrontLeg, leftFrontLeg, ageScale);
        backTransformation.transform(tail, body, rightHindLeg, legHindLeg, ageScale);
    }

    private static class Transformation {
        private final PosRot transformHeadOrTail;
        private final PosRot transformBody;
        private final PosRot transformRightLeg;
        private final PosRot transformLeftLeg;

        private Transformation(boolean front, PosRot headOrTail, PosRot body, PosRot rightLeg, PosRot leftLeg) {
            if (front) {
                this.transformHeadOrTail = headOrTail.minus(BASE_POS.get("head"));
                this.transformBody = body.minus(BASE_POS.get("upper_body"));
                this.transformRightLeg = rightLeg.minus(BASE_POS.get("right_front_leg"));
                this.transformLeftLeg = leftLeg.minus(BASE_POS.get("left_front_leg"));
            } else {
                this.transformHeadOrTail = headOrTail.minus(BASE_POS.get("tail"));
                this.transformBody = body.minus(BASE_POS.get("body"));
                this.transformRightLeg = rightLeg.minus(BASE_POS.get("right_hind_leg"));
                this.transformLeftLeg = leftLeg.minus(BASE_POS.get("left_hind_leg"));
            }
        }

        private void transform(ModelPart headOrTail, ModelPart body, ModelPart rightLeg, ModelPart leftLeg, float ageScale) {
            this.applyTransformation(headOrTail, this.transformHeadOrTail, ageScale);
            this.applyTransformation(body, this.transformBody, ageScale);
            this.applyTransformation(rightLeg, this.transformRightLeg, ageScale);
            this.applyTransformation(leftLeg, this.transformLeftLeg, ageScale);
        }

        private void applyTransformation(ModelPart part, PosRot transformation, float ageScale) {
            part.x += transformation.pos().x() * ageScale;
            part.y += transformation.pos().y() * ageScale;
            part.z += transformation.pos().z() * ageScale;
            this.applyRot(part, transformation.rot());
        }

        private void applyRot(ModelPart part, @Nullable Rot rot) {
            if (rot != null) {
                if (rot.x() != null) {
                    part.xRot = rot.x().floatValue();
                }
                if (rot.y() != null) {
                    part.yRot = rot.y().floatValue();
                }
                if (rot.z() != null) {
                    part.zRot = rot.z().floatValue();
                }
            }
        }
    }

    private record PosRot(Pos pos, @Nullable Rot rot) {
        public PosRot(float x, float y, float z) {
            this(new Pos(x, y, z), null);
        }

        public PosRot(float x, float y, float z, Float rotX, Float rotY, Float rotZ) {
            this(new Pos(x, y, z), new Rot(rotX, rotY, rotZ));
        }

        public PosRot minus(Pos pos) {
            return new PosRot(this.pos.minus(pos), this.rot);
        }
    }

    private record Pos(float x, float y, float z) {
        public Pos minus(Pos pos) {
            return new Pos(this.x - pos.x, this.y - pos.y, this.z - pos.z);
        }
    }

    private record Rot(@Nullable Float x, @Nullable Float y, @Nullable Float z) {
    }
}

