/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.dogslie.mixin;

import me.ichun.mods.dogslie.common.LetSleepingDogsLie;
import me.ichun.mods.dogslie.common.core.EventHandlerClient;
import me.ichun.mods.dogslie.common.core.ModelHelper;
import net.minecraft.client.model.WolfModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.entity.state.WolfRenderState;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.animal.wolf.Wolf;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={WolfModel.class})
public abstract class WolfModelMixin {
    @Shadow
    @Final
    @Mutable
    private ModelPart head;
    @Shadow
    @Final
    @Mutable
    private ModelPart realHead;
    @Shadow
    @Final
    @Mutable
    private ModelPart body;
    @Shadow
    @Final
    @Mutable
    private ModelPart rightHindLeg;
    @Shadow
    @Final
    @Mutable
    private ModelPart leftHindLeg;
    @Shadow
    @Final
    @Mutable
    private ModelPart rightFrontLeg;
    @Shadow
    @Final
    @Mutable
    private ModelPart leftFrontLeg;
    @Shadow
    @Final
    @Mutable
    private ModelPart tail;
    @Shadow
    @Final
    @Mutable
    private ModelPart realTail;
    @Shadow
    @Final
    @Mutable
    private ModelPart upperBody;

    @Inject(method={"createMeshDefinition"}, at={@At(value="HEAD")}, cancellable=true)
    private static void dogslie$createMeshDefinition(CubeDeformation cubeDeformation, CallbackInfoReturnable<MeshDefinition> cir) {
        MeshDefinition mesh = new MeshDefinition();
        PartDefinition root = mesh.getRoot();
        PartDefinition head = root.addOrReplaceChild("head", CubeListBuilder.create(), PartPose.offset((float)-1.0f, (float)13.5f, (float)-7.0f));
        head.addOrReplaceChild("real_head", CubeListBuilder.create().texOffs(0, 0).addBox(-2.0f, -3.0f, -2.0f, 6.0f, 6.0f, 4.0f, cubeDeformation).texOffs(16, 14).addBox(-2.0f, -5.0f, 0.0f, 2.0f, 2.0f, 1.0f).texOffs(16, 14).addBox(2.0f, -5.0f, 0.0f, 2.0f, 2.0f, 1.0f).texOffs(0, 10).addBox(-0.5f, 0.0f, -5.0f, 3.0f, 3.0f, 4.0f), PartPose.ZERO);
        root.addOrReplaceChild("body", CubeListBuilder.create().texOffs(18, 14).addBox(-3.0f, -2.0f, -3.0f, 6.0f, 9.0f, 6.0f, cubeDeformation), PartPose.offsetAndRotation((float)0.0f, (float)14.0f, (float)2.0f, (float)1.5707964f, (float)0.0f, (float)0.0f));
        root.addOrReplaceChild("upper_body", CubeListBuilder.create().texOffs(21, 0).addBox(-4.0f, -3.0f, -3.0f, 8.0f, 6.0f, 7.0f, cubeDeformation), PartPose.offsetAndRotation((float)0.0f, (float)14.0f, (float)-3.0f, (float)1.5707964f, (float)0.0f, (float)0.0f));
        CubeListBuilder var4 = CubeListBuilder.create().texOffs(0, 18).addBox(-1.0f, 0.0f, -1.0f, 2.0f, 8.0f, 2.0f, cubeDeformation);
        root.addOrReplaceChild("right_hind_leg", var4, PartPose.offset((float)-1.5f, (float)16.0f, (float)7.0f));
        root.addOrReplaceChild("left_hind_leg", var4, PartPose.offset((float)1.5f, (float)16.0f, (float)7.0f));
        root.addOrReplaceChild("right_front_leg", var4, PartPose.offset((float)-1.5f, (float)16.0f, (float)-4.0f));
        root.addOrReplaceChild("left_front_leg", var4, PartPose.offset((float)1.5f, (float)16.0f, (float)-4.0f));
        PartDefinition tail = root.addOrReplaceChild("tail", CubeListBuilder.create(), PartPose.offsetAndRotation((float)-1.0f, (float)12.0f, (float)8.0f, (float)0.62831855f, (float)0.0f, (float)0.0f));
        tail.addOrReplaceChild("real_tail", CubeListBuilder.create().texOffs(9, 18).addBox(0.0f, 0.0f, -1.0f, 2.0f, 8.0f, 2.0f, cubeDeformation), PartPose.ZERO);
        cir.setReturnValue((Object)mesh);
    }

    @Inject(method={"setupAnim(Lnet/minecraft/client/renderer/entity/state/WolfRenderState;)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void dogslie$setupAnim(WolfRenderState renderState, CallbackInfo ci) {
        Wolf wolf = (Wolf)LetSleepingDogsLie.eventHandlerClient.wolfRendered.get();
        if (wolf == null) {
            return;
        }
        ((WolfModel)this).resetPose();
        float f = renderState.walkAnimationPos;
        float g = renderState.walkAnimationSpeed;
        this.tail.yRot = renderState.isAngry ? 0.0f : Mth.cos((float)(f * 0.6662f)) * 1.4f * g;
        if (renderState.isSitting) {
            EventHandlerClient.WolfInfo info = LetSleepingDogsLie.eventHandlerClient.getWolfInfo(wolf);
            if (info.isLying()) {
                float halfPi = 1.5707964f;
                float ageScale = renderState.ageScale;
                String[] poses = info.getCompatiblePoses(wolf);
                if (wolf.getName().getString().equals("iChun")) {
                    this.body.yRot = this.upperBody.yRot = renderState.ageInTicks / 3.5f;
                    this.body.zRot = this.upperBody.zRot = renderState.ageInTicks / 3.5f;
                    this.rightHindLeg.yRot = this.rightFrontLeg.yRot = renderState.ageInTicks / 3.5f;
                    this.leftHindLeg.yRot = this.leftFrontLeg.yRot = -(renderState.ageInTicks / 3.5f);
                    this.rightHindLeg.zRot = this.rightFrontLeg.zRot = renderState.ageInTicks / 5.0f;
                    this.leftHindLeg.zRot = this.leftFrontLeg.zRot = -(renderState.ageInTicks / 5.0f);
                }
                if (renderState.isBaby) {
                    this.head.y -= 1.0f;
                }
                ModelHelper.transformModel(poses, this.head, this.upperBody, this.rightFrontLeg, this.leftFrontLeg, this.tail, this.body, this.rightHindLeg, this.leftHindLeg, ageScale);
            } else {
                float h = renderState.ageScale;
                ModelPart part = this.upperBody;
                part.y += 2.0f * h;
                this.upperBody.xRot = 1.2566371f;
                this.upperBody.yRot = 0.0f;
                part = this.body;
                part.y += 4.0f * h;
                part = this.body;
                part.z -= 2.0f * h;
                this.body.xRot = 0.7853982f;
                part = this.tail;
                part.y += 9.0f * h;
                part = this.tail;
                part.z -= 2.0f * h;
                part = this.rightHindLeg;
                part.y += 6.7f * h;
                part = this.rightHindLeg;
                part.z -= 5.0f * h;
                this.rightHindLeg.xRot = 4.712389f;
                part = this.leftHindLeg;
                part.y += 6.7f * h;
                part = this.leftHindLeg;
                part.z -= 5.0f * h;
                this.leftHindLeg.xRot = 4.712389f;
                this.rightFrontLeg.xRot = 5.811947f;
                part = this.rightFrontLeg;
                part.x += 0.01f * h;
                part = this.rightFrontLeg;
                part.y += 1.0f * h;
                this.leftFrontLeg.xRot = 5.811947f;
                part = this.leftFrontLeg;
                part.x -= 0.01f * h;
                part = this.leftFrontLeg;
                part.y += 1.0f * h;
                this.upperBody.zRot = renderState.getBodyRollAngle(-0.08f);
                this.body.zRot = renderState.getBodyRollAngle(-0.16f);
                this.realTail.zRot = renderState.getBodyRollAngle(-0.2f);
            }
        } else {
            this.rightHindLeg.xRot = Mth.cos((float)(f * 0.6662f)) * 1.4f * g;
            this.leftHindLeg.xRot = Mth.cos((float)(f * 0.6662f + (float)Math.PI)) * 1.4f * g;
            this.rightFrontLeg.xRot = Mth.cos((float)(f * 0.6662f + (float)Math.PI)) * 1.4f * g;
            this.leftFrontLeg.xRot = Mth.cos((float)(f * 0.6662f)) * 1.4f * g;
            this.upperBody.zRot = renderState.getBodyRollAngle(-0.08f);
            this.body.zRot = renderState.getBodyRollAngle(-0.16f);
            this.realTail.zRot = renderState.getBodyRollAngle(-0.2f);
        }
        this.realHead.zRot = renderState.headRollAngle + renderState.getBodyRollAngle(0.0f);
        this.head.xRot = renderState.xRot * ((float)Math.PI / 180);
        this.head.yRot = renderState.yRot * ((float)Math.PI / 180);
        this.tail.xRot = renderState.tailAngle;
        if (LetSleepingDogsLie.eventHandlerClient.getWolfInfo(wolf).isLying()) {
            this.tail.xRot *= 0.5796969f;
        }
        ci.cancel();
    }
}

