/*
 * Decompiled with CFR 0.152.
 */
package levelup2.api;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import levelup2.api.IPlayerSkill;
import levelup2.util.SkillProperties;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.ShapedRecipes;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.ResourceLocation;

public class BaseSkill
implements IPlayerSkill {
    private int[] skillLevels = new int[0];
    private ResourceLocation skillType;
    private ResourceLocation skillName;
    private ResourceLocation[] prereqs = new ResourceLocation[0];
    private int column = 0;
    private int row = 0;
    private boolean enabled = true;
    private boolean active = true;
    private ItemStack repStack;

    public static BaseSkill fromProps(SkillProperties props) {
        BaseSkill skill = new BaseSkill();
        skill.skillName = props.getName();
        skill.skillType = props.getType();
        skill.skillLevels = props.getLevels();
        skill.prereqs = props.getPrerequisites();
        skill.column = props.getColumn();
        skill.row = props.getRow();
        skill.enabled = props.isEnabled();
        skill.active = props.isActive();
        skill.repStack = props.getRepStack();
        return skill;
    }

    public BaseSkill fromJson(JsonObject json) {
        JsonArray prereq;
        BaseSkill skill = new BaseSkill();
        skill.skillType = new ResourceLocation(JsonUtils.func_151200_h((JsonObject)json, (String)"type"));
        skill.skillName = new ResourceLocation(JsonUtils.func_151200_h((JsonObject)json, (String)"name"));
        JsonArray levels = JsonUtils.func_151213_a((JsonObject)json, (String)"levels", null);
        if (levels != null) {
            skill.skillLevels = new int[levels.size()];
            for (int i = 0; i < skill.skillLevels.length; ++i) {
                skill.skillLevels[i] = levels.get(i).getAsInt();
            }
        } else {
            skill.skillLevels = new int[]{-1};
        }
        if ((prereq = JsonUtils.func_151213_a((JsonObject)json, (String)"prerequisites", null)) != null) {
            skill.prereqs = new ResourceLocation[prereq.size()];
            if (skill.prereqs.length != 0) {
                for (int i = 0; i < skill.prereqs.length; ++i) {
                    skill.prereqs[i] = new ResourceLocation(prereq.get(i).getAsString());
                }
            }
        }
        skill.column = JsonUtils.func_151208_a((JsonObject)json, (String)"column", (int)0);
        skill.row = JsonUtils.func_151208_a((JsonObject)json, (String)"row", (int)0);
        skill.enabled = JsonUtils.func_151209_a((JsonObject)json, (String)"enabled", (boolean)true);
        skill.active = JsonUtils.func_151209_a((JsonObject)json, (String)"active", (boolean)true);
        skill.repStack = ShapedRecipes.func_192405_a((JsonObject)JsonUtils.func_152754_s((JsonObject)json, (String)"stack"), (boolean)false);
        return skill;
    }

    @Override
    public void setLevelCosts(int[] levelCosts) {
        this.skillLevels = levelCosts;
    }

    @Override
    public int getLevelCost(int currentLevel) {
        if (currentLevel >= 0 && currentLevel < this.getMaxLevel()) {
            return this.skillLevels[currentLevel];
        }
        return -1;
    }

    @Override
    public ItemStack getRepresentativeStack() {
        return this.repStack != null ? this.repStack : ItemStack.field_190927_a;
    }

    @Override
    public void setRepresentativeStack(ItemStack stack) {
        this.repStack = stack;
    }

    @Override
    public ResourceLocation getSkillType() {
        return this.skillType;
    }

    @Override
    public void setSkillType(ResourceLocation type) {
        this.skillType = type;
    }

    @Override
    public ResourceLocation getSkillName() {
        return this.skillName;
    }

    @Override
    public void setSkillName(ResourceLocation skillName) {
        this.skillName = skillName;
    }

    @Override
    public void setPrerequisites(ResourceLocation[] prerequisites) {
        this.prereqs = prerequisites;
    }

    @Override
    public ResourceLocation[] getPrerequisites() {
        return this.prereqs;
    }

    @Override
    public void setSkillColumn(int column) {
        this.column = column;
    }

    @Override
    public int getSkillColumn() {
        return this.column;
    }

    @Override
    public void setSkillRow(int row) {
        this.row = row;
    }

    @Override
    public int getSkillRow() {
        return this.row;
    }

    @Override
    public int getMaxLevel() {
        return this.skillLevels.length;
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        this.enabled = isEnabled;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public boolean isMaxLevel(int level) {
        return level == this.getMaxLevel();
    }

    @Override
    public boolean isActive() {
        return this.active;
    }

    @Override
    public void setActive(boolean isActive) {
        this.active = isActive;
    }
}

