/*
 * Decompiled with CFR 0.152.
 */
package levelup2.event;

import levelup2.api.ICharacterClass;
import levelup2.api.IPlayerSkill;
import levelup2.capability.PlayerCapability;
import levelup2.config.LevelUpConfig;
import levelup2.network.SkillPacketHandler;
import levelup2.player.IPlayerClass;
import levelup2.skills.SkillRegistry;
import levelup2.util.Library;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;

public class CapabilityEventHandler {
    private static final String BOOK_TAG = "levelup:bookspawn";

    @SubscribeEvent
    public void onPlayerEntersWorld(AttachCapabilitiesEvent<Entity> evt) {
        if (evt.getObject() instanceof EntityPlayer) {
            evt.addCapability(Library.SKILL_LOCATION, (ICapabilityProvider)new ICapabilitySerializable<NBTTagCompound>(){
                IPlayerClass instance = (IPlayerClass)PlayerCapability.PLAYER_CLASS.getDefaultInstance();

                public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
                    return capability == PlayerCapability.PLAYER_CLASS;
                }

                public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
                    return (T)(capability == PlayerCapability.PLAYER_CLASS ? PlayerCapability.PLAYER_CLASS.cast((Object)this.instance) : null);
                }

                public NBTTagCompound serializeNBT() {
                    return (NBTTagCompound)PlayerCapability.PLAYER_CLASS.getStorage().writeNBT(PlayerCapability.PLAYER_CLASS, (Object)this.instance, null);
                }

                public void deserializeNBT(NBTTagCompound tag) {
                    PlayerCapability.PLAYER_CLASS.getStorage().readNBT(PlayerCapability.PLAYER_CLASS, (Object)this.instance, null, (NBTBase)tag);
                }
            });
        }
    }

    @SubscribeEvent
    public void onPlayerClone(PlayerEvent.Clone evt) {
        if (!evt.isWasDeath() || !LevelUpConfig.resetClassOnDeath) {
            NBTTagCompound data = new NBTTagCompound();
            SkillRegistry.getPlayer(evt.getOriginal()).saveNBTData(data);
            SkillRegistry.getPlayer(evt.getEntityPlayer()).loadNBTData(data);
        }
    }

    @SubscribeEvent
    public void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent evt) {
        SkillRegistry.loadPlayer(evt.player);
    }

    @SubscribeEvent
    public void onPlayerChangedDimension(PlayerEvent.PlayerChangedDimensionEvent evt) {
        SkillRegistry.loadPlayer(evt.player);
    }

    @SubscribeEvent
    public void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent evt) {
        if (evt.player instanceof EntityPlayerMP) {
            this.spawnBook(evt.player);
            SkillRegistry.loadPlayer(evt.player);
            SkillPacketHandler.configChannel.sendTo(SkillPacketHandler.getConfigPacket(LevelUpConfig.getServerProperties()), (EntityPlayerMP)evt.player);
            for (ResourceLocation loc : SkillRegistry.getSkills().keySet()) {
                IPlayerSkill skill = SkillRegistry.getSkillFromName(loc);
                SkillPacketHandler.propertyChannel.sendTo(SkillPacketHandler.getPropertyPackets(skill), (EntityPlayerMP)evt.player);
            }
            for (ResourceLocation loc : SkillRegistry.getClasses().keySet()) {
                ICharacterClass cl = SkillRegistry.getClassFromName(loc);
                SkillPacketHandler.classChannel.sendTo(SkillPacketHandler.getClassPackets(cl), (EntityPlayerMP)evt.player);
            }
            SkillPacketHandler.refreshChannel.sendTo(SkillPacketHandler.getRefreshPacket(), (EntityPlayerMP)evt.player);
        }
    }

    private void spawnBook(EntityPlayer player) {
        NBTTagCompound playerData;
        NBTTagCompound data;
        if (LevelUpConfig.giveSkillBook && !(data = this.getTag(playerData = player.getEntityData(), "PlayerPersisted")).func_74767_n(BOOK_TAG)) {
            ItemStack book = new ItemStack(SkillRegistry.skillBook);
            if (!player.func_191521_c(book)) {
                player.func_71019_a(book, true);
            }
            data.func_74757_a(BOOK_TAG, true);
            playerData.func_74782_a("PlayerPersisted", (NBTBase)data);
        }
    }

    private NBTTagCompound getTag(NBTTagCompound base, String tag) {
        if (base == null) {
            return new NBTTagCompound();
        }
        return base.func_74775_l(tag);
    }

    public static double getDivisor(ResourceLocation skill) {
        IPlayerSkill sk = SkillRegistry.getSkillFromName(skill);
        if (sk != null) {
            return SkillRegistry.getProperty(sk).getDivisor();
        }
        return 1.0;
    }
}

