/*
 * Decompiled with CFR 0.152.
 */
package levelup2.event;

import java.util.List;
import java.util.Random;
import levelup2.config.LevelUpConfig;
import levelup2.event.CapabilityEventHandler;
import levelup2.skills.SkillRegistry;
import levelup2.util.Library;
import levelup2.util.PlankCache;
import net.minecraft.block.BlockGravel;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.WorldServer;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.oredict.OreDictionary;

public class MiningSkillHandler {
    public static final MiningSkillHandler INSTANCE = new MiningSkillHandler();
    private static final ResourceLocation TREASUREHUNTING = new ResourceLocation("levelup", "treasurehunting");
    private static final ResourceLocation FLINTLOOT = new ResourceLocation("levelup", "flintloot");
    private static final ResourceLocation PROSPECTING = new ResourceLocation("levelup", "prospecting");
    private static final ResourceLocation LUMBERING = new ResourceLocation("levelup", "lumbering");
    private static final ResourceLocation STONECUTTING = new ResourceLocation("levelup", "stonecutting");
    private static final ResourceLocation WOODCUTTING = new ResourceLocation("levelup", "woodcutting");
    private static final ResourceLocation MINING_BONUS = new ResourceLocation("levelup", "mining_bonus");
    private static final ResourceLocation RAREDIG = new ResourceLocation("levelup", "digging/rare_dig");
    private static final ResourceLocation UNCOMMONDIG = new ResourceLocation("levelup", "digging/uncommon_dig");
    private static final ResourceLocation COMMONDIG = new ResourceLocation("levelup", "digging/common_dig");

    private MiningSkillHandler() {
    }

    @SubscribeEvent
    public void onBlockBreaking(PlayerEvent.BreakSpeed evt) {
        if (evt.getEntityPlayer() != null && !evt.getEntityPlayer().func_130014_f_().field_72995_K && SkillRegistry.getPlayer(evt.getEntityPlayer()).isActive()) {
            int skill = SkillRegistry.getSkillLevel(evt.getEntityPlayer(), STONECUTTING);
            float speed = evt.getNewSpeed();
            if (skill > 0 && evt.getState().func_185904_a() == Material.field_151576_e) {
                float divisor = (float)(CapabilityEventHandler.getDivisor(STONECUTTING) / 20.0);
                float speedMod = 1.0f + (float)skill * divisor;
                evt.setNewSpeed(speed * speedMod);
                return;
            }
            skill = SkillRegistry.getSkillLevel(evt.getEntityPlayer(), WOODCUTTING);
            if (skill > 0 && evt.getState().func_185904_a() == Material.field_151575_d) {
                float divisor = (float)(CapabilityEventHandler.getDivisor(WOODCUTTING) / 20.0);
                float speedMod = 1.0f + (float)skill * divisor;
                evt.setNewSpeed(speed * speedMod);
            }
        }
    }

    @SubscribeEvent
    public void onBlockHarvest(BlockEvent.HarvestDropsEvent evt) {
        if (evt.getHarvester() != null && !evt.getWorld().field_72995_K && SkillRegistry.getPlayer(evt.getHarvester()).isActive()) {
            int skill;
            IBlockState state = evt.getState();
            Random rand = evt.getHarvester().func_70681_au();
            if (!evt.isSilkTouching()) {
                ItemStack test;
                int experience;
                skill = SkillRegistry.getSkillLevel(evt.getHarvester(), TREASUREHUNTING);
                if (skill > 0 && !evt.getDrops().isEmpty() && SkillRegistry.listContains((ItemStack)evt.getDrops().get(0), (List<ItemStack>)OreDictionary.getOres((String)"dirt"))) {
                    ItemStack loot;
                    ItemStack drop = ((ItemStack)evt.getDrops().get(0)).func_77946_l();
                    if (rand.nextFloat() <= (float)skill / (float)CapabilityEventHandler.getDivisor(TREASUREHUNTING) && !(loot = this.getDigLoot(evt.getHarvester())).func_190926_b()) {
                        Library.removeFromList(evt.getDrops(), drop);
                        evt.getDrops().add(loot.func_77946_l());
                        return;
                    }
                }
                if ((skill = SkillRegistry.getSkillLevel(evt.getHarvester(), FLINTLOOT)) > 0 && state.func_177230_c() instanceof BlockGravel && rand.nextInt((int)CapabilityEventHandler.getDivisor(FLINTLOOT)) < skill) {
                    Library.removeFromList(evt.getDrops(), new ItemStack(state.func_177230_c()));
                    evt.getDrops().add(new ItemStack(Items.field_151145_ak));
                    return;
                }
                skill = SkillRegistry.getSkillLevel(evt.getHarvester(), PROSPECTING);
                if (skill > 0 && rand.nextDouble() <= (double)skill / CapabilityEventHandler.getDivisor(PROSPECTING)) {
                    this.getOreChunk(evt);
                } else {
                    this.getSingleChunk(evt);
                }
                skill = SkillRegistry.getSkillLevel(evt.getHarvester(), MINING_BONUS);
                if (skill > 0 && (experience = Library.getExperienceYield(test = new ItemStack(state.func_177230_c(), 1, state.func_177230_c().func_176201_c(state)))) > 0) {
                    evt.getHarvester().func_71023_q(experience);
                }
            }
            if (SkillRegistry.getSkillLevel(evt.getHarvester(), LUMBERING) > 0 && PlankCache.contains(state.func_177230_c(), state.func_177230_c().func_180651_a(state))) {
                ItemStack planks;
                skill = SkillRegistry.getSkillLevel(evt.getHarvester(), LUMBERING);
                double divisor = CapabilityEventHandler.getDivisor(LUMBERING);
                if (rand.nextDouble() <= (double)skill / divisor && !(planks = PlankCache.getProduct(state.func_177230_c(), state.func_177230_c().func_180651_a(state))).func_190926_b()) {
                    evt.getDrops().add(planks.func_77946_l());
                }
                if (rand.nextDouble() <= (double)skill / divisor) {
                    evt.getDrops().add(new ItemStack(Items.field_151055_y, 2));
                }
            }
        }
    }

    private ItemStack getDigLoot(EntityPlayer player) {
        if (!player.func_130014_f_().field_72995_K) {
            LootContext.Builder build = new LootContext.Builder((WorldServer)player.func_130014_f_()).func_186470_a(player);
            build.func_186469_a((float)EnchantmentHelper.func_185284_a((Enchantment)Enchantment.func_180305_b((String)"fortune"), (EntityLivingBase)player) + player.func_184817_da());
            ResourceLocation location = this.getTableFromWeightedPool(player.func_70681_au());
            if (location != null) {
                return (ItemStack)Library.getLootManager().getLootTableFromLocation(location).func_186462_a(player.func_70681_au(), build.func_186471_a()).get(0);
            }
        }
        return ItemStack.field_190927_a;
    }

    private void getSingleChunk(BlockEvent.HarvestDropsEvent evt) {
        ItemStack test;
        ItemStack drop;
        if (!evt.getDrops().isEmpty() && !(drop = Library.getOreChunk(test = (ItemStack)evt.getDrops().get(0), evt.getHarvester().func_70681_au(), 0)).func_190926_b()) {
            drop.func_190920_e(1);
            Library.removeFromList(evt.getDrops(), test);
            evt.getDrops().add(drop.func_77946_l());
        }
    }

    private void getOreChunk(BlockEvent.HarvestDropsEvent evt) {
        if (!evt.getDrops().isEmpty()) {
            ItemStack test = (ItemStack)evt.getDrops().get(0);
            ItemStack drop = Library.getOreChunk(test, evt.getHarvester().func_70681_au(), evt.getFortuneLevel());
            if (!drop.func_190926_b()) {
                Library.removeFromList(evt.getDrops(), test);
                evt.getDrops().add(drop.func_77946_l());
            } else if (!Library.getOreChunk(new ItemStack(evt.getState().func_177230_c(), 1, evt.getState().func_177230_c().func_180651_a(evt.getState())), evt.getHarvester().func_70681_au(), evt.getFortuneLevel()).func_190926_b()) {
                evt.getDrops().addAll(evt.getState().func_177230_c().getDrops((IBlockAccess)evt.getWorld(), evt.getPos(), evt.getState(), evt.getFortuneLevel()));
            }
        }
    }

    private ResourceLocation getTableFromWeightedPool(Random rand) {
        if (LevelUpConfig.combinedChance == 0) {
            return null;
        }
        int RNG = rand.nextInt(LevelUpConfig.combinedChance);
        if (LevelUpConfig.rareChance > 0 && RNG <= LevelUpConfig.rareChance) {
            return RAREDIG;
        }
        if (LevelUpConfig.uncommonChance > 0 && RNG <= LevelUpConfig.rareChance + LevelUpConfig.uncommonChance) {
            return UNCOMMONDIG;
        }
        return COMMONDIG;
    }
}

