/*
 * Decompiled with CFR 0.152.
 */
package levelup2.gui;

import java.util.Map;
import levelup2.api.ICharacterClass;
import levelup2.api.IPlayerSkill;
import levelup2.gui.GuiSkills;
import levelup2.network.SkillPacketHandler;
import levelup2.skills.SkillRegistry;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.ResourceLocation;

public class GuiSkillChoice
extends GuiScreen {
    private IPlayerSkill skill;
    private ICharacterClass cl;
    private GuiSkills parent;
    private int skillLevel;
    private boolean canSpendLevels;
    private boolean canDowngrade;

    public GuiSkillChoice(IPlayerSkill skill, int skillLevel, GuiSkills parent) {
        this.skill = skill;
        this.parent = parent;
        this.cl = SkillRegistry.getClassFromName(parent.player.getPlayerClass());
        this.skillLevel = skillLevel;
        this.canDowngrade = this.isDowngradable(skill, parent);
        this.canSpendLevels = skill.getLevelCost(skillLevel) <= parent.player.getLevelBank() && skill.getLevelCost(skillLevel) > -1 && parent.canUnlock(skill);
    }

    private boolean isDowngradable(IPlayerSkill skill, GuiSkills parent) {
        if (parent.skillTrees.contains(skill.getSkillName())) {
            return false;
        }
        Map<ResourceLocation, Integer> skillList = parent.skills;
        for (ResourceLocation resource : skillList.keySet()) {
            int skillLevel;
            IPlayerSkill check = parent.player.getSkillFromName(resource);
            int n = skillLevel = this.cl != null ? this.cl.getBonusSkillLevel(skill) : 0;
            if (skillList.get(check.getSkillName()) <= skillLevel || check.getPrerequisites() == null || check.getPrerequisites().length <= 0) continue;
            for (ResourceLocation checkStr : check.getPrerequisites()) {
                if (!checkStr.equals((Object)skill.getSkillName()) || skillList.get(skill.getSkillName()) - 1 != 0) continue;
                return false;
            }
        }
        return this.skillLevel > this.cl.getBonusSkillLevel(skill);
    }

    public boolean func_73868_f() {
        return false;
    }

    public void func_73866_w_() {
        this.field_146292_n.clear();
        GuiButton button = new GuiButton(0, this.field_146294_l / 2 - 65, this.field_146295_m / 2 + 35, 130, 20, I18n.func_135052_a((String)"levelup.skill.increase", (Object[])new Object[0]));
        button.field_146124_l = this.canSpendLevels;
        this.field_146292_n.add(button);
        button = new GuiButton(1, this.field_146294_l / 2 - 65, this.field_146295_m / 2 + 60, 130, 20, I18n.func_135052_a((String)"levelup.skill.decrease", (Object[])new Object[0]));
        button.field_146124_l = this.canDowngrade;
        this.field_146292_n.add(button);
        this.field_146292_n.add(new GuiButton(2, this.field_146294_l / 2 - 65, this.field_146295_m / 2 + 85, 130, 20, I18n.func_135052_a((String)"gui.cancel", (Object[])new Object[0])));
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146276_q_();
        this.drawCenteredString(I18n.func_135052_a((String)("skill." + this.skill.getSkillName() + ".name"), (Object[])new Object[0]), this.field_146294_l / 2, this.field_146295_m / 2 - 100, -8355712);
        if (this.skill.isActive()) {
            String line = I18n.func_135052_a((String)(this.skill.getSkillName() + ".desc"), (Object[])new Object[0]);
            this.drawCenteredString(this.checkFormatting(line), this.field_146294_l / 2, this.field_146295_m / 2 - 82, -8355712);
            int lineIncrement = 0;
            line = I18n.func_135052_a((String)(this.skill.getSkillName() + ".desc.1"), (Object[])new Object[0]);
            if (!line.equals(this.skill.getSkillName() + ".desc.1")) {
                ++lineIncrement;
                this.drawCenteredString(this.checkFormatting(line), this.field_146294_l / 2, this.field_146295_m / 2 - 64, -8355712);
                line = I18n.func_135052_a((String)(this.skill.getSkillName() + ".desc.2"), (Object[])new Object[0]);
                if (!line.equals(this.skill.getSkillName() + ".desc.2")) {
                    ++lineIncrement;
                    this.drawCenteredString(this.checkFormatting(line), this.field_146294_l / 2, this.field_146295_m / 2 - 46, -8355712);
                }
            }
            if (this.skill.getLevelCost(this.skillLevel) > -1) {
                int offset = 64 - 18 * lineIncrement;
                this.drawCenteredString(I18n.func_135052_a((String)"levelup.cost", (Object[])new Object[]{this.skill.getLevelCost(this.skillLevel)}), this.field_146294_l / 2, this.field_146295_m / 2 - offset, -8355712);
            }
        } else {
            this.drawCenteredString(I18n.func_135052_a((String)"skill.inactive", (Object[])new Object[0]), this.field_146294_l / 2, this.field_146295_m / 2 - 82, -8355712);
            if (this.skill.getLevelCost(this.skillLevel) > -1) {
                this.drawCenteredString(I18n.func_135052_a((String)"levelup.cost", (Object[])new Object[]{this.skill.getLevelCost(this.skillLevel)}), this.field_146294_l / 2, this.field_146295_m / 2 - 64, -8355712);
            }
        }
        this.drawCenteredString(I18n.func_135052_a((String)"levelup.levels.track", (Object[])new Object[]{this.skillLevel, this.parent.player.getSkillLevel(this.skill.getSkillName(), false)}), this.field_146294_l / 2, this.field_146295_m / 2 + 15, -8355712);
        super.func_73863_a(mouseX, mouseY, partialTicks);
    }

    private String checkFormatting(String str) {
        if (str.startsWith("Format error: ")) {
            str = str.replace("Format error: ", "");
        }
        return str;
    }

    protected void func_146284_a(GuiButton button) {
        int levels = this.parent.player.getLevelBank();
        if (button.field_146127_k == 0) {
            this.changeSkillLevel(1);
            SkillPacketHandler.levelChannel.sendToServer(SkillPacketHandler.getLevelUpPacket(levels - this.skill.getLevelCost(this.skillLevel)));
        } else if (button.field_146127_k == 1) {
            this.changeSkillLevel(-1);
            SkillPacketHandler.levelChannel.sendToServer(SkillPacketHandler.getLevelUpPacket(levels + this.skill.getLevelCost(this.skillLevel - 1)));
        }
        this.field_146297_k.func_147108_a((GuiScreen)this.parent);
    }

    private void drawCenteredString(String str, int posX, int posY, int color) {
        int centerWidth = this.field_146289_q.func_78256_a(str) / 2;
        this.field_146289_q.func_78276_b(str, posX - centerWidth, posY, color);
    }

    private void changeSkillLevel(int add) {
        int orig = this.parent.skills.get(this.skill.getSkillName());
        this.parent.skills.put(this.skill.getSkillName(), orig + add);
    }
}

