/*
 * Decompiled with CFR 0.152.
 */
package levelup2.gui.classselect;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import levelup2.api.ICharacterClass;
import levelup2.gui.classselect.ClassSelectionEntry;
import levelup2.gui.classselect.GuiClassSelect;
import levelup2.skills.SkillRegistry;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiListExtended;
import net.minecraft.util.ResourceLocation;

public class GuiListClassSelection
extends GuiListExtended {
    private final GuiClassSelect classSelect;
    private final List<ClassSelectionEntry> entries = Lists.newArrayList();
    private int selected = -1;

    public GuiListClassSelection(GuiClassSelect parent, Minecraft client, int width, int height, int top, int bottom, int slotHeight) {
        super(client, width, height, top, bottom, slotHeight);
        this.classSelect = parent;
        this.refreshList();
    }

    public ClassSelectionEntry getListEntry(int selected) {
        return this.entries.get(selected);
    }

    protected int func_148127_b() {
        return this.entries.size();
    }

    private void refreshList() {
        ArrayList list = Lists.newArrayList();
        for (ResourceLocation loc : SkillRegistry.getClasses().keySet()) {
            list.add(SkillRegistry.getClassFromName(loc));
        }
        for (ICharacterClass cl : list) {
            this.entries.add(new ClassSelectionEntry(this, this.field_148161_k, cl));
        }
    }

    public void selectClass(int index) {
        this.selected = index;
        this.classSelect.selectClass(this.getSelectedClass());
    }

    public ClassSelectionEntry getSelectedClass() {
        return this.selected >= 0 && this.selected < this.func_148127_b() ? this.entries.get(this.selected) : null;
    }
}

