/*
 * Decompiled with CFR 0.152.
 */
package levelup2.util;

import com.google.common.collect.Lists;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import levelup2.api.IPlayerSkill;
import levelup2.api.PlayerSkillStorage;
import levelup2.skills.SkillRegistry;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.network.ByteBufUtils;

public class ClassProperties {
    private ResourceLocation className;
    private ResourceLocation specSkill;
    private List<BonusSkill> bonusSkills;
    private String localizedName;
    private String description;

    public static ClassProperties fromJson(JsonObject obj) {
        ResourceLocation name = new ResourceLocation(JsonUtils.func_151200_h((JsonObject)obj, (String)"name"));
        ResourceLocation bonus = new ResourceLocation(JsonUtils.func_151200_h((JsonObject)obj, (String)"bonus"));
        ArrayList skills = Lists.newArrayList();
        if (obj.has("skills")) {
            for (JsonElement json : JsonUtils.func_151214_t((JsonObject)obj, (String)"skills")) {
                JsonObject o = json.getAsJsonObject();
                skills.add(new BonusSkill(new ResourceLocation(JsonUtils.func_151200_h((JsonObject)o, (String)"name")), JsonUtils.func_151208_a((JsonObject)o, (String)"level", (int)1)));
            }
        }
        String locName = JsonUtils.func_151219_a((JsonObject)obj, (String)"localized_name", (String)"");
        String description = JsonUtils.func_151219_a((JsonObject)obj, (String)"description", (String)"");
        return new ClassProperties(name, bonus, skills, locName, description);
    }

    public ClassProperties(ResourceLocation name, ResourceLocation spec, List<BonusSkill> skills, String localizedName, String description) {
        this.className = name;
        this.specSkill = spec;
        this.bonusSkills = skills;
        this.localizedName = localizedName;
        this.description = description;
    }

    public ResourceLocation getClassName() {
        return this.className;
    }

    public ResourceLocation getSpecSkill() {
        return this.specSkill;
    }

    public List<PlayerSkillStorage> getBonusSkills() {
        ArrayList storage = Lists.newArrayList();
        for (BonusSkill skill : this.bonusSkills) {
            IPlayerSkill sk = SkillRegistry.getSkillFromName(skill.getSkill());
            if (sk == null) continue;
            storage.add(new PlayerSkillStorage(sk, skill.getPoints()));
        }
        return storage;
    }

    public String getLocalizedName() {
        return this.localizedName;
    }

    public String getDescription() {
        return this.description;
    }

    public void writeToBytes(ByteBuf buf) {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74778_a("Class", this.className.toString());
        tag.func_74778_a("Spec", this.specSkill.toString());
        if (!this.bonusSkills.isEmpty()) {
            NBTTagCompound bonus = new NBTTagCompound();
            bonus.func_74768_a("Size", this.bonusSkills.size());
            for (int i = 0; i < this.bonusSkills.size(); ++i) {
                BonusSkill b = this.bonusSkills.get(i);
                bonus.func_74778_a("name_" + i, b.getSkill().toString());
                bonus.func_74768_a("level_" + i, b.getPoints());
            }
            tag.func_74782_a("Bonus", (NBTBase)bonus);
        }
        tag.func_74778_a("LocName", this.localizedName);
        tag.func_74778_a("Desc", this.description);
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)tag);
    }

    public static ClassProperties fromNBT(NBTTagCompound tag) {
        ResourceLocation name = new ResourceLocation(tag.func_74779_i("Class"));
        ResourceLocation spec = new ResourceLocation(tag.func_74779_i("Spec"));
        ArrayList bSkills = Lists.newArrayList();
        if (tag.func_74764_b("Bonus")) {
            NBTTagCompound bonus = tag.func_74775_l("Bonus");
            for (int i = 0; i < bonus.func_74762_e("Size"); ++i) {
                ResourceLocation bName = new ResourceLocation(bonus.func_74779_i("name_" + i));
                int level = bonus.func_74762_e("level_" + i);
                bSkills.add(new BonusSkill(bName, level));
            }
        }
        String locName = tag.func_74779_i("LocName");
        String desc = tag.func_74779_i("Desc");
        return new ClassProperties(name, spec, bSkills, locName, desc);
    }

    private static class BonusSkill {
        private ResourceLocation skill;
        private int points;

        public BonusSkill(ResourceLocation skill, int points) {
            this.skill = skill;
            this.points = points;
        }

        public ResourceLocation getSkill() {
            return this.skill;
        }

        public int getPoints() {
            return this.points;
        }
    }
}

