/*
 * Decompiled with CFR 0.152.
 */
package levelup2.util;

import levelup2.skills.SkillRegistry;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;

public class StealthLib {
    private static final ResourceLocation STEALTH = new ResourceLocation("levelup", "stealth");

    public static boolean canSeePlayer(EntityLivingBase entity) {
        EntityPlayer player = entity.field_70170_p.func_72890_a((Entity)entity, 16.0);
        return player != null && entity.func_70685_l((Entity)player) && (!player.func_70093_af() || StealthLib.entityHasVisionOf(entity, player));
    }

    public static boolean entityHasVisionOf(EntityLivingBase living, EntityPlayer player) {
        if (living == null || player == null) {
            return false;
        }
        if (StealthLib.getDistanceFrom(living, (EntityLivingBase)player) > 256.0f - (float)SkillRegistry.getSkillLevel(player, STEALTH) * 12.8f) {
            return false;
        }
        return living.func_70685_l((Entity)player) && StealthLib.entityIsFacing((EntityLivingBase)player, living);
    }

    public static float getDistanceFrom(EntityLivingBase living, EntityLivingBase living1) {
        return MathHelper.func_76128_c((double)((living1.field_70165_t - living.field_70165_t) * (living1.field_70165_t - living.field_70165_t) + (living1.field_70161_v - living.field_70161_v) * (living1.field_70161_v - living.field_70161_v)));
    }

    public static boolean entityIsFacing(EntityLivingBase entityLiving, EntityLivingBase entityliving1) {
        if (entityLiving == null || entityliving1 == null) {
            return false;
        }
        float f = -((float)(entityliving1.field_70165_t - entityLiving.field_70165_t));
        float f1 = (float)(entityliving1.field_70161_v - entityLiving.field_70161_v);
        float f2 = entityLiving.field_70177_z;
        if (f2 < 0.0f) {
            float f3 = ((float)MathHelper.func_76141_d((float)(MathHelper.func_76135_e((float)f2) / 360.0f)) + 1.0f) * 360.0f;
            f2 = f3 + f2;
        } else {
            while (f2 > 360.0f) {
                f2 -= 360.0f;
            }
        }
        float f4 = (float)(Math.atan2(f, f1) * 180.0 / Math.PI);
        if (f < 0.0f) {
            f4 = 360.0f + f4;
        }
        return StealthLib.compareAngles(f2, f4, 22.5f);
    }

    private static boolean compareAngles(float f, float f1, float f2) {
        if (MathHelper.func_76135_e((float)(f - f1)) < f2) {
            return true;
        }
        if (f + f2 >= 360.0f && f + f2 - 360.0f > f1) {
            return true;
        }
        return f1 + f2 >= 360.0f && f1 + f2 - 360.0f > f;
    }
}

