/*
 * Decompiled with CFR 0.152.
 */
package caffeinatedpinkie.lightningtweaks;

import caffeinatedpinkie.lightningtweaks.LightningTweaks;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Config(modid="lightningtweaks")
public class ConfigLT {
    @Config.Name(value="Metallic Items Options")
    @Config.Comment(value={"Options for what items should and shouldn't be considered metallic, based on their names."})
    public static ConfigMetallic metallic = new ConfigMetallic();
    @Config.Name(value="Block Search Radius")
    @Config.Comment(value={"This is the radius that the mod will search within around the lightning. The center of the radius is based on the vanilla strike position. A higher radius will take more time to search."})
    @Config.RangeInt(min=0)
    public static int radius = 50;
    @Config.Name(value="Random Strike Position?")
    @Config.Comment(value={"If true, lightning is not guaranteed to strike the block with the highest score. The score of each block will be used as a probability. If false, the block with the highest score will always be chosen."})
    public static boolean randomStrike = true;
    @Config.Name(value="Verbose?")
    @Config.Comment(value={"If true, debug messages will be sent to the client or server console."})
    public static boolean verbose = false;
    @Config.Name(value="Search Weight Options")
    @Config.Comment(value={"Options for the weights that the block scoring system uses. Scores should be between 0 and 1 on default settings, without multipliers."})
    public static ConfigWeight weight = new ConfigWeight();

    @Mod.EventBusSubscriber
    public static class EventHandler {
        @SubscribeEvent
        public static void onConfigChangedEvent(ConfigChangedEvent.OnConfigChangedEvent event) {
            if (event.getModID().equals("lightningtweaks")) {
                ConfigManager.sync((String)"lightningtweaks", (Config.Type)Config.Type.INSTANCE);
                LightningTweaks.refresh();
            }
        }
    }

    public static class ConfigWeight {
        @Config.Name(value="Height Weight")
        @Config.Comment(value={"Specifies the weight for the height of a block when choosing one to strike."})
        @Config.RangeDouble(min=0.0, max=1.0)
        public double heightWeight = 0.7;
        @Config.Name(value="Block Material Weight")
        @Config.Comment(value={"Specifies the weight for the material of a block when choosing one to strike."})
        @Config.RangeDouble(min=0.0, max=1.0)
        public double materialWeight = 0.2;
        @Config.Name(value="Metal Armor Mutliplier")
        @Config.Comment(value={"Specifies the mutliplier of a block's score when an entity is wearing metal armor."})
        @Config.RangeDouble(min=0.0)
        public double metalArmorRatio = 1.25;
        @Config.Name(value="Metal Item Mutliplier")
        @Config.Comment(value={"Specifies the mutliplier of a block's score when an entity is holding a metal item."})
        @Config.RangeDouble(min=0.0)
        public double metalItemRatio = 1.25;
        @Config.Name(value="Non-Player Entity Mutliplier")
        @Config.Comment(value={"Specifies the mutliplier of a block's score when an entity is not a player."})
        @Config.RangeDouble(min=0.0)
        public double nonPlayerEntityRatio = 1.0;
        @Config.Name(value="Player Mutliplier")
        @Config.Comment(value={"Specifies the mutliplier of a block's score when an entity is a player."})
        @Config.RangeDouble(min=0.0)
        public double playerEntityRatio = 1.0;
        @Config.Name(value="Block Shape Weight")
        @Config.Comment(value={"Specifies the weight for the shape of a block when choosing one to strike."})
        @Config.RangeDouble(min=0.0, max=1.0)
        public double shapeWeight = 0.1;
    }

    public static class ConfigMetallic {
        @Config.Name(value="Item Blacklist")
        @Config.Comment(value={"If an item has a word from this list in its name, it will not be considered metallic. Overrides the whitelist. Case is ignored."})
        public String[] blacklist = new String[0];
        @Config.Name(value="Max Level of Recursion")
        @Config.Comment(value={"How many levels in a recipe to check for metallic objects. For example, if only 'nugget' is searched for, 1 = Iron Nugget, 2 = Iron Nugget + Iron Ingot, 3 = Iron Nugget + Iron Ingot + Block of Iron, and 4 = Iron Nugget + Iron Ingot + Block of Iron + Anvil. After some point, increasing this will have no effect."})
        @Config.RangeInt(min=1)
        public int maxRecursion = 3;
        @Config.Name(value="Item Whitelist")
        @Config.Comment(value={"If an item's name or one of an item's ingredients' name has a word from this list, the item will be considered metallic. Overriden by the blacklist. Case is ignored."})
        public String[] whitelist = new String[]{"ingot", "iron", "gold", "nugget"};
    }
}

