/*
 * Decompiled with CFR 0.152.
 */
package caffeinatedpinkie.lightningtweaks.common;

import caffeinatedpinkie.lightningtweaks.ConfigLT;
import caffeinatedpinkie.lightningtweaks.LoggerLT;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import org.apache.commons.lang3.StringUtils;

public class AttributeMetallic {
    public static Set<String> items = new HashSet<String>();
    public static Set<String> visited = new HashSet<String>();
    public static Multimap<String, String> recipes = HashMultimap.create();

    public static boolean containsIgnoreCase(String[] searchStrings, String str) {
        for (String searchStr : searchStrings) {
            if (!StringUtils.containsIgnoreCase((CharSequence)str, (CharSequence)searchStr)) continue;
            return true;
        }
        return false;
    }

    public static boolean isMetallic(IBlockState state) {
        return items.contains(new ItemStack(state.func_177230_c()).func_77977_a());
    }

    public static boolean isMetallic(ItemStack stack) {
        return items.contains(stack.func_77977_a());
    }

    public static void postInit(FMLPostInitializationEvent event) {
        AttributeMetallic.setRecipes();
        AttributeMetallic.setItems();
    }

    public static void registerMetallic(String itemKey, int level, Set<String> visited) {
        if (level < ConfigLT.metallic.maxRecursion && visited.add(itemKey)) {
            items.add(itemKey);
            recipes.get((Object)itemKey).forEach(outputKey -> AttributeMetallic.registerMetallic(outputKey, level + 1, visited));
        }
    }

    public static void setItems() {
        LoggerLT.log(() -> {
            items.clear();
            ForgeRegistries.ITEMS.forEach(item -> {
                String itemKey = new ItemStack(item).func_77977_a();
                if (!AttributeMetallic.containsIgnoreCase(ConfigLT.metallic.blacklist, itemKey) && AttributeMetallic.containsIgnoreCase(ConfigLT.metallic.whitelist, itemKey)) {
                    visited.clear();
                    AttributeMetallic.registerMetallic(itemKey, 0, visited);
                }
            });
        }, "Metallic item list populated");
        LoggerLT.log("Found " + items.size() + " items: " + items);
    }

    public static void setRecipes() {
        LoggerLT.log(() -> {
            recipes.clear();
            ForgeRegistries.RECIPES.forEach(recipe -> {
                ItemStack outputStack = recipe.func_77571_b();
                if (!outputStack.func_190926_b()) {
                    String outputKey = outputStack.func_77977_a();
                    for (Ingredient ingredient : recipe.func_192400_c()) {
                        for (ItemStack matchingStack : ingredient.func_193365_a()) {
                            recipes.put((Object)matchingStack.func_77977_a(), (Object)outputKey);
                        }
                    }
                }
            });
        }, "Recipe list populated");
    }
}

