/*
 * Decompiled with CFR 0.152.
 */
package caffeinatedpinkie.lightningtweaks.common;

import caffeinatedpinkie.lightningtweaks.LoggerLT;
import caffeinatedpinkie.lightningtweaks.common.AttributeMetallic;
import caffeinatedpinkie.lightningtweaks.common.Searcher;
import caffeinatedpinkie.lightningtweaks.compatibility.Compatibility;
import caffeinatedpinkie.lightningtweaks.compatibility.CompatibilityWeather2;
import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.entity.Entity;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Mod.EventBusSubscriber
public class LightningHandler {
    public static boolean effectOnly(World world, BlockPos pos) {
        return AttributeMetallic.isMetallic(world.func_180495_p(pos.func_177977_b()));
    }

    public static boolean effectOnlyIn(Entity lightning) {
        return Compatibility.isVanillaLightning(lightning) && (Boolean)ObfuscationReflectionHelper.getPrivateValue(EntityLightningBolt.class, (Object)((EntityLightningBolt)lightning), (String)"field_184529_d") != false || Compatibility.weather2 && CompatibilityWeather2.isLightning(lightning) && !CompatibilityWeather2.firesEnabled();
    }

    public static boolean fireOnConstruction(World world, Entity lightning, boolean effectOnlyIn) {
        return !effectOnlyIn && world.func_82736_K().func_82766_b("doFireTick") && (world.func_175659_aa() == EnumDifficulty.NORMAL || world.func_175659_aa() == EnumDifficulty.HARD) && world.func_175697_a(lightning.func_180425_c(), 10);
    }

    public static boolean isLightning(Entity entity) {
        return Compatibility.isVanillaLightning(entity) || Compatibility.weather2 && CompatibilityWeather2.isLightning(entity);
    }

    public static void moveLightning(Entity lightning, BlockPos pos) {
        LoggerLT.log(() -> lightning.func_70107_b((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p()), "Lightning moved");
    }

    public static void removeOnConstructionFire(World world, Entity lightning, boolean fireOnConstruction) {
        if (fireOnConstruction) {
            LoggerLT.log(() -> {
                BlockPos blockpos = new BlockPos(lightning);
                for (int i = -1; i <= 1; ++i) {
                    for (int j = -1; j <= 1; ++j) {
                        for (int k = -1; k <= 1; ++k) {
                            BlockPos posToCheck = blockpos.func_177982_a(i, j, k);
                            if (world.func_180495_p(posToCheck).func_177230_c() != Blocks.field_150480_ab) continue;
                            world.func_175698_g(posToCheck);
                        }
                    }
                }
            }, "Fire created on lightning bolt construction removed");
        }
    }

    public static void respawnOnConstructionFire(World world, Entity lightning, BlockPos pos, boolean fireOnConstruction, boolean effectOnly) {
        if (fireOnConstruction && !effectOnly) {
            LoggerLT.log(() -> {
                if (Compatibility.isVanillaLightning(lightning)) {
                    new EntityLightningBolt(world, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), false);
                } else if (Compatibility.weather2) {
                    CompatibilityWeather2.respawnOnConstructionFire(world, lightning, pos, effectOnly, fireOnConstruction);
                }
            }, "Fire around new location created");
        }
    }

    public static void setEffectOnly(Entity lightning, boolean fireOnConstruction, boolean effectOnly, boolean effectOnlyIn) {
        LoggerLT.log(() -> {
            if (!effectOnlyIn) {
                if (Compatibility.isVanillaLightning(lightning)) {
                    ObfuscationReflectionHelper.setPrivateValue(EntityLightningBolt.class, (Object)((EntityLightningBolt)lightning), (Object)effectOnly, (String)"field_184529_d");
                } else if (Compatibility.weather2) {
                    CompatibilityWeather2.setEffectOnly(lightning, effectOnly);
                }
            }
        }, "Set whether fire should be created at new location");
    }

    public static ArrayList<Entity> weatherEffectsArray(final World world) {
        return new ArrayList<Entity>((Collection)world.field_73007_j){

            @Override
            public boolean add(Entity entity) {
                LoggerLT.log(() -> {
                    if (LightningHandler.isLightning(entity)) {
                        Searcher searcher = new Searcher(world, entity);
                        BlockPos pos = searcher.search();
                        boolean effectOnlyIn = LightningHandler.effectOnlyIn(entity);
                        boolean fireOnConstruction = LightningHandler.fireOnConstruction(world, entity, effectOnlyIn);
                        boolean effectOnly = effectOnlyIn || LightningHandler.effectOnly(world, pos);
                        LightningHandler.removeOnConstructionFire(world, entity, fireOnConstruction);
                        LightningHandler.setEffectOnly(entity, fireOnConstruction, effectOnly, effectOnlyIn);
                        LightningHandler.moveLightning(entity, pos);
                        LightningHandler.respawnOnConstructionFire(world, entity, pos, fireOnConstruction, effectOnly);
                    } else {
                        LoggerLT.log("EntityWeatherEffect skipped.");
                    }
                }, "EntityWeatherEffect caught and returned to the server");
                return super.add(entity);
            }
        };
    }

    @SubscribeEvent
    public static void worldLoaded(WorldEvent.Load event) {
        World world = event.getWorld();
        if (!world.field_72995_K) {
            LoggerLT.log(() -> ObfuscationReflectionHelper.setPrivateValue(World.class, (Object)world, LightningHandler.weatherEffectsArray(world), (String)"field_73007_j"), "Replaced weatherEffects in dimension " + world.field_73011_w.getDimension());
        }
    }
}

