/*
 * Decompiled with CFR 0.152.
 */
package caffeinatedpinkie.lightningtweaks.common;

import caffeinatedpinkie.lightningtweaks.ConfigLT;
import caffeinatedpinkie.lightningtweaks.LoggerLT;
import caffeinatedpinkie.lightningtweaks.common.AttributeMetallic;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.SplittableRandom;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import org.apache.commons.lang3.mutable.MutableDouble;
import org.apache.commons.lang3.tuple.Pair;

public class Searcher {
    public static SplittableRandom random = new SplittableRandom();
    public int blocks;
    public int maxHeight;
    public Map<BlockPos, Entity> heightMap = new HashMap<BlockPos, Entity>();
    public Entity lightning;
    public World world;

    public static BlockPos getRandomBlock(Collection<Pair<Double, List<BlockPos>>> probabilities, double totalCumulativeProbability) {
        double randomValue = random.nextDouble(totalCumulativeProbability);
        for (Map.Entry entry : probabilities) {
            if (!(randomValue < (Double)entry.getKey())) continue;
            return Searcher.getRandomBlock((List)entry.getValue());
        }
        return null;
    }

    public static BlockPos getRandomBlock(List<BlockPos> poses) {
        return poses.get(random.nextInt(poses.size()));
    }

    public static boolean isEntityHoldingMetallicItem(EntityLivingBase entity) {
        return AttributeMetallic.isMetallic(entity.func_184614_ca()) || AttributeMetallic.isMetallic(entity.func_184592_cb());
    }

    public static boolean isEntityWearingMetallicArmor(Entity entity) {
        for (ItemStack itemStack : entity.func_184193_aE()) {
            if (!AttributeMetallic.isMetallic(itemStack)) continue;
            return true;
        }
        return false;
    }

    public Searcher(World world, Entity lightning) {
        this.lightning = lightning;
        this.world = world;
        this.populateHeightMap();
    }

    public boolean entityWithinRadius(Entity entity) {
        return Math.sqrt(Math.pow(entity.field_70165_t - this.lightning.field_70165_t, 2.0) + Math.pow(entity.field_70161_v - this.lightning.field_70161_v, 2.0)) <= (double)ConfigLT.radius;
    }

    public BlockPos getNonRandomPosition() {
        double greatestScore = 0.0;
        ArrayList<BlockPos> poses = new ArrayList<BlockPos>();
        for (Map.Entry<BlockPos, Entity> entry : this.heightMap.entrySet()) {
            double score = this.score(entry.getKey(), entry.getValue());
            if (!(score >= greatestScore)) continue;
            if (score != greatestScore) {
                greatestScore = score;
                poses.clear();
            }
            poses.add(entry.getKey());
        }
        return Searcher.getRandomBlock(poses);
    }

    public BlockPos getPosition(Entity entity) {
        return new BlockPos(entity.func_174824_e(1.0f));
    }

    public BlockPos getRandomPosition() {
        MutableDouble cumulativeProbability = new MutableDouble();
        LinkedHashMap probabilities = new LinkedHashMap();
        this.heightMap.forEach((pos, entity) -> ((List)probabilities.computeIfAbsent(this.score((BlockPos)pos, (Entity)entity), probability -> Pair.of((Object)cumulativeProbability.addAndGet((Number)probability), new ArrayList())).getRight()).add(pos));
        return Searcher.getRandomBlock(probabilities.values(), cumulativeProbability.doubleValue());
    }

    public BlockPos getTopSolidOrLiquidBlock(BlockPos pos) {
        BlockPos blockpos1;
        IBlockState state;
        Chunk chunk = this.world.func_175726_f(pos);
        BlockPos blockpos = new BlockPos(pos.func_177958_n(), chunk.func_76625_h() + 16, pos.func_177952_p());
        while (blockpos.func_177956_o() >= 0 && !(state = chunk.func_177435_g(blockpos1 = blockpos.func_177977_b())).func_185904_a().func_76230_c()) {
            blockpos = blockpos1;
        }
        return blockpos;
    }

    public void populateHeightMap() {
        LoggerLT.log(() -> {
            for (double x = this.lightning.field_70165_t - (double)ConfigLT.radius; x <= this.lightning.field_70165_t + (double)ConfigLT.radius; x += 1.0) {
                double zDifference = Math.sqrt(Math.pow(ConfigLT.radius, 2.0) - Math.pow(x - this.lightning.field_70165_t, 2.0));
                for (double z = this.lightning.field_70161_v - zDifference; z <= this.lightning.field_70161_v + zDifference; z += 1.0) {
                    BlockPos pos = this.getTopSolidOrLiquidBlock(new BlockPos(x, 0.0, z)).func_177977_b();
                    if (pos.func_177956_o() < 0) continue;
                    this.heightMap.put(pos, null);
                    this.maxHeight = Math.max(this.maxHeight, pos.func_177956_o());
                }
            }
            if (ConfigLT.weight.playerEntityRatio > 0.0) {
                this.world.field_73010_i.forEach(player -> {
                    if (this.entityWithinRadius((Entity)player)) {
                        this.heightMap.put(this.getPosition((Entity)player), (Entity)player);
                    }
                });
            }
            if (ConfigLT.weight.nonPlayerEntityRatio > 0.0) {
                this.world.func_72910_y().forEach(entity -> {
                    if (entity instanceof EntityLiving && this.entityWithinRadius((Entity)entity)) {
                        this.heightMap.put(this.getPosition((Entity)entity), (Entity)entity);
                    }
                });
            }
        }, "Height map populated");
        LoggerLT.log("Processed " + this.heightMap.size() + " blocks.");
    }

    public double score(BlockPos pos, @Nullable Entity entity) {
        IBlockState state = this.world.func_180495_p(pos);
        double score = ConfigLT.weight.heightWeight * (double)pos.func_177956_o() / (double)this.maxHeight;
        if (AttributeMetallic.isMetallic(state)) {
            score += ConfigLT.weight.materialWeight;
        }
        if (!this.world.func_175623_d(pos) && !state.func_185917_h()) {
            score += ConfigLT.weight.shapeWeight;
        }
        if (entity != null) {
            if (Searcher.isEntityWearingMetallicArmor(entity)) {
                score *= ConfigLT.weight.metalArmorRatio;
            }
            if (Searcher.isEntityHoldingMetallicItem((EntityLivingBase)entity)) {
                score *= ConfigLT.weight.metalItemRatio;
            }
            score *= entity instanceof EntityPlayer ? ConfigLT.weight.playerEntityRatio : ConfigLT.weight.nonPlayerEntityRatio;
        }
        return score;
    }

    public BlockPos search() {
        LoggerLT.log("Searching...");
        if (this.heightMap.isEmpty()) {
            LoggerLT.log("No blocks found. Returning...");
            return this.lightning.func_180425_c();
        }
        return (ConfigLT.randomStrike ? this.getRandomPosition() : this.getNonRandomPosition()).func_177984_a();
    }
}

