/*
 * Decompiled with CFR 0.152.
 */
package lightningtweaks.common;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.SplittableRandom;
import lightningtweaks.LightningTweaks;
import lightningtweaks.common.LTConfig;
import lightningtweaks.common.event.EntityHandler;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.effect.LightningBoltEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Difficulty;
import net.minecraft.world.GameRules;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.Heightmap;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;

public class GlobalEntitiesList
extends ArrayList<Entity> {
    public static SplittableRandom random = new SplittableRandom();
    public World world;

    public GlobalEntitiesList(World world) {
        this.world = world;
    }

    @Override
    public boolean add(Entity entity) {
        if (entity.func_200600_R() == EntityType.field_200728_aG) {
            Difficulty difficulty;
            if (ObfuscationReflectionHelper.getPrivateValue(LightningBoltEntity.class, (Object)((LightningBoltEntity)entity), (String)"field_204810_e") == null) {
                if (LTConfig.doRealisticLightning()) {
                    this.moveLightning(entity);
                }
                if (!LTConfig.doSpawnFire() || LTConfig.getMetallicItems().contains(this.world.func_180495_p(entity.func_180425_c().func_177972_a(Direction.DOWN)).func_177230_c().func_199767_j())) {
                    this.setEffectOnly(entity);
                }
            }
            if (EntityHandler.removeDoFireTick(this.world)) {
                this.revertDoFireTick();
            }
            if ((difficulty = this.world.func_175659_aa()) == Difficulty.NORMAL || difficulty == Difficulty.HARD) {
                this.igniteBlocks(entity);
            }
        }
        return super.add(entity);
    }

    public BlockPos getBlockPos(Entity entity) {
        IChunk chunk = this.world.func_217349_x(entity.func_180425_c());
        Heightmap heightmap = chunk.func_217303_b(Heightmap.Type.MOTION_BLOCKING);
        int max = 0;
        ArrayList<BlockPos> poses = new ArrayList<BlockPos>();
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                int height = heightmap.func_202273_a(x, z);
                if (height > max) {
                    max = height;
                    poses.clear();
                }
                if (height != max) continue;
                poses.add(new BlockPos(x, height, z));
            }
        }
        BlockPos pos = (BlockPos)poses.get(random.nextInt(poses.size()));
        return chunk.func_76632_l().func_180331_a(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
    }

    public void igniteBlocks(Entity entity) {
        try {
            int extraIgnitions = LTConfig.getExtraIgnitions();
            LightningTweaks.log("Invoking LightningBoltEntity#igniteBlocks(" + extraIgnitions + ") at " + entity.func_180425_c(), this.world);
            ObfuscationReflectionHelper.findMethod(LightningBoltEntity.class, (String)"func_195053_a", (Class[])new Class[]{Integer.TYPE}).invoke((Object)entity, extraIgnitions);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    public void moveLightning(Entity entity) {
        BlockPos pos = this.getBlockPos(entity);
        LightningTweaks.log("Moving lightning from " + entity.func_180425_c() + " to " + pos, this.world);
        entity.func_70107_b((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p());
    }

    public void revertDoFireTick() {
        LightningTweaks.log("Reverting " + GameRules.field_223598_a + " to true", this.world);
        EntityHandler.revertDoFireTick(this.world);
    }

    public void setEffectOnly(Entity entity) {
        LightningTweaks.log("Setting LightningBoltEntity#effectOnly to true at " + entity.func_180425_c(), this.world);
        ObfuscationReflectionHelper.setPrivateValue(LightningBoltEntity.class, (Object)((LightningBoltEntity)entity), (Object)true, (String)"field_184529_d");
    }
}

