/*
 * Decompiled with CFR 0.152.
 */
package lightningtweaks.common;

import com.google.common.collect.ImmutableList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import lightningtweaks.LightningTweaks;
import net.minecraft.item.Item;
import net.minecraft.util.text.LanguageMap;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.tuple.Pair;

@Mod.EventBusSubscriber
public class LTConfig {
    public static Pair<Common, ForgeConfigSpec> pair = new ForgeConfigSpec.Builder().configure(Common::new);

    public static boolean doRealisticLightning() {
        return (Boolean)((Common)LTConfig.pair.getLeft()).realisticLightning.get();
    }

    public static boolean doSpawnFire() {
        return (Boolean)((Common)LTConfig.pair.getLeft()).spawnFire.get();
    }

    public static int getExtraIgnitions() {
        return (Integer)((Common)LTConfig.pair.getLeft()).extraIgnitions.get();
    }

    public static Set<Item> getMetallicItems() {
        return ((Common)LTConfig.pair.getLeft()).metallicItems;
    }

    public static boolean isVerbose() {
        return (Boolean)((Common)LTConfig.pair.getLeft()).verbose.get();
    }

    public static void register() {
        LightningTweaks.log("Registering configuration file.");
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (ForgeConfigSpec)pair.getRight());
        Set<Item> metallicItems = ((Common)LTConfig.pair.getLeft()).metallicItems;
        metallicItems.clear();
        ((List)((Common)LTConfig.pair.getLeft()).metallicKeywords.get()).forEach(keyword -> {
            keyword = keyword.toLowerCase();
            LanguageMap languageMap = LanguageMap.func_74808_a();
            for (Item item : ForgeRegistries.ITEMS) {
                if (!languageMap.func_74805_b(item.func_77658_a()).toLowerCase().contains((CharSequence)keyword)) continue;
                metallicItems.add(item);
            }
        });
        LightningTweaks.log("Stored the following items as metallic: " + metallicItems + '.');
    }

    public static class Common {
        public ForgeConfigSpec.IntValue extraIgnitions;
        public Set<Item> metallicItems;
        public ForgeConfigSpec.ConfigValue<List<String>> metallicKeywords;
        public ForgeConfigSpec.BooleanValue realisticLightning;
        public ForgeConfigSpec.BooleanValue spawnFire;
        public ForgeConfigSpec.BooleanValue verbose;

        public Common(ForgeConfigSpec.Builder builder) {
            this.extraIgnitions = builder.comment(new String[]{"How many extra fires should be spawned around where the lightning strikes.", "The vanilla value is 4."}).defineInRange("Extra Ignitions", 4, 0, Integer.MAX_VALUE);
            this.metallicItems = new HashSet<Item>();
            this.metallicKeywords = builder.comment(new String[]{"Keywords used to determine what items and blocks are considered metallic. An item or block is considered metallic if any of the keywords are contained within its localized name.", "Case does not matter."}).define("Metallic Keywords", (Object)ImmutableList.of((Object)"gold", (Object)"iron"));
            this.realisticLightning = builder.comment("Should lightning strike high or metal blocks more often? This is the main behavior of this mod.").define("Realistic Lightning", true);
            this.spawnFire = builder.comment(new String[]{"Should lightning spawn fire where it strikes?", "Only changes the behavior of lightning that would have otherwise spawned fire.", "This also prevents entities from getting set on fire or damaged from lightning."}).define("Spawn Fire", true);
            this.verbose = builder.comment("Should log messages for this mod be posted?").define("Verbose", true);
        }
    }
}

