/*
 * Decompiled with CFR 0.152.
 */
package toast.lostBooks.book;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import toast.lostBooks.LostBooks;
import toast.lostBooks.book.BookProperties;
import toast.lostBooks.book.BookStats;
import toast.lostBooks.book.IBook;
import toast.lostBooks.book.LostBookStats;
import toast.lostBooks.config.PropertyHelper;
import toast.lostBooks.helper.BookHelper;
import toast.lostBooks.helper.FileHelper;
import toast.lostBooks.helper.RandomHelper;

public class LostBookCollection
implements IBook {
    public static final String F = "\f";
    public static File BOOK_DIRECTORY;

    public LostBookCollection(String category) {
    }

    public void capture(ItemStack book) {
        if (book == null || book.func_77942_o()) {
            return;
        }
        try {
            String fileName = "";
            for (char letter : book.func_77978_p().func_74779_i("title").toCharArray()) {
                if (!Character.isLetterOrDigit(letter)) continue;
                fileName = fileName + Character.toString(letter);
            }
            File save = new File(BOOK_DIRECTORY, fileName + ".dat");
            if (save.exists()) {
                int attempt;
                for (attempt = 0; attempt < 100 && (save = new File(BOOK_DIRECTORY, fileName + attempt + ".dat")).exists(); ++attempt) {
                }
                if (attempt > 99) {
                    return;
                }
                fileName = fileName + attempt;
            }
            CompressedStreamTools.func_74799_a((NBTTagCompound)book.func_77955_b(new NBTTagCompound()), (OutputStream)new FileOutputStream(save));
            book.func_190920_e(0);
        }
        catch (Exception ex) {
            LostBooks.console("Failed to capture lost book!");
            ex.printStackTrace();
        }
    }

    private IBook[] loadBooks() {
        try {
            File[] bookFiles = BOOK_DIRECTORY.listFiles(new FileHelper.ExtensionFilter(".dat"));
            ArrayList<LostBookStats> books = new ArrayList<LostBookStats>(bookFiles.length);
            for (File file : bookFiles) {
                try {
                    new FileInputStream(file).close();
                    books.add(new LostBookStats(file));
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            return books.toArray(new IBook[0]);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return new IBook[0];
        }
    }

    @Override
    public String getName() {
        return BOOK_DIRECTORY.getName();
    }

    @Override
    public String getId() {
        return null;
    }

    @Override
    public BookStats getBookStats(EntityLivingBase entity) {
        IBook book = RandomHelper.choose(entity, this.loadBooks());
        return book == null ? null : book.getBookStats(entity);
    }

    @Override
    public BookStats getBookStatsSpawn(EntityPlayer player) {
        IBook book = RandomHelper.chooseSpawn(player, this.loadBooks());
        return book == null ? null : book.getBookStatsSpawn(player);
    }

    @Override
    public BookStats getBookStatsTrade(EntityLivingBase entity) {
        IBook book = RandomHelper.chooseTrade(entity, this.loadBooks());
        return book == null ? null : book.getBookStatsTrade(entity);
    }

    @Override
    public boolean isValid(EntityLivingBase entity) {
        return this.getWeight() > 0 && this.size() > 0 && BookHelper.canBookDrop(entity, BookProperties.getEntityList("LostBooks.cfg", PropertyHelper.getString("lostBookProperties", "whitelist")), BookProperties.getEntityList("LostBooks.cfg", PropertyHelper.getString("lostBookProperties", "blacklist")), BookProperties.getIdSet("LostBooks.cfg", PropertyHelper.getString("lostBookProperties", "biomes")));
    }

    @Override
    public boolean isValidSpawn(EntityPlayer player) {
        return this.getWeight() > 0 && this.size() > 0;
    }

    @Override
    public boolean isValidTrade(EntityLivingBase entity) {
        return this.getWeight() > 0 && this.size() > 0;
    }

    @Override
    public int getWeight() {
        return PropertyHelper.getInt("general", "lostBookWeight");
    }

    @Override
    public int size() {
        try {
            return BOOK_DIRECTORY.listFiles(new FileHelper.ExtensionFilter(".dat")).length;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return 0;
        }
    }
}

