/*
 * Decompiled with CFR 0.152.
 */
package toast.lostBooks.event;

import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraftforge.event.entity.item.ItemExpireEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import toast.lostBooks.Blackouts;
import toast.lostBooks.TickHandler;
import toast.lostBooks.book.Library;
import toast.lostBooks.config.PropertyHelper;
import toast.lostBooks.helper.BookHelper;

@Mod.EventBusSubscriber(value={Side.CLIENT})
public class EventHandler {
    @SubscribeEvent
    public static void onLivingDrops(LivingDropsEvent event) {
        ItemStack book;
        if (event.getEntityLiving() == null || event.getEntityLiving().field_70170_p.field_72995_K) {
            return;
        }
        if (event.isRecentlyHit() && PropertyHelper.getBoolean("general", "dropRate", event.getEntityLiving().func_70681_au()) && (book = Library.nextBook(event.getEntityLiving())) != null) {
            EntityItem drop = new EntityItem(event.getEntityLiving().field_70170_p, event.getEntityLiving().field_70165_t, event.getEntityLiving().field_70163_u, event.getEntityLiving().field_70161_v, book);
            drop.func_174867_a(10);
            event.getDrops().add(drop);
        }
    }

    @SubscribeEvent
    public static void onEntityItemPickup(EntityItemPickupEvent event) {
        if (event.getEntityPlayer() == null || event.getEntityPlayer().field_70170_p.field_72995_K) {
            return;
        }
        ItemStack book = event.getItem().func_92059_d();
        String id = BookHelper.getBookId(book);
        if (id != null && id != "") {
            if (BookHelper.isBookFound(event.getEntityPlayer(), id)) {
                if (PropertyHelper.getBoolean("general", "hardUniqueBlackouts")) {
                    event.setCanceled(true);
                    return;
                }
            } else if (Blackouts.DROP_BLACKOUTS) {
                BookHelper.markBookAsFound(event.getEntityPlayer(), id);
                TickHandler.unloadBlackouts(event.getEntityPlayer().field_70170_p);
            }
        }
        if (!event.getItem().field_70170_p.field_72995_K && BookHelper.removeBookId(book)) {
            event.getItem().func_92058_a(book);
        }
    }

    @SubscribeEvent
    public static void onItemExpire(ItemExpireEvent event) {
        ItemStack book;
        if (PropertyHelper.getBoolean("general", "lostBookCaptureRate") && !event.isCanceled() && (book = event.getEntityItem().func_92059_d()).func_77973_b().func_77657_g(book).equals("item.writtenBook") && !BookHelper.hasBookId(book)) {
            Library.LOST_BOOKS.capture(book);
            if (!event.getEntityItem().field_70170_p.field_72995_K) {
                event.getEntityItem().func_92058_a(book);
            }
        }
    }

    @SubscribeEvent
    public static void onWorldUnload(WorldEvent.Unload event) {
        if (event.getWorld() != null && !event.getWorld().field_72995_K) {
            TickHandler.unloadBlackouts(event.getWorld());
        }
    }
}

