/*
 * Decompiled with CFR 0.152.
 */
package toast.lostBooks.gui;

import com.google.common.collect.Lists;
import com.google.gson.JsonParseException;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiScreenBook;
import net.minecraft.client.gui.GuiUtilRenderComponents;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemWrittenBook;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.network.Packet;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.play.client.CPacketCustomPayload;
import net.minecraft.util.ChatAllowedCharacters;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL11;
import toast.lostBooks.LostBooks;
import toast.lostBooks.MessageCurrPage;
import toast.lostBooks.helper.BookHelper;

@SideOnly(value=Side.CLIENT)
public class GuiScreenBookUtil
extends GuiScreen {
    private static final Logger logger = LogManager.getLogger();
    private static final ResourceLocation bookGuiTextures = new ResourceLocation("textures/gui/book.png");
    public final ItemStack book;
    private final boolean pauseGame;
    private final EntityPlayer editingPlayer;
    private final boolean bookIsUnsigned;
    private final int bookImageWidth = 192;
    private boolean bookIsModified;
    private int cachedPage = -1;
    private int updateCount;
    public final int bookImageHeight = 192;
    private int bookTotalPages = 1;
    private int currPage;
    private int lastCurrPage;
    private NBTTagList bookPages;
    private String bookTitle = "";
    private NextPageButton buttonNextPage;
    private NextPageButton buttonPreviousPage;
    private GuiButton buttonDone;
    private boolean bookGettingSigned;
    private GuiButton buttonSign;
    private GuiButton buttonFinalize;
    public GuiButton buttonCancel;
    private List<ITextComponent> cachedComponents;

    public GuiScreenBookUtil(GuiScreenBook parentScreen, boolean bookmark, boolean pauseGame) {
        this.editingPlayer = (EntityPlayer)ObfuscationReflectionHelper.getPrivateValue(GuiScreenBook.class, (Object)parentScreen, (String)"field_146468_g");
        this.book = (ItemStack)ObfuscationReflectionHelper.getPrivateValue(GuiScreenBook.class, (Object)parentScreen, (String)"field_146474_h");
        this.bookIsUnsigned = (Boolean)ObfuscationReflectionHelper.getPrivateValue(GuiScreenBook.class, (Object)parentScreen, (String)"field_146475_i");
        this.bookGettingSigned = (Boolean)ObfuscationReflectionHelper.getPrivateValue(GuiScreenBook.class, (Object)parentScreen, (String)"field_146480_s");
        this.pauseGame = pauseGame;
        if (this.book.func_77942_o()) {
            NBTTagCompound nbttagcompound = this.book.func_77978_p();
            this.bookPages = nbttagcompound.func_150295_c("pages", 8);
            if (this.bookPages != null) {
                this.bookPages = this.bookPages.func_74737_b();
                this.bookTotalPages = this.bookPages.func_74745_c();
                if (this.bookTotalPages < 1) {
                    this.bookTotalPages = 1;
                }
            }
            if (bookmark) {
                this.currPage = BookHelper.getCurrentPage(this.book);
                if (this.currPage < 0 || this.currPage >= this.bookTotalPages) {
                    this.currPage = 0;
                }
                this.lastCurrPage = this.currPage;
            }
        }
        if (this.bookPages == null && this.bookIsUnsigned) {
            this.bookPages = new NBTTagList();
            this.bookPages.func_74742_a((NBTBase)new NBTTagString(""));
            this.bookTotalPages = 1;
        }
    }

    public void func_73876_c() {
        super.func_73876_c();
        ++this.updateCount;
    }

    public void func_73866_w_() {
        this.field_146292_n.clear();
        Keyboard.enableRepeatEvents((boolean)true);
        if (this.bookIsUnsigned) {
            this.buttonSign = this.func_189646_b(new GuiButton(3, this.field_146294_l / 2 - 100, 196, 98, 20, I18n.func_135052_a((String)"book.signButton", (Object[])new Object[0])));
            this.buttonDone = this.func_189646_b(new GuiButton(0, this.field_146294_l / 2 + 2, 196, 98, 20, I18n.func_135052_a((String)"gui.done", (Object[])new Object[0])));
            this.buttonFinalize = this.func_189646_b(new GuiButton(5, this.field_146294_l / 2 - 100, 196, 98, 20, I18n.func_135052_a((String)"book.finalizeButton", (Object[])new Object[0])));
            this.buttonCancel = this.func_189646_b(new GuiButton(4, this.field_146294_l / 2 + 2, 196, 98, 20, I18n.func_135052_a((String)"gui.cancel", (Object[])new Object[0])));
        } else {
            this.buttonDone = this.func_189646_b(new GuiButton(0, this.field_146294_l / 2 - 100, 196, 200, 20, I18n.func_135052_a((String)"gui.done", (Object[])new Object[0])));
        }
        ((Object)((Object)this)).getClass();
        int i = (this.field_146294_l - 192) / 2;
        int b0 = 2;
        this.buttonNextPage = new NextPageButton(1, i + 120, b0 + 154, true);
        this.field_146292_n.add(this.buttonNextPage);
        this.buttonPreviousPage = new NextPageButton(2, i + 38, b0 + 154, false);
        this.field_146292_n.add(this.buttonPreviousPage);
        this.updateButtons();
    }

    public void func_146281_b() {
        Keyboard.enableRepeatEvents((boolean)false);
    }

    private void updateButtons() {
        this.buttonNextPage.field_146125_m = !this.bookGettingSigned && (this.currPage < this.bookTotalPages - 1 || this.bookIsUnsigned);
        this.buttonPreviousPage.field_146125_m = !this.bookGettingSigned && this.currPage > 0;
        boolean bl = this.buttonDone.field_146125_m = !this.bookIsUnsigned || !this.bookGettingSigned;
        if (this.bookIsUnsigned) {
            this.buttonSign.field_146125_m = !this.bookGettingSigned;
            this.buttonCancel.field_146125_m = this.bookGettingSigned;
            this.buttonFinalize.field_146125_m = this.bookGettingSigned;
            this.buttonFinalize.field_146124_l = !this.bookTitle.trim().isEmpty();
        }
    }

    private void sendBookToServer(boolean publish) {
        if (this.bookIsUnsigned && this.bookIsModified && this.bookPages != null) {
            String s;
            while (this.bookPages.func_74745_c() > 1 && (s = this.bookPages.func_150307_f(this.bookPages.func_74745_c() - 1)).isEmpty()) {
                this.bookPages.func_74744_a(this.bookPages.func_74745_c() - 1);
            }
            if (this.book.func_77942_o()) {
                NBTTagCompound nbttagcompound = this.book.func_77978_p();
                nbttagcompound.func_74782_a("pages", (NBTBase)this.bookPages);
            } else {
                this.book.func_77983_a("pages", (NBTBase)this.bookPages);
            }
            String s1 = "MC|BEdit";
            if (publish) {
                s1 = "MC|BSign";
                this.book.func_77983_a("author", (NBTBase)new NBTTagString(this.editingPlayer.func_70005_c_()));
                this.book.func_77983_a("title", (NBTBase)new NBTTagString(this.bookTitle.trim()));
            }
            PacketBuffer packetbuffer = new PacketBuffer(Unpooled.buffer());
            packetbuffer.func_150788_a(this.book);
            this.field_146297_k.func_147114_u().func_147297_a((Packet)new CPacketCustomPayload(s1, packetbuffer));
        }
    }

    protected void func_146284_a(GuiButton button) throws IOException {
        if (button.field_146124_l) {
            if (button.field_146127_k == 0) {
                this.field_146297_k.func_147108_a(null);
                this.sendBookToServer(false);
            } else if (button.field_146127_k == 3 && this.bookIsUnsigned) {
                this.bookGettingSigned = true;
            } else if (button.field_146127_k == 1) {
                if (this.currPage < this.bookTotalPages - 1) {
                    ++this.currPage;
                } else if (this.bookIsUnsigned) {
                    this.addNewPage();
                    if (this.currPage < this.bookTotalPages - 1) {
                        ++this.currPage;
                    }
                }
                this.updateAndSendCurrPage();
            } else if (button.field_146127_k == 2) {
                if (this.currPage > 0) {
                    --this.currPage;
                    this.updateAndSendCurrPage();
                }
            } else if (button.field_146127_k == 5 && this.bookGettingSigned) {
                this.sendBookToServer(true);
                this.field_146297_k.func_147108_a(null);
            } else if (button.field_146127_k == 4 && this.bookGettingSigned) {
                this.bookGettingSigned = false;
            }
            this.updateButtons();
        }
    }

    private void updateAndSendCurrPage() {
        if (this.lastCurrPage != this.currPage) {
            this.lastCurrPage = this.currPage;
            BookHelper.setCurrentPage(this.book, this.currPage);
            LostBooks.CHANNEL.sendToServer((IMessage)new MessageCurrPage(this.currPage));
        }
    }

    private void addNewPage() {
        if (this.bookPages != null && this.bookPages.func_74745_c() < 50) {
            this.bookPages.func_74742_a((NBTBase)new NBTTagString(""));
            ++this.bookTotalPages;
            this.bookIsModified = true;
        }
    }

    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        super.func_73869_a(typedChar, keyCode);
        if (this.bookIsUnsigned) {
            if (this.bookGettingSigned) {
                this.keyTypedInTitle(typedChar, keyCode);
            } else {
                this.keyTypedInBook(typedChar, keyCode);
            }
        }
    }

    private void keyTypedInBook(char typedChar, int keyCode) {
        if (GuiScreen.func_175279_e((int)keyCode)) {
            this.pageInsertIntoCurrent(GuiScreen.func_146277_j());
        } else {
            switch (keyCode) {
                case 14: {
                    String s = this.pageGetCurrent();
                    if (!s.isEmpty()) {
                        this.pageSetCurrent(s.substring(0, s.length() - 1));
                    }
                    return;
                }
                case 28: 
                case 156: {
                    this.pageInsertIntoCurrent("\n");
                    return;
                }
            }
            if (ChatAllowedCharacters.func_71566_a((char)typedChar)) {
                this.pageInsertIntoCurrent(Character.toString(typedChar));
            }
        }
    }

    private void keyTypedInTitle(char typedChar, int keyCode) throws IOException {
        switch (keyCode) {
            case 14: {
                if (!this.bookTitle.isEmpty()) {
                    this.bookTitle = this.bookTitle.substring(0, this.bookTitle.length() - 1);
                    this.updateButtons();
                }
                return;
            }
            case 28: 
            case 156: {
                if (!this.bookTitle.isEmpty()) {
                    this.sendBookToServer(true);
                    this.field_146297_k.func_147108_a(null);
                }
                return;
            }
        }
        if (this.bookTitle.length() < 16 && ChatAllowedCharacters.func_71566_a((char)typedChar)) {
            this.bookTitle = this.bookTitle + typedChar;
            this.updateButtons();
            this.bookIsModified = true;
        }
    }

    private String pageGetCurrent() {
        return this.bookPages != null && this.currPage >= 0 && this.currPage < this.bookPages.func_74745_c() ? this.bookPages.func_150307_f(this.currPage) : "";
    }

    private void pageSetCurrent(String nbt) {
        if (this.bookPages != null && this.currPage >= 0 && this.currPage < this.bookPages.func_74745_c()) {
            this.bookPages.func_150304_a(this.currPage, (NBTBase)new NBTTagString(nbt));
            this.bookIsModified = true;
        }
    }

    private void pageInsertIntoCurrent(String text) {
        String s1 = this.pageGetCurrent();
        String s2 = s1 + text;
        int i = this.field_146289_q.func_78267_b(s2 + "" + TextFormatting.BLACK + "_", 118);
        if (i <= 118 && s2.length() < 256) {
            this.pageSetCurrent(s2);
        }
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(bookGuiTextures);
        int i = (this.field_146294_l - 192) / 2;
        int j = 2;
        this.func_73729_b(i, 2, 0, 0, 192, 192);
        if (this.bookGettingSigned) {
            String s = this.bookTitle;
            if (this.bookIsUnsigned) {
                s = this.updateCount / 6 % 2 == 0 ? s + "" + TextFormatting.BLACK + "_" : s + "" + TextFormatting.GRAY + "_";
            }
            String s1 = I18n.func_135052_a((String)"book.editTitle", (Object[])new Object[0]);
            int k = this.field_146289_q.func_78256_a(s1);
            this.field_146289_q.func_78276_b(s1, i + 36 + (116 - k) / 2, 34, 0);
            int l = this.field_146289_q.func_78256_a(s);
            this.field_146289_q.func_78276_b(s, i + 36 + (116 - l) / 2, 50, 0);
            String s2 = I18n.func_135052_a((String)"book.byAuthor", (Object[])new Object[]{this.editingPlayer.func_70005_c_()});
            int i1 = this.field_146289_q.func_78256_a(s2);
            this.field_146289_q.func_78276_b(TextFormatting.DARK_GRAY + s2, i + 36 + (116 - i1) / 2, 60, 0);
            String s3 = I18n.func_135052_a((String)"book.finalizeWarning", (Object[])new Object[0]);
            this.field_146289_q.func_78279_b(s3, i + 36, 82, 116, 0);
        } else {
            String s4 = I18n.func_135052_a((String)"book.pageIndicator", (Object[])new Object[]{this.currPage + 1, this.bookTotalPages});
            String s5 = "";
            if (this.bookPages != null && this.currPage >= 0 && this.currPage < this.bookPages.func_74745_c()) {
                s5 = this.bookPages.func_150307_f(this.currPage);
            }
            if (this.bookIsUnsigned) {
                s5 = this.field_146289_q.func_78260_a() ? s5 + "_" : (this.updateCount / 6 % 2 == 0 ? s5 + "" + TextFormatting.BLACK + "_" : s5 + "" + TextFormatting.GRAY + "_");
            } else if (this.cachedPage != this.currPage) {
                if (ItemWrittenBook.func_77828_a((NBTTagCompound)this.book.func_77978_p())) {
                    try {
                        ITextComponent itextcomponent = ITextComponent.Serializer.func_150699_a((String)s5);
                        this.cachedComponents = itextcomponent != null ? GuiUtilRenderComponents.func_178908_a((ITextComponent)itextcomponent, (int)116, (FontRenderer)this.field_146289_q, (boolean)true, (boolean)true) : null;
                    }
                    catch (JsonParseException var13) {
                        this.cachedComponents = null;
                    }
                } else {
                    TextComponentString textcomponentstring = new TextComponentString(TextFormatting.DARK_RED + "* Invalid book tag *");
                    this.cachedComponents = Lists.newArrayList((Iterable)textcomponentstring);
                }
                this.cachedPage = this.currPage;
            }
            int j1 = this.field_146289_q.func_78256_a(s4);
            this.field_146289_q.func_78276_b(s4, i - j1 + 192 - 44, 18, 0);
            if (this.cachedComponents == null) {
                this.field_146289_q.func_78279_b(s5, i + 36, 34, 116, 0);
            } else {
                int k1 = Math.min(128 / this.field_146289_q.field_78288_b, this.cachedComponents.size());
                for (int l1 = 0; l1 < k1; ++l1) {
                    ITextComponent itextcomponent2 = this.cachedComponents.get(l1);
                    this.field_146289_q.func_78276_b(itextcomponent2.func_150260_c(), i + 36, 34 + l1 * this.field_146289_q.field_78288_b, 0);
                }
                ITextComponent itextcomponent1 = this.getClickedComponentAt(mouseX, mouseY);
                if (itextcomponent1 != null) {
                    this.func_175272_a(itextcomponent1, mouseX, mouseY);
                }
            }
        }
        super.func_73863_a(mouseX, mouseY, partialTicks);
    }

    @Nullable
    public ITextComponent getClickedComponentAt(int p_175385_1_, int p_175385_2_) {
        if (this.cachedComponents == null) {
            return null;
        }
        int i = p_175385_1_ - (this.field_146294_l - 192) / 2 - 36;
        int j = p_175385_2_ - 2 - 16 - 16;
        if (i >= 0 && j >= 0) {
            int k = Math.min(128 / this.field_146289_q.field_78288_b, this.cachedComponents.size());
            if (i <= 116 && j < this.field_146297_k.field_71466_p.field_78288_b * k + k) {
                int l = j / this.field_146297_k.field_71466_p.field_78288_b;
                if (l >= 0 && l < this.cachedComponents.size()) {
                    ITextComponent itextcomponent = this.cachedComponents.get(l);
                    int i1 = 0;
                    for (ITextComponent itextcomponent1 : itextcomponent) {
                        if (!(itextcomponent1 instanceof TextComponentString) || (i1 += this.field_146297_k.field_71466_p.func_78256_a(((TextComponentString)itextcomponent1).func_150265_g())) <= i) continue;
                        return itextcomponent1;
                    }
                }
                return null;
            }
            return null;
        }
        return null;
    }

    public boolean func_73868_f() {
        return this.pauseGame;
    }

    @SideOnly(value=Side.CLIENT)
    static class NextPageButton
    extends GuiButton {
        private final boolean isForward;

        public NextPageButton(int buttonId, int x, int y, boolean isForwardIn) {
            super(buttonId, x, y, 23, 13, "");
            this.isForward = isForwardIn;
        }

        public void func_191745_a(Minecraft mc, int mouseX, int mouseY, float partialTicks) {
            if (this.field_146125_m) {
                boolean flag = mouseX >= this.field_146128_h && mouseY >= this.field_146129_i && mouseX < this.field_146128_h + this.field_146120_f && mouseY < this.field_146129_i + this.field_146121_g;
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                mc.func_110434_K().func_110577_a(bookGuiTextures);
                int k = 0;
                int l = 192;
                if (flag) {
                    k += 23;
                }
                if (!this.isForward) {
                    l += 13;
                }
                this.func_73729_b(this.field_146128_h, this.field_146129_i, k, l, 23, 13);
            }
        }
    }
}

