/*
 * Decompiled with CFR 0.152.
 */
package toast.lostBooks.helper;

import java.util.ArrayList;
import java.util.HashSet;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IMerchant;
import net.minecraft.entity.INpc;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.world.World;
import toast.lostBooks.Blackouts;
import toast.lostBooks.TickHandler;
import toast.lostBooks.helper.FileHelper;

public abstract class BookHelper {
    public static boolean hasBookId(ItemStack book) {
        return book.func_77978_p() != null && book.func_77978_p().func_74764_b("LB|ID");
    }

    public static String getBookId(ItemStack book) {
        if (!BookHelper.hasBookId(book)) {
            return null;
        }
        return book.func_77978_p().func_74779_i("LB|ID");
    }

    public static boolean removeBookId(ItemStack book) {
        if (BookHelper.hasBookId(book)) {
            book.func_77978_p().func_82580_o("LB|ID");
            return true;
        }
        return false;
    }

    public static void setTitleAndAuthor(ItemStack book, String id, String title, String author) {
        if (book.func_77978_p() == null) {
            book.func_77982_d(new NBTTagCompound());
        }
        book.func_77978_p().func_74778_a("LB|ID", id == null ? "" : id);
        book.func_77978_p().func_74778_a("title", title);
        if (author != "") {
            book.func_77978_p().func_74778_a("author", author);
        }
    }

    public static void setTitleAndAuthor(ItemStack book, String title, String author) {
        if (book.func_77978_p() == null) {
            book.func_77982_d(new NBTTagCompound());
        }
        book.func_77978_p().func_74778_a("title", title);
        if (author.equals("")) {
            book.func_77978_p().func_74778_a("author", author);
        }
    }

    public static void setTitle(ItemStack book, String title) {
        if (book.func_77978_p() == null) {
            book.func_77982_d(new NBTTagCompound());
        }
        book.func_77978_p().func_74778_a("title", title);
    }

    public static void setAuthor(ItemStack book, String author) {
        if (author.equals("")) {
            return;
        }
        if (book.func_77978_p() == null) {
            book.func_77982_d(new NBTTagCompound());
        }
        book.func_77978_p().func_74778_a("author", author);
    }

    public static String getTitle(ItemStack book) {
        if (book.func_77978_p() == null) {
            return "Untitled Book";
        }
        return book.func_77978_p().func_74779_i("title");
    }

    public static void setPages(ItemStack book, String ... pages) {
        if (book.func_77978_p() == null) {
            book.func_77982_d(new NBTTagCompound());
        }
        book.func_77978_p().func_74782_a("pages", (NBTBase)new NBTTagList());
        NBTTagList pagesTag = book.func_77978_p().func_150295_c("pages", 8);
        for (String page : pages) {
            pagesTag.func_74742_a((NBTBase)new NBTTagString(page));
        }
    }

    public static void addItemText(ItemStack book, String ... text) {
        NBTTagCompound tag;
        if (book.func_77978_p() == null) {
            book.func_77982_d(new NBTTagCompound());
        }
        if (!book.func_77978_p().func_74764_b("display")) {
            book.func_77978_p().func_74782_a("display", (NBTBase)new NBTTagCompound());
        }
        if (!(tag = book.func_77978_p().func_74775_l("display")).func_74764_b("Lore")) {
            tag.func_74782_a("Lore", (NBTBase)new NBTTagList());
        }
        for (String line : text) {
            tag.func_150295_c("Lore", 8).func_74742_a((NBTBase)new NBTTagString(line));
        }
    }

    public static Blackouts getBlackouts(World world) {
        return TickHandler.getOrCreateBlackouts(world);
    }

    public static HashSet<String> getBookData(EntityPlayer player) {
        if (player == null) {
            return new HashSet<String>(0);
        }
        return FileHelper.loadBookData(player.func_174793_f().func_70005_c_());
    }

    public static boolean isBookFound(EntityPlayer player, String id) {
        return BookHelper.getBookData(player).contains(id);
    }

    public static void markBookAsFound(EntityPlayer player, String id) {
        FileHelper.addBookData(player.func_174793_f().func_70005_c_(), id);
    }

    public static boolean canBookDrop(EntityLivingBase entity, ArrayList<Class> whitelist, ArrayList<Class> blacklist, HashSet<Integer> biomes) {
        Class<?> entityClass = entity.getClass();
        if (blacklist != null) {
            for (Class listedClass : blacklist) {
                if (!listedClass.equals(entityClass)) continue;
                return false;
            }
        }
        if (whitelist == null) {
            return IMob.class.isAssignableFrom(entityClass) || INpc.class.isAssignableFrom(entityClass) || IMerchant.class.isAssignableFrom(entityClass);
        }
        for (Class listedClass : whitelist) {
            if (!listedClass.isAssignableFrom(entityClass)) continue;
            return true;
        }
        return false;
    }

    public static int getCurrentPage(ItemStack book) {
        if (book.func_77978_p() == null) {
            return 0;
        }
        return book.func_77978_p().func_74762_e("LB|CP");
    }

    public static void setCurrentPage(ItemStack book, int currPage) {
        if (book.func_77978_p() == null) {
            book.func_77982_d(new NBTTagCompound());
        }
        if (currPage <= 0) {
            book.func_77978_p().func_82580_o("LB|CP");
        } else {
            book.func_77978_p().func_74768_a("LB|CP", currPage);
        }
    }
}

