/*
 * Decompiled with CFR 0.152.
 */
package toast.lostBooks.helper;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.JarURLConnection;
import java.net.URL;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.commons.compress.utils.IOUtils;
import org.apache.commons.io.FileUtils;
import toast.lostBooks.LostBooks;
import toast.lostBooks.helper.FileHelper;

public class ConfigFileHelper {
    public static void init() {
        try {
            LostBooks.console("Initializing config directory with the default books");
            URL url = FileHelper.class.getClassLoader().getResource("assets/lostbooks/LostBooks");
            JarURLConnection jarURLConnection = (JarURLConnection)url.openConnection();
            ConfigFileHelper.copyJarResourceToFolder(jarURLConnection, new File(LostBooks.CONFIG_DIRECTORY, "/LostBooks"));
        }
        catch (Exception e) {
            LostBooks.console("Failed to initialize the ConfigFileHelper");
            e.printStackTrace();
        }
    }

    public static void copyJarResourceToFolder(JarURLConnection jarConnection, File destDir) {
        try {
            JarFile jarFile = jarConnection.getJarFile();
            Enumeration<JarEntry> e = jarFile.entries();
            while (e.hasMoreElements()) {
                String jarConnectionEntryName;
                JarEntry jarEntry = e.nextElement();
                String jarEntryName = jarEntry.getName();
                if (!jarEntryName.startsWith(jarConnectionEntryName = jarConnection.getEntryName())) continue;
                String filename = jarEntryName.startsWith(jarConnectionEntryName) ? jarEntryName.substring(jarConnectionEntryName.length()) : jarEntryName;
                File currentFile = new File(destDir, filename);
                if (jarEntry.isDirectory()) {
                    currentFile.mkdirs();
                    continue;
                }
                InputStream is = jarFile.getInputStream(jarEntry);
                FileOutputStream out = FileUtils.openOutputStream((File)currentFile);
                IOUtils.copy((InputStream)is, (OutputStream)out);
                is.close();
                ((OutputStream)out).close();
            }
        }
        catch (IOException e) {
            LostBooks.console("Failed to initialize the /config/LostBooks config directory with the default book pack!");
            e.printStackTrace();
        }
    }
}

