/*
 * Decompiled with CFR 0.152.
 */
package toast.lostBooks.helper;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import net.minecraft.server.MinecraftServer;
import toast.lostBooks.LostBooks;
import toast.lostBooks.book.AdLibStats;
import toast.lostBooks.book.BookCollection;
import toast.lostBooks.book.BookProperties;
import toast.lostBooks.book.BookStats;
import toast.lostBooks.book.IBook;
import toast.lostBooks.book.Library;
import toast.lostBooks.book.LostBookCollection;
import toast.lostBooks.helper.AdLibHelper;
import toast.lostBooks.helper.TextHelper;

public abstract class FileHelper {
    public static File WORLD_DIRECTORY;

    public static void init(MinecraftServer server) {
        try {
            WORLD_DIRECTORY = new File(server.func_71209_f("saves/" + server.func_71270_I()), "LostBooks");
            LostBookCollection.BOOK_DIRECTORY = new File(WORLD_DIRECTORY, "lost");
            LostBookCollection.BOOK_DIRECTORY.mkdirs();
        }
        catch (Exception ex) {
            LostBooks.console("Failed to initialize unique book data storage! You may feel a strong disturbance in the force...");
            ex.printStackTrace();
            WORLD_DIRECTORY = null;
        }
    }

    public static IBook[] loadCollection(String category, BookCollection parentCollection, File folder) {
        try {
            folder.mkdirs();
            File[] bookFolders = folder.listFiles(new FolderFilter());
            ArrayList<IBook> bookList = FileHelper.loadBooks(category, parentCollection, folder);
            int length = bookFolders.length;
            if (bookList.size() + length == 0) {
                return new IBook[0];
            }
            for (int id = 0; id < length; ++id) {
                BookCollection collection = new BookCollection(category, parentCollection, bookFolders[id], BookProperties.loadBookProperties(folder, bookFolders[id]));
                if (collection.books.length == 1) {
                    bookList.add(collection.books[0]);
                    continue;
                }
                if (collection.books.length <= 1) continue;
                bookList.add(collection);
            }
            bookList.trimToSize();
            return FileHelper.sortBooks(parentCollection, bookList);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return new IBook[0];
        }
    }

    private static IBook[] sortBooks(BookCollection parentCollection, ArrayList<IBook> bookList) {
        IBook[] books;
        if (parentCollection != null && parentCollection.inOrder && (books = FileHelper.sortToArray(bookList)) != null) {
            return books;
        }
        return bookList.toArray(new IBook[0]);
    }

    private static IBook[] sortToArray(ArrayList<IBook> bookList) {
        int length = bookList.size();
        IBook[] books = new IBook[length];
        for (IBook book : bookList) {
            String name = book.getName();
            if (name.endsWith(".book")) {
                name = name.substring(0, name.length() - 5);
            }
            try {
                int index = Integer.parseInt(name) - 1;
                if (books[index] != null) {
                    return null;
                }
                books[index] = book;
            }
            catch (Exception ex) {
                return null;
            }
        }
        return books;
    }

    private static ArrayList<IBook> loadBooks(String category, BookCollection parentCollection, File folder) {
        if (category == "adlib") {
            return FileHelper.loadAdLibs(parentCollection, folder);
        }
        try {
            File[] bookFiles = folder.listFiles(new ExtensionFilter(".book"));
            int length = bookFiles.length;
            if (length == 0) {
                return new ArrayList<IBook>(0);
            }
            ArrayList<IBook> bookList = new ArrayList<IBook>(length);
            for (File bookFile : bookFiles) {
                IBook book = FileHelper.loadBook(category, parentCollection, folder, bookFile);
                if (book == null) continue;
                bookList.add(book);
            }
            bookList.trimToSize();
            return bookList;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return new ArrayList<IBook>(0);
        }
    }

    public static IBook loadBook(String category, BookCollection parentCollection, File folder, File bookFile) {
        if (category == "adlib") {
            return FileHelper.loadAdLib(parentCollection, folder, bookFile);
        }
        BookStats book = null;
        try {
            int dat;
            FileInputStream in = new FileInputStream(bookFile);
            String[] story = new String[]{"", ""};
            for (int i = 0; i < 2; ++i) {
                while ((dat = in.read()) >= 0 && dat != 10) {
                    if (dat == 13 || dat == 12) continue;
                    int n = i;
                    story[n] = story[n] + FileHelper.toAllowedString((char)dat);
                }
            }
            ArrayList<String> text = new ArrayList<String>(50);
            String color = "";
            String formats = "";
            String page = "";
            while (true) {
                boolean ff = false;
                boolean s = false;
                String nextColor = color;
                String nextFormats = formats;
                String word = "";
                while ((dat = in.read()) >= 0) {
                    block21: {
                        if (dat == 12) {
                            ff = true;
                            break;
                        }
                        if (dat == 13) continue;
                        if (s) {
                            s = false;
                            if (dat != 10) {
                                try {
                                    if (dat == 48) {
                                        nextColor = "";
                                    } else {
                                        Integer.parseInt(FileHelper.toAllowedString((char)dat), 16);
                                        nextColor = "\u00a7" + FileHelper.toAllowedString((char)dat);
                                    }
                                    nextFormats = "";
                                }
                                catch (Exception ex) {
                                    char tmp = Character.toLowerCase((char)dat);
                                    if (tmp == 'r') {
                                        nextFormats = "";
                                        break block21;
                                    }
                                    if (tmp == 'k' || tmp == 'l' || tmp == 'm' || tmp == 'n' || tmp == 'o') {
                                        nextFormats = nextFormats + "\u00a7" + FileHelper.toAllowedString(tmp);
                                        break block21;
                                    }
                                    nextColor = "\u00a7f";
                                    nextFormats = "";
                                }
                            }
                        } else if (dat == 167) {
                            s = true;
                        }
                    }
                    word = word + FileHelper.toAllowedString((char)dat);
                    if (!Character.isWhitespace(dat)) continue;
                }
                if (TextHelper.fitsOnPage(page + word)) {
                    page = page + word;
                } else {
                    text.add(page);
                    page = color + formats + word;
                }
                if (dat <= 0) break;
                if (ff) {
                    text.add(page);
                    color = "";
                    formats = "";
                    page = "";
                    continue;
                }
                color = nextColor;
                formats = nextFormats;
            }
            text.add(page);
            text.trimToSize();
            book = new BookStats(parentCollection, bookFile, BookProperties.loadBookProperties(folder, bookFile), category == "unique", story[0], story[1], text.toArray(new String[0]));
            in.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return book;
    }

    private static ArrayList<IBook> loadAdLibs(BookCollection parentCollection, File folder) {
        try {
            File[] bookFiles = folder.listFiles(new ExtensionFilter(".book"));
            int length = bookFiles.length;
            if (length == 0) {
                return new ArrayList<IBook>(0);
            }
            ArrayList<IBook> bookList = new ArrayList<IBook>(length);
            for (File bookFile : bookFiles) {
                IBook book = FileHelper.loadAdLib(parentCollection, folder, bookFile);
                if (book == null) continue;
                bookList.add(book);
            }
            bookList.trimToSize();
            return bookList;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return new ArrayList<IBook>(0);
        }
    }

    public static IBook loadAdLib(BookCollection parentCollection, File folder, File bookFile) {
        AdLibStats book = null;
        try {
            new FileInputStream(bookFile).close();
            book = new AdLibStats(parentCollection, bookFile, BookProperties.loadBookProperties(folder, bookFile));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return book;
    }

    public static void loadWords(HashMap<String, String[]> words) {
        try {
            String[][] comboMap;
            File[] wordsFiles;
            HashMap wordSets = new HashMap(AdLibHelper.CUSTOM_WORD_CODES.size() + 1, 1.0f);
            for (String wordCode : AdLibHelper.CUSTOM_WORD_CODES) {
                wordSets.put(wordCode, new HashSet(255));
            }
            File folder = new File(LostBooks.CONFIG_DIRECTORY, "/LostBooks/words");
            folder.mkdirs();
            for (File wordsFile : wordsFiles = folder.listFiles(new ExtensionFilter(".words"))) {
                int dat;
                FileInputStream in = new FileInputStream(wordsFile);
                boolean status = false;
                String wordCode = "";
                String word = "";
                while ((dat = in.read()) >= 0) {
                    if (dat == 13) continue;
                    if (dat == 10) {
                        if (!status) {
                            if (wordCode == "") continue;
                            if (!AdLibHelper.CUSTOM_WORD_CODES.contains(wordCode = AdLibHelper.checkCode(wordCode))) {
                                if (AdLibHelper.WORD_CODES.contains(wordCode)) {
                                    LostBooks.console("Words can not be added to code: " + wordCode + " (" + wordsFile.getName() + ")");
                                } else if (wordCode.charAt(0) != '#') {
                                    LostBooks.console("Invalid word code: " + wordCode + " (" + wordsFile.getName() + ")");
                                }
                                wordCode = "";
                                continue;
                            }
                            status = true;
                            continue;
                        }
                        if (!status) continue;
                        if (word == "") {
                            wordCode = "";
                            status = false;
                            continue;
                        }
                        ((HashSet)wordSets.get(wordCode)).add(word);
                        word = "";
                        continue;
                    }
                    if (!status) {
                        wordCode = wordCode + FileHelper.toAllowedString((char)dat);
                        continue;
                    }
                    if (!status) continue;
                    word = word + FileHelper.toAllowedString((char)dat);
                }
                if (status && word != "") {
                    ((HashSet)wordSets.get(wordCode)).add(word);
                }
                in.close();
            }
            for (String[] comboList : comboMap = new String[][]{{"noun", "noun.bodypart", "noun.living", "noun.object", "noun.place"}, {"noun.plural", "noun.bodypart.plural", "noun.living.plural", "noun.object.plural", "noun.place.plural"}}) {
                HashSet combo = (HashSet)wordSets.get(comboList[0]);
                int i = comboList.length;
                while (i-- > 1) {
                    combo.addAll((Collection)wordSets.get(comboList[i]));
                }
            }
            int amount = 0;
            for (String wordCode : AdLibHelper.CUSTOM_WORD_CODES) {
                String[] wordList = new ArrayList((Collection)wordSets.get(wordCode)).toArray(new String[0]);
                words.put(wordCode, wordList);
                amount += wordList.length;
            }
            LostBooks.console("Loaded " + amount + " words!");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static String toAllowedString(char c) {
        return Character.toString(c);
    }

    public static HashSet<String> loadBookData(String username) {
        try {
            File playerFile = new File(WORLD_DIRECTORY, username + ".txt");
            if (playerFile.exists()) {
                try {
                    int dat;
                    HashSet<String> bookData = new HashSet<String>(Library.UNIQUE_BOOK_COUNT);
                    FileInputStream in = new FileInputStream(playerFile);
                    String value = "";
                    while ((dat = in.read()) >= 0) {
                        if (dat == 10) {
                            if (value != "") {
                                bookData.add(value);
                            }
                            value = "";
                            continue;
                        }
                        value = value + FileHelper.toAllowedString((char)dat);
                    }
                    if (value != "") {
                        bookData.add(value);
                    }
                    in.close();
                    return bookData;
                }
                catch (Exception ex) {
                    LostBooks.console("Error reading player file! Destroying...");
                    if (!playerFile.delete()) {
                        LostBooks.console("Failed to destroy player file!");
                    }
                    ex.printStackTrace();
                }
            }
        }
        catch (Exception ex) {
            LostBooks.console("Failed to load player book data! (" + username + ")");
            ex.printStackTrace();
        }
        return new HashSet<String>(0);
    }

    public static void addBookData(String username, String id) {
        try {
            File playerFile = new File(WORLD_DIRECTORY, username + ".txt");
            playerFile.createNewFile();
            FileWriter out = new FileWriter(playerFile, true);
            out.write(id + '\n');
            out.close();
        }
        catch (Exception ex) {
            LostBooks.console("Failed to save player book data! (" + username + ")");
            ex.printStackTrace();
        }
    }

    public static void clearBookData() {
        try {
            File[] playerFiles;
            for (File playerFile : playerFiles = WORLD_DIRECTORY.listFiles(new ExtensionFilter(".txt"))) {
                playerFile.delete();
            }
        }
        catch (Exception ex) {
            LostBooks.console("Failed to clear player book data!");
            ex.printStackTrace();
        }
    }

    public static void clearBookData(String username) {
        try {
            File playerFile = new File(WORLD_DIRECTORY, username + ".txt");
            playerFile.delete();
        }
        catch (Exception ex) {
            LostBooks.console("Failed to delete player book data! (" + username + ")");
            ex.printStackTrace();
        }
    }

    public static class FolderFilter
    implements FileFilter {
        @Override
        public boolean accept(File file) {
            return file.isDirectory();
        }
    }

    public static class ExtensionFilter
    implements FilenameFilter {
        private final String extension;

        public ExtensionFilter(String ext) {
            this.extension = ext;
        }

        @Override
        public boolean accept(File file, String name) {
            return name.endsWith(this.extension);
        }
    }
}

