/*
 * Decompiled with CFR 0.152.
 */
package de.geheimagentnr1.magical_torches.elements.blocks.torches.chicken_egg_spawning;

import de.geheimagentnr1.magical_torches.config.MainConfig;
import de.geheimagentnr1.magical_torches.elements.blocks.BlockItemInterface;
import de.geheimagentnr1.magical_torches.elements.blocks.BlockWithTooltip;
import de.geheimagentnr1.magical_torches.elements.blocks.ModBlocks;
import de.geheimagentnr1.magical_torches.elements.capabilities.ModCapabilities;
import de.geheimagentnr1.magical_torches.elements.capabilities.chicken_egg_spawning.ChickenEggSpawningCapability;
import de.geheimagentnr1.magical_torches.elements.capabilities.chicken_egg_spawning.chicken_egg_blockers.ChickenEggTorchBlocker;
import de.geheimagentnr1.magical_torches.elements.capabilities.spawn_blocking.ISpawnBlockFactory;
import de.geheimagentnr1.magical_torches.helpers.TranslationKeyHelper;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.PushReaction;
import net.minecraft.item.Item;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.text.TextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class ChickenEggTorch
extends BlockWithTooltip
implements BlockItemInterface {
    public static final String registry_name = "chicken_egg_torch";
    private static final VoxelShape SHAPE = Block.func_208617_a((double)6.5, (double)0.0, (double)6.5, (double)9.5, (double)10.0, (double)9.5);
    private final ISpawnBlockFactory spawnBlockFactory;

    public ChickenEggTorch() {
        super(Block.Properties.func_200945_a((Material)Material.field_151575_d).func_200942_a().func_200943_b(3.0f).func_200947_a(SoundType.field_185848_a));
        this.setRegistryName(registry_name);
        this.spawnBlockFactory = ChickenEggTorchBlocker::new;
        ChickenEggSpawningCapability.registerChickenEggBlocker(ChickenEggTorchBlocker.registry_name, this.spawnBlockFactory);
    }

    @Nonnull
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    @Nonnull
    public VoxelShape func_220053_a(@Nonnull BlockState state, @Nonnull IBlockReader worldIn, @Nonnull BlockPos pos, @Nonnull ISelectionContext context) {
        return SHAPE;
    }

    @Nonnull
    public VoxelShape func_220071_b(@Nonnull BlockState state, @Nonnull IBlockReader worldIn, @Nonnull BlockPos pos, @Nonnull ISelectionContext context) {
        return VoxelShapes.func_197880_a();
    }

    @Nonnull
    public PushReaction func_149656_h(@Nonnull BlockState state) {
        return PushReaction.DESTROY;
    }

    @Override
    public TextComponent getInformation() {
        if (MainConfig.getShouldInvertChickenEggBlocking()) {
            return new TranslationTextComponent(TranslationKeyHelper.buildTooltipTranslationKey("chicken_egg_spawning_enable"), new Object[]{MainConfig.getChickenEggTorchRange()});
        }
        return new TranslationTextComponent(TranslationKeyHelper.buildTooltipTranslationKey("chicken_egg_spawning_blocking"), new Object[]{MainConfig.getChickenEggTorchRange()});
    }

    public void func_220082_b(@Nonnull BlockState state, World worldIn, @Nonnull BlockPos pos, @Nonnull BlockState oldState, boolean isMoving) {
        worldIn.getCapability(ModCapabilities.CHICKEN_EGG_SPAWNING).ifPresent(capability -> capability.addSpawnBlocker(this.spawnBlockFactory.buildSpawnBlocker(pos)));
    }

    public void func_196243_a(@Nonnull BlockState state, @Nonnull World worldIn, @Nonnull BlockPos pos, @Nonnull BlockState newState, boolean isMoving) {
        worldIn.getCapability(ModCapabilities.CHICKEN_EGG_SPAWNING).ifPresent(capability -> capability.removeSpawnBlocker(this.spawnBlockFactory.buildSpawnBlocker(pos)));
        super.func_196243_a(state, worldIn, pos, newState, isMoving);
    }

    @Override
    public Item getBlockItem(Item.Properties properties) {
        return this.createBlockItem(ModBlocks.CHICKEN_EGG_TORCH, properties, registry_name);
    }
}

