/*
 * Decompiled with CFR 0.152.
 */
package de.geheimagentnr1.magical_torches.elements.blocks.torches.spawn_blocking;

import de.geheimagentnr1.magical_torches.elements.blocks.BlockItemInterface;
import de.geheimagentnr1.magical_torches.elements.blocks.BlockWithTooltip;
import de.geheimagentnr1.magical_torches.elements.capabilities.ModCapabilities;
import de.geheimagentnr1.magical_torches.elements.capabilities.spawn_blocking.ISpawnBlockFactory;
import de.geheimagentnr1.magical_torches.elements.capabilities.spawn_blocking.SpawnBlockingCapability;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.PushReaction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

abstract class SpawnBlockingTorch
extends BlockWithTooltip
implements BlockItemInterface {
    final ISpawnBlockFactory spawnBlockFactory;

    SpawnBlockingTorch(Block.Properties properties, String registry_name, ResourceLocation spawn_block_registry_name, ISpawnBlockFactory _spawnBlockFactory) {
        super(properties.func_200942_a().func_200951_a(15));
        this.setRegistryName(registry_name);
        this.spawnBlockFactory = _spawnBlockFactory;
        SpawnBlockingCapability.registerSpawnBlocker(spawn_block_registry_name, _spawnBlockFactory);
    }

    @Nonnull
    public VoxelShape func_220071_b(@Nonnull BlockState state, @Nonnull IBlockReader worldIn, @Nonnull BlockPos pos, @Nonnull ISelectionContext context) {
        return VoxelShapes.func_197880_a();
    }

    @Nonnull
    public PushReaction func_149656_h(@Nonnull BlockState state) {
        return PushReaction.DESTROY;
    }

    public void func_220082_b(@Nonnull BlockState state, World worldIn, @Nonnull BlockPos pos, @Nonnull BlockState oldState, boolean isMoving) {
        worldIn.getCapability(ModCapabilities.SPAWN_BLOCKING).ifPresent(capability -> capability.addSpawnBlocker(this.spawnBlockFactory.buildSpawnBlocker(pos)));
    }

    public void func_196243_a(@Nonnull BlockState state, @Nonnull World worldIn, @Nonnull BlockPos pos, @Nonnull BlockState newState, boolean isMoving) {
        worldIn.getCapability(ModCapabilities.SPAWN_BLOCKING).ifPresent(capability -> capability.removeSpawnBlocker(this.spawnBlockFactory.buildSpawnBlocker(pos)));
        super.func_196243_a(state, worldIn, pos, newState, isMoving);
    }
}

