/*
 * Decompiled with CFR 0.152.
 */
package de.geheimagentnr1.magical_torches.elements.blocks.torches.spawn_blocking;

import de.geheimagentnr1.magical_torches.config.MainConfig;
import de.geheimagentnr1.magical_torches.elements.blocks.BlockRenderTypeInterface;
import de.geheimagentnr1.magical_torches.elements.blocks.ModBlocks;
import de.geheimagentnr1.magical_torches.elements.blocks.torches.spawn_blocking.SpawnBlockingTorch;
import de.geheimagentnr1.magical_torches.elements.capabilities.spawn_blocking.spawn_blockers.BatTorchSpawnBlocker;
import de.geheimagentnr1.magical_torches.helpers.TranslationKeyHelper;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.Item;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.text.TextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;

public class BatTorch
extends SpawnBlockingTorch
implements BlockRenderTypeInterface {
    public static final String registry_name = "bat_torch";
    private static final VoxelShape STANDING_SHAPE = VoxelShapes.func_197872_a((VoxelShape)Block.func_208617_a((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)7.0, (double)11.0), (VoxelShape)Block.func_208617_a((double)6.0, (double)7.0, (double)6.0, (double)10.0, (double)9.0, (double)10.0));
    private static final VoxelShape HANGING_SHAPE = VoxelShapes.func_197872_a((VoxelShape)Block.func_208617_a((double)5.0, (double)1.0, (double)5.0, (double)11.0, (double)8.0, (double)11.0), (VoxelShape)Block.func_208617_a((double)6.0, (double)8.0, (double)6.0, (double)10.0, (double)10.0, (double)10.0));

    public BatTorch() {
        super(Block.Properties.func_200945_a((Material)Material.field_151573_f).func_200943_b(3.5f).func_200947_a(SoundType.field_222475_v), registry_name, BatTorchSpawnBlocker.registry_name, BatTorchSpawnBlocker::new);
        this.func_180632_j((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((IProperty)BlockStateProperties.field_222514_j, (Comparable)Boolean.FALSE));
    }

    @Override
    public RenderType getRenderType() {
        return RenderType.func_228643_e_();
    }

    @Nonnull
    public VoxelShape func_220053_a(BlockState state, @Nonnull IBlockReader worldIn, @Nonnull BlockPos pos, @Nonnull ISelectionContext context) {
        return (Boolean)state.func_177229_b((IProperty)BlockStateProperties.field_222514_j) != false ? HANGING_SHAPE : STANDING_SHAPE;
    }

    @Override
    protected TextComponent getInformation() {
        return new TranslationTextComponent(TranslationKeyHelper.buildTooltipTranslationKey("spawn_blocking_bat"), new Object[]{MainConfig.getAloneTorchRange()});
    }

    private static Direction hangingToDirection(BlockState state) {
        return (Boolean)state.func_177229_b((IProperty)BlockStateProperties.field_222514_j) != false ? Direction.DOWN : Direction.UP;
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        for (Direction direction : context.func_196009_e()) {
            BlockState blockstate;
            if (direction.func_176740_k() != Direction.Axis.Y || !(blockstate = (BlockState)this.func_176223_P().func_206870_a((IProperty)BlockStateProperties.field_222514_j, (Comparable)Boolean.valueOf(direction == Direction.UP))).func_196955_c((IWorldReader)context.func_195991_k(), context.func_195995_a())) continue;
            return blockstate;
        }
        return null;
    }

    @Nonnull
    public BlockState func_196271_a(@Nonnull BlockState stateIn, @Nonnull Direction facing, @Nonnull BlockState facingState, @Nonnull IWorld worldIn, @Nonnull BlockPos currentPos, @Nonnull BlockPos facingPos) {
        return BatTorch.hangingToDirection(stateIn).func_176734_d() == facing && !stateIn.func_196955_c((IWorldReader)worldIn, currentPos) ? Blocks.field_150350_a.func_176223_P() : super.func_196271_a(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    public boolean func_196260_a(@Nonnull BlockState state, @Nonnull IWorldReader worldIn, BlockPos pos) {
        Direction direction = BatTorch.hangingToDirection(state).func_176734_d();
        return Block.func_220055_a((IWorldReader)worldIn, (BlockPos)pos.func_177972_a(direction), (Direction)direction.func_176734_d());
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{BlockStateProperties.field_222514_j});
    }

    @Override
    public Item getBlockItem(Item.Properties properties) {
        return this.createBlockItem(ModBlocks.BAT_TORCH, properties, registry_name);
    }
}

