/*
 * Decompiled with CFR 0.152.
 */
package de.geheimagentnr1.magical_torches.elements.capabilities.spawn_blocking;

import de.geheimagentnr1.magical_torches.elements.capabilities.ModCapabilities;
import de.geheimagentnr1.magical_torches.elements.capabilities.spawn_blocking.ISpawnBlockFactory;
import de.geheimagentnr1.magical_torches.elements.capabilities.spawn_blocking.SpawnBlocker;
import de.geheimagentnr1.magical_torches.helpers.RadiusHelper;
import de.geheimagentnr1.magical_torches.helpers.ResourceLocationBuilder;
import de.geheimagentnr1.magical_torches.helpers.SpawnBlockerNBTHelper;
import java.util.Comparator;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;

public class SpawnBlockingCapability
implements ICapabilitySerializable<ListNBT> {
    public static final ResourceLocation registry_name = ResourceLocationBuilder.build("spawn_blocking");
    private final LazyOptional<SpawnBlockingCapability> capability = LazyOptional.of(() -> this);
    private TreeSet<SpawnBlocker> spawnBlockers = new TreeSet<SpawnBlocker>(Comparator.comparing(SpawnBlocker::getPos));
    private static final TreeMap<ResourceLocation, ISpawnBlockFactory> SPAWN_BLOCKING_REGISTERY = new TreeMap();

    public static void registerSpawnBlocker(ResourceLocation _registry_name, ISpawnBlockFactory factory) {
        SPAWN_BLOCKING_REGISTERY.put(_registry_name, factory);
    }

    public boolean shouldBlockEntitySpawn(Entity entity) {
        BlockPos spawn_pos = entity.func_180425_c();
        for (SpawnBlocker spawnBlocker : this.spawnBlockers) {
            if (!spawnBlocker.shouldBlockEntity(entity) || !RadiusHelper.isEventInRadiusOfBlock(spawn_pos, spawnBlocker.getPos(), spawnBlocker.getRange())) continue;
            return true;
        }
        return false;
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == ModCapabilities.SPAWN_BLOCKING) {
            return this.capability.cast();
        }
        return LazyOptional.empty();
    }

    public ListNBT serializeNBT() {
        return SpawnBlockerNBTHelper.serializeSpawnBlockers(this.spawnBlockers);
    }

    public void deserializeNBT(ListNBT nbt) {
        this.spawnBlockers = SpawnBlockerNBTHelper.deserializeSpawnBlockers(nbt, SPAWN_BLOCKING_REGISTERY);
    }

    public void addSpawnBlocker(SpawnBlocker spawnBlocker) {
        this.spawnBlockers.add(spawnBlocker);
    }

    public void removeSpawnBlocker(SpawnBlocker spawnBlocker) {
        this.spawnBlockers.remove(spawnBlocker);
    }
}

