/*
 * Decompiled with CFR 0.152.
 */
package de.geheimagentnr1.magical_torches.elements.capabilities_client.sound_muffling;

import de.geheimagentnr1.magical_torches.elements.capabilities_client.sound_muffling.SoundMuffler;
import de.geheimagentnr1.magical_torches.elements.capabilities_client.sound_muffling.SoundMufflerStorage;
import de.geheimagentnr1.magical_torches.helpers.RadiusHelper;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Objects;
import java.util.TreeMap;
import java.util.TreeSet;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.dimension.DimensionType;

public class SoundMufflingClientCapability {
    private static final TreeMap<DimensionType, TreeSet<SoundMuffler>> soundMufflers = new TreeMap(Comparator.comparingInt(DimensionType::func_186068_a));
    private static final ArrayList<SoundMufflerStorage> SOUND_MUFFLER_STORAGES = new ArrayList();

    public static void init() {
        Comparator<SoundMuffler> comparator = Comparator.comparing(SoundMuffler::getPos);
        DimensionType.func_212681_b().forEach(dimensionType -> soundMufflers.put((DimensionType)dimensionType, new TreeSet(comparator)));
    }

    public static void clear() {
        soundMufflers.clear();
        SOUND_MUFFLER_STORAGES.clear();
    }

    public static boolean shouldMuffleSound(ISound sound) {
        if (!SOUND_MUFFLER_STORAGES.isEmpty()) {
            for (SoundMufflerStorage soundMufflerStorage : SOUND_MUFFLER_STORAGES) {
                soundMufflers.get(Objects.requireNonNull(soundMufflerStorage.getTileEntity().func_145831_w()).func_201675_m().func_186058_p()).add(soundMufflerStorage.getSoundMuffler());
            }
            SOUND_MUFFLER_STORAGES.clear();
        }
        BlockPos sound_pos = new BlockPos((double)sound.func_147649_g(), (double)sound.func_147654_h(), (double)sound.func_147651_i());
        for (SoundMuffler soundMuffler : soundMufflers.get(SoundMufflingClientCapability.getDimension())) {
            if (!soundMuffler.shouldMuffleSound(sound) || !RadiusHelper.isEventInRadiusOfBlock(sound_pos, soundMuffler.getPos(), soundMuffler.getRange())) continue;
            return true;
        }
        return false;
    }

    private static World getWorld() {
        return Minecraft.func_71410_x().field_71441_e;
    }

    private static DimensionType getDimension() {
        return SoundMufflingClientCapability.getWorld().func_201675_m().func_186058_p();
    }

    static void addSoundMuffler(TileEntity tileEntity, SoundMuffler soundMuffler) {
        if (SoundMufflingClientCapability.getWorld() == null) {
            SOUND_MUFFLER_STORAGES.add(new SoundMufflerStorage(tileEntity, soundMuffler));
        } else {
            SoundMufflingClientCapability.addSoundMuffler(soundMuffler);
        }
    }

    static void removeSoundMuffler(SoundMuffler soundMuffler) {
        soundMufflers.get(SoundMufflingClientCapability.getDimension()).remove(soundMuffler);
    }

    private static void addSoundMuffler(SoundMuffler soundMuffler) {
        soundMufflers.get(SoundMufflingClientCapability.getDimension()).add(soundMuffler);
    }
}

