/*
 * Decompiled with CFR 0.152.
 */
package de.geheimagentnr1.magical_torches.elements.capabilities.chicken_egg_spawning;

import de.geheimagentnr1.magical_torches.config.MainConfig;
import de.geheimagentnr1.magical_torches.elements.capabilities.ModCapabilities;
import de.geheimagentnr1.magical_torches.elements.capabilities.spawn_blocking.ISpawnBlockFactory;
import de.geheimagentnr1.magical_torches.elements.capabilities.spawn_blocking.SpawnBlocker;
import de.geheimagentnr1.magical_torches.helpers.RadiusHelper;
import de.geheimagentnr1.magical_torches.helpers.ResourceLocationBuilder;
import de.geheimagentnr1.magical_torches.helpers.SpawnBlockerNBTHelper;
import java.util.Comparator;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.item.Items;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;

public class ChickenEggSpawningCapability
implements ICapabilitySerializable<ListNBT> {
    public static final ResourceLocation registry_name = ResourceLocationBuilder.build("chicken_egg_spawing");
    private final LazyOptional<ChickenEggSpawningCapability> capability = LazyOptional.of(() -> this);
    private TreeSet<SpawnBlocker> spawnBlockers = new TreeSet<SpawnBlocker>(Comparator.comparing(SpawnBlocker::getPos));
    private static final TreeMap<ResourceLocation, ISpawnBlockFactory> SPAWN_BLOCKING_REGISTERY = new TreeMap();

    public static void registerChickenEggBlocker(ResourceLocation _registry_name, ISpawnBlockFactory factory) {
        SPAWN_BLOCKING_REGISTERY.put(_registry_name, factory);
    }

    public boolean shouldBlockChickenEggSpawn(Entity entity) {
        if (entity instanceof ItemEntity && ((ItemEntity)entity).func_92059_d().func_77973_b() == Items.field_151110_aK) {
            BlockPos spawn_pos = entity.func_233580_cy_();
            boolean block = false;
            for (SpawnBlocker spawnBlocker : this.spawnBlockers) {
                if (!spawnBlocker.shouldBlockEntity(entity) || !RadiusHelper.isEventInRadiusOfBlock(spawn_pos, spawnBlocker.getPos(), spawnBlocker.getRange())) continue;
                block = true;
                break;
            }
            if (MainConfig.getShouldInvertChickenEggBlocking()) {
                block = !block;
            }
            return block;
        }
        return false;
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == ModCapabilities.CHICKEN_EGG_SPAWNING) {
            return this.capability.cast();
        }
        return LazyOptional.empty();
    }

    public ListNBT serializeNBT() {
        return SpawnBlockerNBTHelper.serializeSpawnBlockers(this.spawnBlockers);
    }

    public void deserializeNBT(ListNBT nbt) {
        this.spawnBlockers = SpawnBlockerNBTHelper.deserializeSpawnBlockers(nbt, SPAWN_BLOCKING_REGISTERY);
    }

    public void addSpawnBlocker(SpawnBlocker spawnBlocker) {
        this.spawnBlockers.add(spawnBlocker);
    }

    public void removeSpawnBlocker(SpawnBlocker spawnBlocker) {
        this.spawnBlockers.remove(spawnBlocker);
    }
}

