/*
 * Decompiled with CFR 0.152.
 */
package de.geheimagentnr1.magical_torches.handlers;

import de.geheimagentnr1.magical_torches.MagicalTorches;
import de.geheimagentnr1.magical_torches.config.MainConfig;
import de.geheimagentnr1.magical_torches.elements.blocks.BlockItemInterface;
import de.geheimagentnr1.magical_torches.elements.blocks.BlockRenderTypeInterface;
import de.geheimagentnr1.magical_torches.elements.blocks.ModBlocks;
import de.geheimagentnr1.magical_torches.elements.blocks.torches.sound_muffling.SoundMufflingTorchTile;
import de.geheimagentnr1.magical_torches.elements.capabilities.chicken_egg_spawning.ChickenEggSpawningCapability;
import de.geheimagentnr1.magical_torches.elements.capabilities.chicken_egg_spawning.ChickenEggSpawningCapabilityStorage;
import de.geheimagentnr1.magical_torches.elements.capabilities.spawn_blocking.SpawnBlockingCapability;
import de.geheimagentnr1.magical_torches.elements.capabilities.spawn_blocking.SpawnBlockingCapabilityStorage;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.tileentity.TileEntityType;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class ModEventHandler {
    @SubscribeEvent
    public static void handleModConfigLoadingEvent(ModConfig.Loading event) {
        MainConfig.printConfig();
    }

    @SubscribeEvent
    public static void handleModConfigReloadingEvent(ModConfig.Reloading event) {
        MainConfig.printConfig();
    }

    @SubscribeEvent
    public static void handleClientSetupEvent(FMLClientSetupEvent event) {
        for (Block block : ModBlocks.BLOCKS) {
            if (!(block instanceof BlockRenderTypeInterface)) continue;
            BlockRenderTypeInterface blockRenderType = (BlockRenderTypeInterface)block;
            RenderTypeLookup.setRenderLayer((Block)block, (RenderType)blockRenderType.getRenderType());
        }
    }

    @SubscribeEvent
    public static void handleCommonSetupEvent(FMLCommonSetupEvent event) {
        CapabilityManager.INSTANCE.register(ChickenEggSpawningCapability.class, (Capability.IStorage)new ChickenEggSpawningCapabilityStorage(), ChickenEggSpawningCapability::new);
        CapabilityManager.INSTANCE.register(SpawnBlockingCapability.class, (Capability.IStorage)new SpawnBlockingCapabilityStorage(), SpawnBlockingCapability::new);
    }

    @SubscribeEvent
    public static void handleBlocksRegistryEvent(RegistryEvent.Register<Block> blockRegistryEvent) {
        blockRegistryEvent.getRegistry().registerAll((IForgeRegistryEntry[])ModBlocks.BLOCKS);
    }

    @SubscribeEvent
    public static void handleItemsRegistryEvent(RegistryEvent.Register<Item> itemRegistryEvent) {
        Item.Properties properties = new Item.Properties().func_200916_a((ItemGroup)MagicalTorches.setup.magicalTorchesItemGroup);
        for (Block block : ModBlocks.BLOCKS) {
            if (!(block instanceof BlockItemInterface)) continue;
            BlockItemInterface blockItem = (BlockItemInterface)block;
            itemRegistryEvent.getRegistry().register((IForgeRegistryEntry)blockItem.getBlockItem(properties));
        }
    }

    @SubscribeEvent
    public static void onTileEntityRegistry(RegistryEvent.Register<TileEntityType<?>> event) {
        event.getRegistry().register(TileEntityType.Builder.func_223042_a(SoundMufflingTorchTile::new, (Block[])new Block[]{ModBlocks.SOUND_MUFFLING_TORCH}).func_206865_a(null).setRegistryName("sound_muffling_torch"));
    }
}

