/*
 * Decompiled with CFR 0.152.
 */
package de.geheimagentnr1.magical_torches.helpers;

import de.geheimagentnr1.magical_torches.elements.capabilities.spawn_blocking.ISpawnBlockFactory;
import de.geheimagentnr1.magical_torches.elements.capabilities.spawn_blocking.SpawnBlocker;
import java.util.Comparator;
import java.util.TreeMap;
import java.util.TreeSet;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;

public class SpawnBlockerNBTHelper {
    private static final String registryNameName = "registry_name";
    private static final String xName = "x";
    private static final String yName = "y";
    private static final String zName = "z";

    public static ListNBT serializeSpawnBlockers(TreeSet<SpawnBlocker> spawnBlockers) {
        ListNBT nbt = new ListNBT();
        for (SpawnBlocker spawnBlocker : spawnBlockers) {
            BlockPos pos = spawnBlocker.getPos();
            CompoundNBT compoundNBT = new CompoundNBT();
            compoundNBT.func_74778_a(registryNameName, spawnBlocker.getRegistryName().toString());
            compoundNBT.func_74768_a(xName, pos.func_177958_n());
            compoundNBT.func_74768_a(yName, pos.func_177956_o());
            compoundNBT.func_74768_a(zName, pos.func_177952_p());
            nbt.add((Object)compoundNBT);
        }
        return nbt;
    }

    public static TreeSet<SpawnBlocker> deserializeSpawnBlockers(ListNBT nbt, TreeMap<ResourceLocation, ISpawnBlockFactory> spawnBlockingRegistery) {
        TreeSet<SpawnBlocker> spawnBlockers = new TreeSet<SpawnBlocker>(Comparator.comparing(SpawnBlocker::getPos));
        for (INBT inbt : nbt) {
            String registry_name_string;
            ResourceLocation registry_name;
            CompoundNBT compoundNBT;
            if (!(inbt instanceof CompoundNBT) || !(compoundNBT = (CompoundNBT)inbt).func_150297_b(registryNameName, 8) || (registry_name = ResourceLocation.func_208304_a((String)(registry_name_string = compoundNBT.func_74779_i(registryNameName)))) == null || !compoundNBT.func_150297_b(xName, 3) || !compoundNBT.func_150297_b(yName, 3) || !compoundNBT.func_150297_b(zName, 3)) continue;
            BlockPos pos = new BlockPos((Vector3i)new BlockPos(compoundNBT.func_74762_e(xName), compoundNBT.func_74762_e(yName), compoundNBT.func_74762_e(zName)));
            ISpawnBlockFactory factory = spawnBlockingRegistery.get(registry_name);
            if (factory == null) continue;
            spawnBlockers.add(factory.buildSpawnBlocker(pos));
        }
        return spawnBlockers;
    }
}

