/*
 * Decompiled with CFR 0.152.
 */
package com.libraries.rabbit.gui.base;

import com.libraries.rabbit.gui.base.IStage;
import com.libraries.rabbit.gui.base.WidgetContainer;
import com.libraries.rabbit.gui.component.IGui;
import com.libraries.rabbit.gui.show.IShow;
import java.io.IOException;
import java.util.Stack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class Stage
extends GuiScreen
implements IStage {
    protected IShow show;
    private Stack<IShow> showHistory = new Stack();

    public Stage() {
    }

    public Stage(IShow show) {
        this.display(show);
    }

    @Override
    public void close() {
        Minecraft.func_71410_x().func_71381_h();
    }

    @Override
    public void display(IShow show) {
        this.setShow(show);
        show.setStage(this);
        this.reinitShow(true);
        this.pushHistory(this.show);
    }

    @Override
    public void displayPrevious() {
        if (this.getShowHistory().size() != 0) {
            if (this.getShowHistory().size() == 1) {
                this.close();
            } else {
                this.getShowHistory().pop();
                this.display(this.getShowHistory().pop());
            }
        }
    }

    public boolean func_73868_f() {
        return false;
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.show.onDraw(mouseX, mouseY, partialTicks);
    }

    @Override
    public IShow getShow() {
        return this.show;
    }

    @Override
    public Stack<IShow> getShowHistory() {
        return this.showHistory;
    }

    public void func_146274_d() throws IOException {
        super.func_146274_d();
        this.show.onMouseInput();
    }

    public final void func_73866_w_() {
        this.reinitShow();
    }

    protected void func_73869_a(char typedChar, int typedKeyIndex) {
        this.show.onKeyTyped(typedChar, typedKeyIndex);
        if (typedKeyIndex == 1) {
            Minecraft.func_71410_x().func_71381_h();
        }
    }

    public void func_73864_a(int clickX, int clickY, int mouseIndex) {
        this.show.onMouseClicked(clickX, clickY, mouseIndex, false);
    }

    protected void func_146286_b(int mouseX, int mouseY, int type) {
        super.func_146286_b(mouseX, mouseY, type);
        if (type == 0 || type == 1) {
            this.show.onMouseRelease(mouseX, mouseY);
        }
    }

    public void func_146281_b() {
        this.show.onClose();
    }

    private void pushHistory(IShow show) {
        if (this.showHistory.contains(show)) {
            this.showHistory.remove(show);
        }
        this.showHistory.push(show);
    }

    @Override
    public void reinitShow() {
        this.reinitShow(false);
    }

    @Override
    public void reinitShow(boolean forceInit) {
        this.show.setSize(this.field_146294_l, this.field_146295_m);
        if (this.show instanceof WidgetContainer) {
            ((WidgetContainer)((Object)this.show)).getComponentsList().clear();
        }
        if (!this.show.hasBeenInitialized() || forceInit) {
            this.show.onInit();
        }
        this.show.setup();
        if (this.show instanceof WidgetContainer) {
            ((WidgetContainer)((Object)this.show)).getComponentsList().forEach(IGui::setup);
        }
    }

    @Override
    public Stage setShow(IShow show) {
        this.show = show;
        return this;
    }

    public void func_73876_c() {
        this.show.onUpdate();
    }
}

