/*
 * Decompiled with CFR 0.152.
 */
package com.libraries.rabbit.gui.component;

import com.libraries.rabbit.gui.base.WidgetContainer;
import com.libraries.rabbit.gui.component.IGui;
import com.libraries.rabbit.gui.exception.IdAlreadyRegisteredException;
import com.libraries.rabbit.gui.layout.LayoutComponent;
import com.libraries.rabbit.gui.utils.Geometry;
import java.util.ArrayList;
import java.util.List;

public abstract class GuiWidget
implements IGui,
WidgetContainer {
    protected WidgetContainer parent;
    protected List<IGui> components;
    @LayoutComponent
    protected String id;
    @LayoutComponent
    protected int x;
    @LayoutComponent
    protected int y;
    @LayoutComponent
    protected int width;
    @LayoutComponent
    protected int height;

    protected GuiWidget() {
        this.x = -1;
        this.y = -1;
        this.width = -1;
        this.height = -1;
    }

    protected GuiWidget(int x, int y, int width, int height) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
    }

    protected final void assignId(String id) {
        if (this.findComponentById(id) != null) {
            throw new IdAlreadyRegisteredException("Id " + id + " already occupied");
        }
        this.id = id;
    }

    @Override
    public List<IGui> getComponentsList() {
        if (this.components == null) {
            this.components = new ArrayList<IGui>();
        }
        return this.components;
    }

    public int getHeight() {
        return this.height;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public WidgetContainer getParent() {
        return this.parent;
    }

    public int getWidth() {
        return this.width;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public boolean isUnderMouse(int mouseX, int mouseY) {
        return Geometry.isDotInArea(this.x, this.y, this.width, this.height, mouseX, mouseY);
    }

    @Override
    public void onClose() {
        this.getComponentsList().forEach(com -> com.onClose());
    }

    @Override
    public void onDraw(int mouseX, int mouseY, float partialTicks) {
        this.getComponentsList().forEach(com -> com.onDraw(mouseX, mouseY, partialTicks));
    }

    @Override
    public void onKeyTyped(char typedChar, int typedIndex) {
        this.getComponentsList().forEach(com -> com.onKeyTyped(typedChar, typedIndex));
    }

    @Override
    public boolean onMouseClicked(int posX, int posY, int mouseButtonIndex, boolean overlap) {
        boolean clicked = false;
        for (IGui com : this.getComponentsList()) {
            clicked = com.onMouseClicked(posX, posY, mouseButtonIndex, clicked) || clicked;
        }
        return clicked;
    }

    @Override
    public void onMouseInput() {
        this.getComponentsList().forEach(com -> com.onMouseInput());
    }

    @Override
    public void onMouseRelease(int mouseX, int mouseY) {
        this.getComponentsList().forEach(com -> com.onMouseRelease(mouseX, mouseY));
    }

    @Override
    public void onRegistered(WidgetContainer pane) {
        this.setParent(pane);
    }

    @Override
    public void onUpdate() {
        this.getComponentsList().forEach(com -> com.onUpdate());
    }

    @Override
    public void registerComponent(IGui component) {
        this.getComponentsList().add(component);
        if (component instanceof WidgetContainer) {
            ((WidgetContainer)((Object)component)).onRegistered(this);
        }
    }

    public GuiWidget setHeight(int height) {
        this.height = height;
        return this;
    }

    @Override
    public <T> IGui setId(String id) {
        this.assignId(id);
        return this;
    }

    @Override
    public void setParent(WidgetContainer pane) {
        this.parent = pane;
    }

    @Override
    public void setup() {
        this.getComponentsList().clear();
    }

    public GuiWidget setWidth(int width) {
        this.width = width;
        return this;
    }

    public GuiWidget setX(int x) {
        this.x = x;
        return this;
    }

    public GuiWidget setY(int y) {
        this.y = y;
        return this;
    }
}

