/*
 * Decompiled with CFR 0.152.
 */
package com.libraries.rabbit.gui.component.control;

import com.libraries.rabbit.gui.component.control.Button;
import com.libraries.rabbit.gui.component.control.CheckBox;
import com.libraries.rabbit.gui.component.display.Picture;
import com.libraries.rabbit.gui.layout.LayoutComponent;
import com.libraries.rabbit.gui.render.Renderer;
import com.libraries.rabbit.gui.render.TextRenderer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
@LayoutComponent
public class CheckBoxPictureButton
extends Button {
    private CheckBox checkbox;
    private Picture picture;

    protected CheckBoxPictureButton() {
    }

    public CheckBoxPictureButton(int xPos, int yPos, int width, int height, ResourceLocation texture, boolean checked) {
        super(xPos, yPos, width, height, "");
        this.picture = new Picture(xPos + width / 5, yPos + 1, (int)((double)width * 0.8) - 1, (int)((double)height * 0.8) - 1, texture);
        this.checkbox = width <= height ? new CheckBox(xPos + 2, (int)((double)yPos + (double)height * 0.66 - 2.0), height / 3, height / 3, "", checked) : new CheckBox(xPos + 2, yPos + height / 2 - 2, height / 2, height / 2, "", checked);
        this.checkbox.setIsEnabled(false);
    }

    public CheckBoxPictureButton(int xPos, int yPos, int width, int height, String texture, boolean checked) {
        super(xPos, yPos, width, height, "");
        this.picture = new Picture(xPos + width / 5, yPos + 1, (int)((double)width * 0.8) - 1, (int)((double)height * 0.8) - 1, texture);
        this.checkbox = width <= height ? new CheckBox(xPos + 2, (int)((double)yPos + (double)height * 0.66 - 2.0), height / 3, height / 3, "", checked) : new CheckBox(xPos + 2, yPos + height / 2 - 2, height / 2, height / 2, "", checked);
        this.checkbox.setIsEnabled(false);
    }

    @Override
    public void onDraw(int mouseX, int mouseY, float partialTicks) {
        if (this.isVisible()) {
            this.prepareRender();
            if (!this.isEnabled()) {
                this.drawButton(0);
                this.picture.onDraw(mouseX, mouseY, partialTicks);
                this.checkbox.onDraw(mouseX, mouseY, partialTicks);
            } else if (this.isButtonUnderMouse(mouseX, mouseY)) {
                this.drawButton(2);
                this.picture.onDraw(mouseX, mouseY, partialTicks);
                this.checkbox.onDraw(mouseX, mouseY, partialTicks);
                if (this.drawHoverText) {
                    this.verifyHoverText(mouseX, mouseY);
                    if (this.drawToLeft) {
                        int tlineWidth = 0;
                        for (String line : this.hoverText) {
                            tlineWidth = TextRenderer.getFontRenderer().func_78256_a(line) > tlineWidth ? TextRenderer.getFontRenderer().func_78256_a(line) : tlineWidth;
                        }
                        Renderer.drawHoveringText(this.hoverText, mouseX - tlineWidth - 20, mouseY + 12);
                    } else {
                        Renderer.drawHoveringText(this.hoverText, mouseX, mouseY + 12);
                    }
                }
            } else {
                if (this.checkbox.isChecked()) {
                    this.drawButton(0);
                } else {
                    this.drawButton(1);
                }
                this.picture.onDraw(mouseX, mouseY, partialTicks);
                this.checkbox.onDraw(mouseX, mouseY, partialTicks);
            }
        }
    }

    @Override
    public boolean onMouseClicked(int posX, int posY, int mouseButtonIndex, boolean overlap) {
        boolean clicked;
        boolean bl = clicked = this.isButtonUnderMouse(posX, posY) && this.isEnabled() && !overlap;
        if (clicked) {
            if (this.getClickListener() != null) {
                this.getClickListener().onClick(this);
            }
            this.checkbox.setIsChecked(!this.checkbox.isChecked());
            this.playClickSound();
        }
        return clicked;
    }

    public void setToggle(boolean toggle) {
        this.checkbox.setIsChecked(toggle);
    }

    @FunctionalInterface
    public static interface ButtonClickListener {
        public void onClick(CheckBoxPictureButton var1);
    }
}

