/*
 * Decompiled with CFR 0.152.
 */
package com.libraries.rabbit.gui.component.control;

import com.libraries.rabbit.gui.component.GuiWidget;
import com.libraries.rabbit.gui.component.Shiftable;
import com.libraries.rabbit.gui.component.WidgetList;
import com.libraries.rabbit.gui.component.control.Button;
import com.libraries.rabbit.gui.component.control.ScrollBar;
import com.libraries.rabbit.gui.layout.LayoutComponent;
import com.libraries.rabbit.gui.render.Renderer;
import com.libraries.rabbit.gui.render.TextAlignment;
import com.libraries.rabbit.gui.render.TextRenderer;
import com.libraries.rabbit.gui.utils.Geometry;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.TreeMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
@LayoutComponent
public class DropDown<T>
extends GuiWidget
implements WidgetList<T>,
Shiftable {
    protected Map<String, DropDownElement<T>> content = new TreeMap<String, DropDownElement<T>>();
    private Button dropButton;
    protected ScrollBar scrollBar;
    @LayoutComponent
    protected String text;
    protected String selected;
    protected String hovered;
    protected boolean drawUnicode;
    protected boolean isUnrolled = false;
    @LayoutComponent
    protected boolean isVisible = true;
    @LayoutComponent
    protected boolean isEnabled = true;
    protected ResourceLocation texture = new ResourceLocation("textures/gui/widgets.png");
    protected ItemSelectedListener<T> itemSelectedListener;

    public DropDown(int xPos, int yPos, int width, int height) {
        this(xPos, yPos, width, height, "");
    }

    public DropDown(int xPos, int yPos, int width, int height, String text) {
        super(xPos, yPos, width, height);
        this.text = text;
        this.initDropButton();
    }

    public DropDown(int xPos, int yPos, int width, int height, String text, T ... values) {
        this(xPos, yPos, width, height, text);
        this.addAll((Object[])values);
    }

    public DropDown(int xPos, int yPos, int width, int height, T ... values) {
        this(xPos, yPos, width, height);
        this.addAll((Object[])values);
        if (values.length > 0) {
            this.setDefaultItem(String.valueOf(values[0]));
        }
    }

    public DropDown<T> add(String key, T value) {
        this.getContent().put(key, new DropDownElement<T>(this.getContent().size(), value, key));
        return this;
    }

    @Override
    public DropDown<T> add(T value) {
        return this.add(String.valueOf(value), value);
    }

    @Override
    public DropDown<T> addAll(Collection<T> values) {
        values.forEach(object -> this.add(object));
        return this;
    }

    @Override
    public DropDown<T> addAll(T ... values) {
        Arrays.stream(values).forEach(object -> this.add(object));
        return this;
    }

    public DropDown<T> addAndSetDefault(T value) {
        return this.addItemAndSetDefault(String.valueOf(value), value);
    }

    public DropDown<T> addItemAndSetDefault(String name, T value) {
        this.add(name, value);
        this.setDefaultItem(name);
        return this;
    }

    private boolean canFit() {
        return this.content.size() < 4;
    }

    @Override
    public DropDown<T> clear() {
        this.getContent().clear();
        return this;
    }

    public boolean doesDrawUnicode() {
        return this.drawUnicode;
    }

    private void drawDropDownBackground() {
        Renderer.drawRect(this.getX() - 1, this.getY() - 1, this.getX() + this.getWidth() + 1, this.getY() + this.getHeight() + 1, -6250336);
        Renderer.drawRect(this.getX(), this.getY(), this.getX() + this.getWidth() - 13, this.getY() + this.getHeight(), -16777216);
    }

    private void drawExpandedList(int mouseX, int mouseY, float partialTicks) {
        GlStateManager.func_179117_G();
        ArrayList keys = new ArrayList(this.getContent().keySet());
        int unrollHeight = Math.min(keys.size(), 4) * this.getHeight();
        Renderer.drawRect(this.getX() - 1, this.getY() + this.getHeight(), this.getX() + this.getWidth() + 1, this.getY() + this.getHeight() + unrollHeight + 1, -6250336);
        Renderer.drawRect(this.getX(), this.getY() + this.getHeight() + 1, this.getX() + this.getWidth(), this.getY() + this.getHeight() + unrollHeight, -16777216);
        boolean hoverUnrolledList = mouseX >= this.getX() && mouseX <= this.getX() + this.getWidth() && mouseY >= this.getY() && mouseY <= this.getY() + this.getHeight() + unrollHeight + 1;
        int scale = Geometry.computeScaleFactor();
        for (int index = 0; index < keys.size(); ++index) {
            boolean selectedSlot;
            String itemIdentifier = (String)keys.get(index);
            int slotPosY = this.getY() + index * this.height - (int)((float)this.height * this.scrollBar.getProgress() * (float)this.content.size() - (float)(unrollHeight - this.height) * this.scrollBar.getProgress() / 1.0f);
            boolean hoverSlot = mouseX >= this.getX() && mouseX <= this.getX() + this.getWidth() && mouseY >= this.getHeight() + slotPosY && mouseY <= slotPosY + this.getHeight() * 2;
            boolean bl = selectedSlot = hoverSlot || !hoverUnrolledList && itemIdentifier.equalsIgnoreCase(this.getSelectedIdentifier());
            if (slotPosY >= this.getY() + unrollHeight || slotPosY + this.getHeight() <= this.getY()) continue;
            GlStateManager.func_179094_E();
            GL11.glEnable((int)3089);
            Minecraft mc = Minecraft.func_71410_x();
            GL11.glScissor((int)(this.getX() * scale), (int)(mc.field_71440_d - (this.getY() + this.getHeight() + unrollHeight) * scale), (int)(this.getWidth() * scale), (int)(unrollHeight * scale));
            GlStateManager.func_179117_G();
            this.drawSlot(itemIdentifier, this.getX(), this.getHeight() + slotPosY, this.getWidth(), this.getHeight(), selectedSlot);
            GL11.glDisable((int)3089);
            GlStateManager.func_179121_F();
        }
    }

    private void drawSlot(String item, int xPos, int yPos, int width, int height, boolean background) {
        this.drawSlot(item, xPos, yPos, width, height, background, 2);
    }

    private void drawSlot(String item, int xPos, int yPos, int width, int height, boolean background, int drawOffset) {
        String text = "";
        if (this.drawUnicode) {
            TextRenderer.getFontRenderer().func_78264_a(true);
            text = TextRenderer.getFontRenderer().func_78269_a(item, width - drawOffset);
            TextRenderer.getFontRenderer().func_78264_a(false);
        } else {
            text = TextRenderer.getFontRenderer().func_78269_a(item, width - drawOffset);
        }
        GlStateManager.func_179117_G();
        Color color = Color.white;
        if (background) {
            Renderer.drawRect(xPos, yPos, xPos + width, yPos + height - height / 8, -1);
            color = Color.black;
        }
        if (this.drawUnicode) {
            TextRenderer.renderUnicodeString(xPos + 2, yPos + this.getHeight() / 8, text, color, TextAlignment.LEFT);
        } else {
            TextRenderer.renderString(xPos + 2, yPos + this.getHeight() / 8, text, color);
        }
    }

    private boolean expandedListUnderMouse(int mouseX, int mouseY) {
        return mouseX >= this.getX() - 1 && mouseX < this.getX() + this.getWidth() + 1 && mouseY >= this.getY() - 1 && mouseY < this.getY() + this.getHeight() + this.getContent().size() * this.getHeight() - 1;
    }

    @Override
    public Map<String, DropDownElement<T>> getContent() {
        return this.content;
    }

    public DropDownElement<T> getElement(String identifier) {
        return (DropDownElement)this.getContent().get(identifier);
    }

    public ItemSelectedListener<T> getItemSelectedListener() {
        return this.itemSelectedListener;
    }

    private int getScrollerSize() {
        return (int)Math.min((double)Math.max((int)(1.0f * (float)this.height / (float)(this.content.size() * this.height) * (float)(this.height - 4)) * 2, 15), (double)this.height * 0.8);
    }

    public DropDownElement<T> getSelectedElement() {
        return this.getElement(this.selected);
    }

    public String getSelectedIdentifier() {
        return this.selected;
    }

    private void initDropButton() {
        this.dropButton = new Button(this.getX() + this.getWidth() - 12, this.getY(), 12, this.getHeight(), "\u25bc");
    }

    public boolean isEmpty() {
        return this.content != null ? this.content.isEmpty() : true;
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    public boolean isVisible() {
        return this.isVisible;
    }

    @Override
    public void onDraw(int mouseX, int mouseY, float partialTicks) {
        this.scrollBar.setVisiblie(false);
        if (this.isEnabled) {
            if (this.isEmpty()) {
                this.dropButton.setIsEnabled(false);
            } else {
                this.dropButton.setIsEnabled(true);
            }
        }
        if (this.isVisible()) {
            this.underMouse(mouseX, mouseY);
            this.drawDropDownBackground();
            if (this.isUnrolled) {
                this.scrollBar.setVisiblie(!this.canFit());
                this.scrollBar.setHandleMouseWheel(!this.canFit() && this.expandedListUnderMouse(mouseX, mouseY));
                this.scrollBar.setScrollerSize(this.getScrollerSize());
                this.drawExpandedList(mouseX, mouseY, partialTicks);
            }
            if (this.selected != null) {
                this.drawSlot(this.getSelectedIdentifier(), this.getX(), this.getY(), this.getWidth(), this.getHeight(), false, 14);
            }
        }
        super.onDraw(mouseX, mouseY, partialTicks);
    }

    @Override
    public boolean onMouseClicked(int posX, int posY, int mouseButtonIndex, boolean overlap) {
        boolean clicked;
        super.onMouseClicked(posX, posY, mouseButtonIndex, overlap);
        boolean bl = !overlap && (this.isUnrolled ? this.expandedListUnderMouse(posX, posY) : this.underMouse(posX, posY)) ? true : (clicked = false);
        if (!clicked) {
            this.isUnrolled = false;
        }
        if (clicked && this.isEnabled()) {
            if (this.isUnrolled) {
                ArrayList contentKeys = new ArrayList(this.getContent().keySet());
                int unrollHeight = Math.min(contentKeys.size(), 4) * this.getHeight();
                for (int index = 0; index < contentKeys.size(); ++index) {
                    boolean hoverItem;
                    int slotPosY = this.getY() + index * this.height - (int)((float)this.height * this.scrollBar.getProgress() * (float)this.content.size() - (float)(unrollHeight - this.height) * this.scrollBar.getProgress() / 1.0f);
                    boolean bl2 = hoverItem = posX >= this.getX() && posX <= this.getX() + this.getWidth() - this.scrollBar.getWidth() && posY >= this.getHeight() + slotPosY && posY <= slotPosY + this.getHeight() * 2;
                    if (!hoverItem) continue;
                    this.selected = (String)contentKeys.get(index);
                    if (this.getItemSelectedListener() != null) {
                        this.getItemSelectedListener().onItemSelected(this, this.selected);
                    }
                    this.isUnrolled = false;
                    this.scrollBar.setProgress(0.0f);
                }
            }
            if (this.dropButton.isButtonUnderMouse(posX, posY) && !this.isEmpty()) {
                this.isUnrolled = !this.isUnrolled;
            }
        }
        return clicked;
    }

    @Override
    public DropDown<T> remove(T object) {
        this.content.remove(String.valueOf(object));
        return this;
    }

    public DropDown<T> setDefaultItem(String name) {
        if (this.getContent().containsKey(name)) {
            this.selected = name;
        }
        return this;
    }

    public DropDown<T> setDrawUnicode(boolean drawUnicode) {
        this.drawUnicode = drawUnicode;
        return this;
    }

    @Override
    public DropDown<T> setId(String id) {
        this.assignId(id);
        return this;
    }

    public DropDown<T> setIsEnabled(boolean isEnabled) {
        this.isEnabled = isEnabled;
        this.dropButton.setIsEnabled(isEnabled);
        return this;
    }

    public DropDown<T> setIsVisible(boolean isVisible) {
        this.isVisible = isVisible;
        this.dropButton.setIsVisible(isVisible);
        return this;
    }

    public DropDown<T> setItemSelectedListener(ItemSelectedListener<T> listener) {
        this.itemSelectedListener = listener;
        return this;
    }

    @Override
    public void setup() {
        this.registerComponent(this.dropButton);
        int scrollerSize = this.height / (this.content.isEmpty() ? 1 : this.content.size());
        if (scrollerSize < 10) {
            scrollerSize = 10;
        }
        if (this.content.size() < this.height / this.height) {
            scrollerSize = this.height - 4;
        }
        this.scrollBar = new ScrollBar(this.getX() + this.width - 10, this.getY() + this.height, 10, this.height * 4, scrollerSize);
        this.scrollBar.setScrollWeight((float)this.height / (float)(this.content.size() * this.height));
        this.registerComponent(this.scrollBar);
    }

    @Override
    public GuiWidget setX(int x) {
        super.setX(x);
        if (this.scrollBar != null) {
            this.scrollBar.setX(x + this.width - 10);
        }
        return this;
    }

    @Override
    public GuiWidget setY(int y) {
        super.setY(y);
        if (this.scrollBar != null) {
            this.scrollBar.setY(y);
        }
        return this;
    }

    @Override
    public void shiftX(int x) {
        this.setX(this.getX() + x);
    }

    @Override
    public void shiftY(int y) {
        this.setY(this.getY() + y);
    }

    private boolean underMouse(int x, int y) {
        return x >= this.getX() && x <= this.getX() + this.getWidth() && y >= this.getY() && y <= this.getY() + this.getHeight();
    }

    @FunctionalInterface
    public static interface ItemSelectedListener<T> {
        public void onItemSelected(DropDown<T> var1, String var2);
    }

    public class DropDownElement<K> {
        private final int itemIndex;
        private final K itemValue;
        private final String itemName;

        public DropDownElement(int itemIndex, K itemValue, String itemName) {
            this.itemIndex = itemIndex;
            this.itemValue = itemValue;
            this.itemName = itemName;
        }

        public int getItemIndex() {
            return this.itemIndex;
        }

        public String getItemName() {
            return this.itemName;
        }

        public K getValue() {
            return this.itemValue;
        }
    }
}

