/*
 * Decompiled with CFR 0.152.
 */
package com.libraries.rabbit.gui.component.control;

import com.libraries.rabbit.gui.component.GuiWidget;
import com.libraries.rabbit.gui.component.control.ScrollBar;
import com.libraries.rabbit.gui.component.control.TextBox;
import com.libraries.rabbit.gui.render.Renderer;
import com.libraries.rabbit.gui.render.TextRenderer;
import com.libraries.rabbit.gui.utils.Geometry;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Mouse;

@SideOnly(value=Side.CLIENT)
public class MultiTextbox
extends TextBox {
    protected ScrollBar scrollBar;
    protected int maxStringLength = 1000;
    protected int textAreaHeight;

    public MultiTextbox(int xPos, int yPos, int width, int height) {
        super(xPos, yPos, width, height);
        this.textAreaHeight = height;
        this.scrollBar = new ScrollBar(this.getX() + this.getWidth() - 5, this.getY(), 10, this.getHeight(), 20).setVisiblie(false);
    }

    public MultiTextbox(int xPos, int yPos, int width, int height, String initialText) {
        super(xPos, yPos, width, height, initialText);
        this.textAreaHeight = height;
        this.scrollBar = new ScrollBar(this.getX() + this.getWidth() - 5, this.getY(), 10, this.getHeight(), 20).setVisiblie(false);
    }

    @Override
    protected void drawBox() {
        if (this.isVisible()) {
            GlStateManager.func_179094_E();
            if (this.isBackgroundVisible()) {
                this.drawTextBoxBackground();
            }
            TextRenderer.getFontRenderer().func_78264_a(this.drawUnicode);
            int color = this.isEnabled ? this.getEnabledColor() : this.getDisabledColor();
            boolean renderCursor = this.isFocused() && this.cursorCounter / 6L % 2L == 0L;
            int startLine = this.getStartLineY();
            int maxLineAmount = this.height / TextRenderer.getFontRenderer().field_78288_b + startLine;
            List<String> lines = this.getLines();
            int charCount = 0;
            int lineCount = 0;
            int from = Math.min(this.getCursorPosition(), this.selectionEnd);
            int to = Math.max(this.getCursorPosition(), this.selectionEnd);
            boolean renderSelection = !this.getSelectedText().isEmpty();
            boolean renderSelectionLine = false;
            int maxWidth = this.scrollBar.isVisible() ? this.width - 14 : this.width - 4;
            for (String wholeLine : lines) {
                String line = "";
                if (TextRenderer.getFontRenderer().func_78256_a(wholeLine) > maxWidth || this.getCursorPosition() > charCount && this.getCursorPosition() < charCount + wholeLine.length() || renderSelection && from >= charCount && from <= charCount + wholeLine.length() || to >= charCount && to <= charCount + wholeLine.length()) {
                    for (char c : wholeLine.toCharArray()) {
                        int lineY;
                        int startX;
                        if (TextRenderer.getFontRenderer().func_78256_a(line + c) > maxWidth) {
                            if (lineCount >= startLine && lineCount < maxLineAmount) {
                                TextRenderer.getFontRenderer().func_78276_b(line, this.getX() + 4, this.getY() + 4 + (lineCount - startLine) * TextRenderer.getFontRenderer().field_78288_b, color);
                            }
                            if (renderSelectionLine) {
                                if (from <= charCount - line.length()) {
                                    startX = this.getX() + 3;
                                    lineY = this.getY() + (lineCount - startLine) * TextRenderer.getFontRenderer().field_78288_b + 4;
                                    this.renderSelectionRect(startX, lineY, startX + TextRenderer.getFontRenderer().func_78256_a(line) + 2, lineY + TextRenderer.getFontRenderer().field_78288_b);
                                } else {
                                    startX = this.getX() + TextRenderer.getFontRenderer().func_78256_a(line) + 3;
                                    lineY = this.getY() + (lineCount - startLine) * TextRenderer.getFontRenderer().field_78288_b + 4;
                                    this.renderSelectionRect(startX, lineY, startX + TextRenderer.getFontRenderer().func_78256_a(line.substring(charCount - from)) + 2, lineY + TextRenderer.getFontRenderer().field_78288_b);
                                }
                            }
                            line = "";
                            ++lineCount;
                        }
                        if (renderSelection) {
                            if (charCount == from) {
                                renderSelectionLine = true;
                                startX = this.getX() + TextRenderer.getFontRenderer().func_78256_a(line) + 3;
                                lineY = this.getY() + (lineCount - startLine) * TextRenderer.getFontRenderer().field_78288_b + 4;
                                if (TextRenderer.getFontRenderer().func_78256_a(wholeLine) > maxWidth) {
                                    // empty if block
                                }
                                if (wholeLine.contains(this.getSelectedText())) {
                                    renderSelectionLine = false;
                                    renderSelection = false;
                                    this.renderSelectionRect(startX, lineY, startX + TextRenderer.getFontRenderer().func_78256_a(this.getSelectedText()) + 2, lineY + TextRenderer.getFontRenderer().field_78288_b);
                                }
                            } else if (charCount == to) {
                                renderSelectionLine = false;
                                renderSelection = false;
                                startX = this.getX() + 3;
                                lineY = this.getY() + (lineCount - startLine) * TextRenderer.getFontRenderer().field_78288_b + 4;
                                this.renderSelectionRect(startX, lineY, startX + TextRenderer.getFontRenderer().func_78256_a(line) + 2, lineY + TextRenderer.getFontRenderer().field_78288_b);
                            } else if (charCount > to) {
                                renderSelectionLine = false;
                                renderSelection = false;
                            }
                        }
                        if (renderCursor && charCount == this.getCursorPosition() && lineCount >= startLine && lineCount < maxLineAmount) {
                            int cursorX = this.getX() + TextRenderer.getFontRenderer().func_78256_a(line) + 3;
                            int cursorY = this.getY() + (lineCount - startLine) * TextRenderer.getFontRenderer().field_78288_b + 4;
                            if (this.getText().length() == this.getCursorPosition() || c == '\n') {
                                TextRenderer.getFontRenderer().func_78276_b("_", cursorX, cursorY, -1);
                            } else {
                                Renderer.drawRect(cursorX, cursorY, cursorX + 1, cursorY + 10, -1);
                            }
                        }
                        ++charCount;
                        line = line + c;
                    }
                }
                if (lineCount >= startLine && lineCount < maxLineAmount) {
                    TextRenderer.getFontRenderer().func_78276_b(line, this.getX() + 4, this.getY() + 4 + (lineCount - startLine) * TextRenderer.getFontRenderer().field_78288_b, color);
                    if (renderCursor && charCount == this.getCursorPosition()) {
                        int cursorX = this.getX() + TextRenderer.getFontRenderer().func_78256_a(line) + 3;
                        int cursorY = this.getY() + (lineCount - startLine) * TextRenderer.getFontRenderer().field_78288_b + 4;
                        if (this.getText().length() == this.getCursorPosition() || this.getText().toCharArray()[Math.min(charCount, this.getText().toCharArray().length - 1)] == '\n') {
                            TextRenderer.getFontRenderer().func_78276_b("_", cursorX, cursorY, -1);
                        } else {
                            Renderer.drawRect(cursorX, cursorY, cursorX + 1, cursorY + TextRenderer.getFontRenderer().field_78288_b, -1);
                        }
                    }
                }
                if (renderSelectionLine) {
                    if (from <= charCount - line.length()) {
                        int startX = this.getX() + 3;
                        int lineY = this.getY() + (lineCount - startLine) * TextRenderer.getFontRenderer().field_78288_b + 4;
                        this.renderSelectionRect(startX, lineY, startX + TextRenderer.getFontRenderer().func_78256_a(line) + 2, lineY + TextRenderer.getFontRenderer().field_78288_b);
                    } else {
                        String substring = line.substring(line.length() - (charCount - from));
                        int startX = this.getX() + TextRenderer.getFontRenderer().func_78256_a(line.replace(substring, "")) + 3;
                        int lineY = this.getY() + (lineCount - startLine) * TextRenderer.getFontRenderer().field_78288_b + 4;
                        this.renderSelectionRect(startX, lineY, startX + TextRenderer.getFontRenderer().func_78256_a(substring) + 2, lineY + TextRenderer.getFontRenderer().field_78288_b);
                    }
                    if (renderSelectionLine && charCount >= to) {
                        renderSelectionLine = false;
                        renderSelection = false;
                    }
                }
                ++lineCount;
                ++charCount;
            }
            this.textAreaHeight = lineCount * TextRenderer.getFontRenderer().field_78288_b;
            this.scrollBar.setVisiblie(this.textAreaHeight > this.height - 4);
            int scale = Geometry.computeScaleFactor();
            this.scrollBar.setHandleMouseWheel(this.textAreaHeight > this.height - 4 && this.isUnderMouse(Mouse.getX() / scale, (Minecraft.func_71410_x().field_71440_d - Mouse.getY()) / scale));
            this.scrollBar.setScrollerSize(this.getScrollerSize());
            GlStateManager.func_179117_G();
            GlStateManager.func_179121_F();
            TextRenderer.getFontRenderer().func_78264_a(false);
        }
    }

    public List<String> getLines() {
        char[] chars;
        ArrayList<String> lines = new ArrayList<String>();
        StringBuffer currentLine = new StringBuffer();
        for (char symbol : chars = this.getText().toCharArray()) {
            if (symbol == '\r' || symbol == '\n') {
                lines.add(currentLine.toString());
                currentLine.delete(0, currentLine.length());
                continue;
            }
            currentLine.append(symbol);
        }
        lines.add(currentLine.toString());
        return lines;
    }

    @Override
    public int getMaxLength() {
        return this.maxStringLength;
    }

    protected int getScrollerSize() {
        return (int)(1.0f * (float)this.height / (float)this.textAreaHeight * (float)(this.height - 4));
    }

    public int getStartLineY() {
        if (this.scrollBar != null && this.scrollBar.isVisible()) {
            float scrolled = this.scrollBar.getScrolledAmt();
            return MathHelper.func_76123_f((float)(scrolled * (float)this.getHeight() / (float)TextRenderer.getFontRenderer().field_78288_b));
        }
        return 0;
    }

    @Override
    protected boolean handleInput(char typedChar, int typedKeyIndex) {
        String originalText = this.getText();
        switch (typedKeyIndex) {
            case 28: {
                this.setTextWithEvent(originalText.substring(0, this.getCursorPosition()) + "\n" + originalText.substring(this.getCursorPosition()));
                this.setCursorPosition(this.getCursorPosition() + 1);
                return true;
            }
            case 200: {
                List<String> lines = this.getLines();
                int charCount = 0;
                int lineCount = 0;
                int startLine = this.getStartLineY();
                int maxWidth = this.width - 4;
                int prevLineLength = this.getText().length();
                for (int i = 0; i < lines.size(); ++i) {
                    char[] chars;
                    String wholeLine = lines.get(i);
                    String line = "";
                    for (char c : chars = wholeLine.toCharArray()) {
                        if (TextRenderer.getFontRenderer().func_78256_a(line + c) > maxWidth) {
                            line = "";
                            ++lineCount;
                        }
                        if (charCount == this.getCursorPosition()) {
                            this.setCursorPosition(Math.max(0, charCount - (prevLineLength < line.length() ? line.length() + 1 : prevLineLength + 1)));
                            return true;
                        }
                        ++charCount;
                        line = line + c;
                    }
                    if (lineCount >= startLine && charCount == this.getCursorPosition()) {
                        this.setCursorPosition(Math.max(0, charCount - (prevLineLength < line.length() ? line.length() + 1 : prevLineLength + 1)));
                        return true;
                    }
                    prevLineLength = wholeLine.length();
                    ++lineCount;
                    ++charCount;
                }
                return true;
            }
            case 208: {
                List<String> lines = this.getLines();
                int charCount = 0;
                int startLine = this.getStartLineY();
                int maxWidth = this.width - 4;
                for (int i = startLine; i < lines.size(); ++i) {
                    char[] chars;
                    String wholeLine = lines.get(i);
                    String line = "";
                    for (char c : chars = wholeLine.toCharArray()) {
                        if (TextRenderer.getFontRenderer().func_78256_a(line + c) > maxWidth) {
                            line = "";
                        }
                        if (charCount == this.getCursorPosition()) {
                            if (i + 1 >= lines.size()) {
                                this.setCursorPosition(this.getText().length());
                                return true;
                            }
                            String nextLine = lines.get(i + 1);
                            if (nextLine.length() >= wholeLine.length()) {
                                this.setCursorPosition(Math.min(this.getText().length(), charCount + wholeLine.length() + 1));
                                return true;
                            }
                            this.setCursorPosition(Math.min(this.getText().length(), charCount + (wholeLine.length() - line.length()) + nextLine.length() + 1));
                            return true;
                        }
                        ++charCount;
                        line = line + c;
                    }
                    if (charCount == this.getCursorPosition()) {
                        if (i + 1 >= lines.size()) {
                            this.setCursorPosition(this.getText().length());
                            return true;
                        }
                        String nextLine = lines.get(i + 1);
                        if (nextLine.length() >= wholeLine.length()) {
                            this.setCursorPosition(Math.min(this.getText().length(), charCount + wholeLine.length() + 1));
                            return true;
                        }
                        this.setCursorPosition(Math.min(this.getText().length(), charCount + (wholeLine.length() - line.length()) + nextLine.length() + 1));
                        return true;
                    }
                    ++charCount;
                }
                return true;
            }
        }
        return super.handleInput(typedChar, typedKeyIndex);
    }

    @Override
    protected boolean handleMouseClick(int posX, int posY, int mouseButtonIndex, boolean overlap) {
        boolean clicked = this.isEnabled() && !overlap && this.isTextBoxUnderMouse(posX, posY) && !this.scrollBar.isUnderMouse(posX, posY);
        this.setIsFocused(clicked);
        if (this.isFocused() && mouseButtonIndex == 0) {
            TextRenderer.getFontRenderer().func_78264_a(this.drawUnicode);
            int length = posX - this.getX();
            String temp = TextRenderer.getFontRenderer().func_78269_a(this.text.substring(Math.max(0, Math.min(this.scrollOffset, this.text.length()))), this.getWidth());
            this.setCursorPosition(TextRenderer.getFontRenderer().func_78269_a(temp, length).length() + Math.max(0, Math.min(this.scrollOffset, this.text.length())));
            int x = posX - this.getX();
            int y = (posY - this.getY() - 4) / TextRenderer.getFontRenderer().field_78288_b + this.getStartLineY();
            this.cursorPos = 0;
            List<String> lines = this.getLines();
            int charCount = 0;
            int lineCount = 0;
            int maxWidth = this.getWidth() - 4;
            for (int i = 0; i < lines.size(); ++i) {
                char[] chars;
                String wholeLine = lines.get(i);
                String line = "";
                for (char c : chars = wholeLine.toCharArray()) {
                    if (TextRenderer.getFontRenderer().func_78256_a(line + c) > maxWidth) {
                        line = "";
                        if (y < ++lineCount) break;
                    }
                    if (lineCount == y && x <= TextRenderer.getFontRenderer().func_78256_a(line + c)) {
                        this.setCursorPosition(charCount);
                        return clicked;
                    }
                    ++charCount;
                    line = line + c;
                }
                if (lineCount == y) {
                    this.setCursorPosition(charCount);
                    return clicked;
                }
                ++charCount;
                if (y < ++lineCount) break;
            }
            if (y >= lineCount) {
                this.setCursorPosition(this.getText().length());
            }
            TextRenderer.getFontRenderer().func_78264_a(false);
        }
        return clicked;
    }

    @Override
    public boolean isUnderMouse(int mouseX, int mouseY) {
        return mouseX >= this.getX() && mouseX <= this.getX() + this.getWidth() && mouseY >= this.getY() && mouseY <= this.getY() + this.getHeight();
    }

    @Override
    public void pushText(String text) {
        String result = "";
        int i = this.getCursorPosition() < this.selectionEnd ? this.getCursorPosition() : this.selectionEnd;
        int j = this.getCursorPosition() < this.selectionEnd ? this.selectionEnd : this.getCursorPosition();
        int k = this.getMaxLength() - this.getText().length() - (i - this.selectionEnd);
        if (this.getText().length() > 0) {
            result = result + this.getText().substring(0, i);
        }
        int end = 0;
        if (k < text.length()) {
            result = result + text.substring(0, k);
            end = k;
        } else {
            result = result + text;
            end = text.length();
        }
        if (this.getText().length() > 0 && j < this.getText().length()) {
            result = result + this.getText().substring(j);
        }
        this.setTextWithEvent(result);
        this.moveCursorBy(i - this.selectionEnd + end);
    }

    @Override
    public void setup() {
        this.scrollBar.setX(this.getX() + this.getWidth() - this.scrollBar.getWidth() / 2);
        this.registerComponent(this.scrollBar);
    }

    @Override
    public GuiWidget setX(int x) {
        super.setX(x);
        if (this.scrollBar != null) {
            this.scrollBar.setX(x + this.getWidth() - this.scrollBar.getWidth() / 2);
        }
        return this;
    }

    @Override
    public GuiWidget setY(int y) {
        super.setY(y);
        if (this.scrollBar != null) {
            this.scrollBar.setY(y);
        }
        return this;
    }
}

