/*
 * Decompiled with CFR 0.152.
 */
package com.libraries.rabbit.gui.component.control;

import com.libraries.rabbit.gui.component.GuiWidget;
import com.libraries.rabbit.gui.component.control.Button;
import com.libraries.rabbit.gui.render.TextAlignment;
import com.libraries.rabbit.gui.render.TextRenderer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;

@SideOnly(value=Side.CLIENT)
public class NumberPicker
extends GuiWidget {
    protected int jumpValue = 10;
    protected int value = 0;
    protected int minValue = Integer.MIN_VALUE;
    protected int maxValue = Integer.MAX_VALUE;
    protected NumberChangeListener listener;

    public NumberPicker() {
        this.listener = (p, v) -> {};
    }

    public NumberPicker(int x, int y, int width, int height) {
        super(x, y, width, height);
        this.listener = (p, v) -> {};
    }

    public NumberPicker(int x, int y, int width, int height, int value) {
        this(x, y, width, height);
        this.value = value;
    }

    private void decrease() {
        int newValue = Keyboard.isKeyDown((int)42) ? this.value - this.jumpValue : this.value - 1;
        this.value = newValue > this.minValue ? newValue : this.minValue;
        if (this.getListener() != null) {
            this.getListener().onNumberChange(this, this.value);
        }
    }

    public NumberChangeListener getListener() {
        return this.listener;
    }

    public int getValue() {
        return this.value;
    }

    private void increase() {
        int newValue = Keyboard.isKeyDown((int)42) ? this.value + this.jumpValue : this.value + 1;
        this.value = newValue < this.maxValue ? newValue : this.maxValue;
        if (this.getListener() != null) {
            this.getListener().onNumberChange(this, this.value);
        }
    }

    @Override
    public void onDraw(int mouseX, int mouseY, float partialTicks) {
        super.onDraw(mouseX, mouseY, partialTicks);
        TextRenderer.renderString(this.getX() + this.getWidth() / 2, this.getY() + this.getHeight() / 2 - 5, String.valueOf(this.value), TextAlignment.CENTER);
    }

    public NumberPicker setJumpValue(int jumpValue) {
        this.jumpValue = jumpValue;
        return this;
    }

    public NumberPicker setListener(NumberChangeListener listener) {
        this.listener = listener;
        return this;
    }

    public NumberPicker setMaxValue(int maxValue) {
        this.maxValue = maxValue;
        return this;
    }

    public NumberPicker setMinValue(int minValue) {
        this.minValue = minValue;
        return this;
    }

    @Override
    public void setup() {
        super.setup();
        this.registerComponent(new Button(this.getX(), this.getY(), this.getWidth(), this.getHeight() / 3, "+").setClickListener(btn -> this.increase()));
        this.registerComponent(new Button(this.getX(), this.getY() + this.getHeight() / 3 * 2, this.getWidth(), this.getHeight() / 3, "-").setClickListener(btn -> this.decrease()));
    }

    public void setValue(int value) {
        this.value = value;
    }

    public static interface NumberChangeListener {
        public void onNumberChange(NumberPicker var1, int var2);
    }
}

