/*
 * Decompiled with CFR 0.152.
 */
package com.libraries.rabbit.gui.component.control;

import com.libraries.rabbit.gui.component.control.Button;
import com.libraries.rabbit.gui.component.display.Picture;
import com.libraries.rabbit.gui.layout.LayoutComponent;
import com.libraries.rabbit.gui.render.Renderer;
import com.libraries.rabbit.gui.render.TextRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
@LayoutComponent
public class PictureToggleButton
extends Button {
    private boolean toggle;
    private Picture onPicture;
    private Picture offPicture;

    public PictureToggleButton() {
    }

    public PictureToggleButton(int xPos, int yPos, int width, int height, ResourceLocation ontexture, ResourceLocation offtexture, boolean toggled) {
        super(xPos, yPos, width, height, "");
        this.toggle = toggled;
        this.onPicture = new Picture(xPos + 1, yPos + 1, width - 2, height - 2, ontexture);
        this.offPicture = new Picture(xPos + 1, yPos + 1, width - 2, height - 2, offtexture);
    }

    public PictureToggleButton(int xPos, int yPos, int width, int height, ResourceLocation ontexture, String offtexture, boolean toggled) {
        super(xPos, yPos, width, height, "");
        this.toggle = toggled;
        this.onPicture = new Picture(xPos + 1, yPos + 1, width - 2, height - 2, ontexture);
        this.offPicture = new Picture(xPos + 1, yPos + 1, width - 2, height - 2, offtexture);
    }

    public PictureToggleButton(int xPos, int yPos, int width, int height, String ontexture, ResourceLocation offtexture, boolean toggled) {
        super(xPos, yPos, width, height, "");
        this.toggle = toggled;
        this.onPicture = new Picture(xPos + 1, yPos + 1, width - 2, height - 2, ontexture);
        this.offPicture = new Picture(xPos + 1, yPos + 1, width - 2, height - 2, offtexture);
    }

    public PictureToggleButton(int xPos, int yPos, int width, int height, String ontexture, String offtexture, boolean toggled) {
        super(xPos, yPos, width, height, "");
        this.toggle = toggled;
        this.onPicture = new Picture(xPos + 1, yPos + 1, width - 2, height - 2, ontexture);
        this.offPicture = new Picture(xPos + 1, yPos + 1, width - 2, height - 2, offtexture);
    }

    public boolean isToggled() {
        return this.toggle;
    }

    @Override
    public void onDraw(int mouseX, int mouseY, float partialTicks) {
        if (this.isVisible()) {
            GlStateManager.func_179094_E();
            this.prepareRender();
            if (!this.isEnabled()) {
                this.drawButton(0);
                if (this.toggle) {
                    this.onPicture.onDraw(mouseX, mouseY, partialTicks);
                } else {
                    this.offPicture.onDraw(mouseX, mouseY, partialTicks);
                }
            } else if (this.isButtonUnderMouse(mouseX, mouseY)) {
                this.drawButton(2);
                if (this.toggle) {
                    this.onPicture.onDraw(mouseX, mouseY, partialTicks);
                } else {
                    this.offPicture.onDraw(mouseX, mouseY, partialTicks);
                }
                if (this.drawHoverText) {
                    this.verifyHoverText(mouseX, mouseY);
                    if (this.drawToLeft) {
                        int tlineWidth = 0;
                        for (String line : this.hoverText) {
                            tlineWidth = TextRenderer.getFontRenderer().func_78256_a(line) > tlineWidth ? TextRenderer.getFontRenderer().func_78256_a(line) : tlineWidth;
                        }
                        Renderer.drawHoveringText(this.hoverText, mouseX - tlineWidth - 20, mouseY + 12);
                    } else {
                        Renderer.drawHoveringText(this.hoverText, mouseX, mouseY + 12);
                    }
                }
            } else {
                this.drawButton(1);
                if (this.toggle) {
                    this.onPicture.onDraw(mouseX, mouseY, partialTicks);
                } else {
                    this.offPicture.onDraw(mouseX, mouseY, partialTicks);
                }
            }
            this.endRender();
            GlStateManager.func_179121_F();
        }
    }

    @Override
    public boolean onMouseClicked(int posX, int posY, int mouseButtonIndex, boolean overlap) {
        boolean clicked;
        boolean bl = clicked = this.isButtonUnderMouse(posX, posY) && this.isEnabled() && !overlap;
        if (clicked) {
            if (this.getClickListener() != null) {
                this.getClickListener().onClick(this);
            }
            this.toggle = !this.toggle;
            this.playClickSound();
        }
        return clicked;
    }

    public void setToggle(boolean toggle) {
        this.toggle = toggle;
    }
}

