/*
 * Decompiled with CFR 0.152.
 */
package com.libraries.rabbit.gui.component.control;

import com.libraries.rabbit.gui.component.GuiWidget;
import com.libraries.rabbit.gui.component.Shiftable;
import com.libraries.rabbit.gui.layout.LayoutComponent;
import com.libraries.rabbit.gui.render.Renderer;
import com.libraries.rabbit.gui.render.TextRenderer;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.ChatAllowedCharacters;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
@LayoutComponent
public class TextBox
extends GuiWidget
implements Shiftable {
    public static final int BACKGROUND_GRAY_COLOR = -6250336;
    public static final int BACKGROUND_DARK_COLOR = -16777216;
    public static final int CURSOR_COLOR = -3092272;
    @LayoutComponent
    protected boolean visibleBackground = true;
    @LayoutComponent
    protected boolean isVisible = true;
    @LayoutComponent
    protected boolean isEnabled = true;
    @LayoutComponent
    protected boolean isFocused = false;
    @LayoutComponent
    protected String text;
    protected String initailText;
    protected int cursorPos;
    protected int scrollOffset;
    protected boolean drawUnicode;
    @LayoutComponent
    protected int maxStringLength = 100;
    protected int selectionEnd = -2;
    @LayoutComponent
    protected int enabledColor = 0xE0E0E0;
    @LayoutComponent
    protected int disabledColor = 0x707070;
    protected long cursorCounter = 0L;
    protected TextChangedListener textChangedListener;

    public TextBox(int xPos, int yPos, int width, int height) {
        this(xPos, yPos, width, height, "");
    }

    public TextBox(int xPos, int yPos, int width, int height, String initialText) {
        super(xPos, yPos, width, height);
        this.text = initialText;
        this.initailText = initialText;
        this.setCursorPosition(this.text.length());
        Keyboard.enableRepeatEvents((boolean)true);
    }

    public void deleteTextFromCursor(int amount) {
        if (this.getText().length() != 0) {
            if (this.selectionEnd != this.getCursorPosition()) {
                this.pushText("");
            } else {
                try {
                    boolean negative = amount < 0;
                    int j = negative ? this.getCursorPosition() + amount : this.getCursorPosition();
                    int k = negative ? this.getCursorPosition() : this.getCursorPosition() + amount;
                    String result = "";
                    if (j >= 0) {
                        result = this.getText().substring(0, j);
                    }
                    if (k < this.getText().length()) {
                        result = result + this.getText().substring(k);
                    }
                    this.setTextWithEvent(result);
                    if (negative) {
                        this.moveCursorBy(amount);
                    }
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
        }
    }

    public void deleteWordsFromCursor(int amount) {
        if (this.getText().length() != 0) {
            if (this.selectionEnd != this.getCursorPosition()) {
                this.pushText("");
            } else {
                this.deleteTextFromCursor(this.getAmountOfWordsFromPos(amount, this.getCursorPosition(), true) - this.getCursorPosition());
            }
        }
    }

    public boolean doesDrawUnicode() {
        return this.drawUnicode;
    }

    protected void drawBox() {
        if (this.isVisible()) {
            GlStateManager.func_179094_E();
            if (this.isBackgroundVisible()) {
                this.drawTextBoxBackground();
            }
            GlStateManager.func_179117_G();
            TextRenderer.getFontRenderer().func_78264_a(this.drawUnicode);
            int textColor = this.isEnabled() ? this.getEnabledColor() : this.getDisabledColor();
            int cursorPosWithOffset = this.getCursorPosition() - this.scrollOffset;
            int selEnd = this.selectionEnd - this.scrollOffset;
            String drawText = TextRenderer.getFontRenderer().func_78269_a(this.text.substring(Math.max(0, Math.min(this.scrollOffset, this.text.length()))), this.isBackgroundVisible() ? this.getWidth() - 8 : this.getWidth());
            boolean isCursorVisible = cursorPosWithOffset >= 0 && cursorPosWithOffset <= drawText.length();
            boolean shouldRenderCursor = this.isFocused() && this.cursorCounter / 6L % 2L == 0L && isCursorVisible;
            int firstTextX = this.isBackgroundVisible() ? this.getX() + 4 : this.getX();
            int textY = this.isBackgroundVisible() ? this.getY() + (this.getHeight() - 8) / 2 : this.getY();
            int secondTextX = firstTextX;
            if (selEnd > drawText.length()) {
                selEnd = drawText.length();
            }
            if (drawText.length() > 0) {
                String firstText = isCursorVisible ? drawText.substring(0, cursorPosWithOffset) : drawText;
                secondTextX = TextRenderer.getFontRenderer().func_175063_a(firstText, (float)firstTextX, (float)textY, textColor);
            }
            boolean isCursorInText = this.getCursorPosition() < this.getText().length() || this.getText().length() >= this.getMaxLength();
            int cursorX = secondTextX--;
            if (!isCursorVisible) {
                cursorX = cursorPosWithOffset > 0 ? firstTextX + this.getWidth() : firstTextX;
            } else if (isCursorInText) {
                cursorX = secondTextX;
            }
            if (drawText.length() > 0 && isCursorVisible && cursorPosWithOffset < drawText.length()) {
                TextRenderer.getFontRenderer().func_175063_a(drawText.substring(cursorPosWithOffset), (float)secondTextX, (float)textY, textColor);
            }
            if (shouldRenderCursor) {
                if (isCursorInText) {
                    Renderer.drawRect(cursorX, textY - 1, cursorX + 1, textY + 1 + TextRenderer.getFontRenderer().field_78288_b, -3092272);
                } else {
                    TextRenderer.getFontRenderer().func_175063_a("_", (float)cursorX, (float)textY, textColor);
                }
            }
            if (selEnd != cursorPosWithOffset) {
                int finishX = firstTextX + TextRenderer.getFontRenderer().func_78256_a(drawText.substring(0, selEnd));
                this.renderSelectionRect(cursorX, textY - 1, finishX - 1, textY + 1 + TextRenderer.getFontRenderer().field_78288_b);
            }
            GlStateManager.func_179117_G();
            GlStateManager.func_179121_F();
            TextRenderer.getFontRenderer().func_78264_a(false);
        }
    }

    protected void drawTextBoxBackground() {
        Renderer.drawRect(this.getX() - 1, this.getY() - 1, this.getX() + this.getWidth() + 1, this.getY() + this.getHeight() + 1, -6250336);
        Renderer.drawRect(this.getX(), this.getY(), this.getX() + this.getWidth(), this.getY() + this.getHeight(), -16777216);
    }

    public int getAmountOfWordsFromPos(boolean negative, int absolute, int pos, boolean flag) {
        int result = pos;
        for (int i = 0; i < absolute; ++i) {
            if (negative) {
                while (flag && result > 0 && this.getText().charAt(result - 1) == ' ') {
                    --result;
                }
                while (result > 0 && this.getText().charAt(result - 1) != ' ') {
                    --result;
                }
                continue;
            }
            result = this.getText().indexOf(32, result);
            if (result == -1) {
                result = this.getText().length();
                continue;
            }
            while (flag && result < this.getText().length() && this.getText().charAt(result) == ' ') {
                ++result;
            }
        }
        return result;
    }

    public int getAmountOfWordsFromPos(int n, int pos, boolean flag) {
        return this.getAmountOfWordsFromPos(n < 0, Math.abs(n), pos, flag);
    }

    public int getCursorPosition() {
        return this.cursorPos;
    }

    public int getDisabledColor() {
        return this.disabledColor;
    }

    public int getEnabledColor() {
        return this.enabledColor;
    }

    public int getMaxLength() {
        return this.maxStringLength;
    }

    public String getSelectedText() {
        int from = Math.max(0, Math.min(this.getCursorPosition(), this.selectionEnd));
        int to = Math.max(0, Math.max(this.getCursorPosition(), this.selectionEnd));
        return this.getText().substring(from, to);
    }

    public String getText() {
        return this.text;
    }

    public TextChangedListener getTextChangedListener() {
        return this.textChangedListener;
    }

    protected boolean handleInput(char typedChar, int typedKeyIndex) {
        switch (typedKeyIndex) {
            case 14: {
                if (this.isEnabled()) {
                    if (GuiScreen.func_146271_m()) {
                        this.deleteWordsFromCursor(-1);
                    } else {
                        this.deleteTextFromCursor(-1);
                    }
                }
                return true;
            }
            case 199: {
                this.setCursorPosition(0);
                return true;
            }
            case 203: {
                this.handleKeyboardArrow(-1);
                return true;
            }
            case 205: {
                this.handleKeyboardArrow(1);
                return true;
            }
            case 207: {
                this.setCursorPosition(this.getText().length());
                return true;
            }
            case 211: {
                if (this.isEnabled()) {
                    if (GuiScreen.func_146271_m()) {
                        this.deleteWordsFromCursor(1);
                    } else {
                        this.deleteTextFromCursor(1);
                    }
                }
                return true;
            }
        }
        if (this.isEnabled() && ChatAllowedCharacters.func_71566_a((char)typedChar)) {
            this.pushText(Character.toString(typedChar));
            return true;
        }
        return false;
    }

    protected void handleKey(char typedChar, int typedIndex) {
        if (!this.isFocused()) {
            return;
        }
        boolean isSpecialCharCombination = this.handleSpecialCharComb(typedChar, typedIndex);
        if (!isSpecialCharCombination) {
            this.handleInput(typedChar, typedIndex);
        }
    }

    private void handleKeyboardArrow(int n) {
        if (GuiScreen.func_146272_n()) {
            if (GuiScreen.func_146271_m()) {
                this.setSelectionPos(this.getAmountOfWordsFromPos(n, this.selectionEnd, true));
            } else {
                this.setSelectionPos(this.selectionEnd + n);
            }
        } else if (GuiScreen.func_146271_m()) {
            this.setCursorPosition(this.getAmountOfWordsFromPos(n, this.getCursorPosition(), true));
        } else {
            this.setCursorPosition(this.cursorPos + n);
        }
    }

    protected boolean handleMouseClick(int posX, int posY, int mouseButtonIndex, boolean overlap) {
        boolean clicked = this.isTextBoxUnderMouse(posX, posY) && !overlap;
        this.setIsFocused(clicked);
        if (this.isFocused() && mouseButtonIndex == 0) {
            int lenght = posX - this.getX();
            TextRenderer.getFontRenderer().func_78264_a(this.drawUnicode);
            String temp = TextRenderer.getFontRenderer().func_78269_a(this.text.substring(this.scrollOffset), this.getWidth());
            this.setCursorPosition(TextRenderer.getFontRenderer().func_78269_a(temp, lenght).length() + this.scrollOffset);
            TextRenderer.getFontRenderer().func_78264_a(false);
        }
        return clicked;
    }

    protected boolean handleSpecialCharComb(char typedChar, int typedIndex) {
        switch (typedChar) {
            case '\u0001': {
                this.setCursorPosition(this.getText().length());
                this.setSelectionPos(0);
                return true;
            }
            case '\u0003': {
                GuiScreen.func_146275_d((String)this.getSelectedText());
                return true;
            }
            case '\u0016': {
                if (this.isEnabled()) {
                    this.pushText(GuiScreen.func_146277_j());
                }
                return true;
            }
            case '\u0018': {
                GuiScreen.func_146275_d((String)this.getSelectedText());
                if (this.isEnabled()) {
                    this.pushText("");
                }
                return true;
            }
        }
        return false;
    }

    public boolean isBackgroundVisible() {
        return this.visibleBackground;
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    public boolean isFocused() {
        return this.isFocused;
    }

    public boolean isTextBoxUnderMouse(int mouseX, int mouseY) {
        return mouseX >= this.getX() && mouseX <= this.getX() + this.getWidth() && mouseY >= this.getY() && mouseY <= this.getY() + this.getHeight();
    }

    public boolean isVisible() {
        return this.isVisible;
    }

    public void moveCursorBy(int amount) {
        this.setCursorPosition(Math.max(this.selectionEnd, this.cursorPos) + amount);
        this.setSelectionPos(this.cursorPos);
    }

    @Override
    public void onClose() {
        Keyboard.enableRepeatEvents((boolean)false);
    }

    @Override
    public void onDraw(int mouseX, int mouseY, float partialTicks) {
        super.onDraw(mouseX, mouseY, partialTicks);
        this.drawBox();
    }

    @Override
    public void onKeyTyped(char typedChar, int typedIndex) {
        super.onKeyTyped(typedChar, typedIndex);
        this.handleKey(typedChar, typedIndex);
    }

    @Override
    public boolean onMouseClicked(int posX, int posY, int mouseButtonIndex, boolean overlap) {
        super.onMouseClicked(posX, posY, mouseButtonIndex, overlap);
        return this.handleMouseClick(posX, posY, mouseButtonIndex, overlap);
    }

    @Override
    public void onUpdate() {
        ++this.cursorCounter;
    }

    public void pushText(String text) {
        String result = "";
        String filtered = ChatAllowedCharacters.func_71565_a((String)text);
        int i = this.getCursorPosition() < this.selectionEnd ? this.getCursorPosition() : this.selectionEnd;
        int j = this.getCursorPosition() < this.selectionEnd ? this.selectionEnd : this.getCursorPosition();
        int k = this.getMaxLength() - this.getText().length() - (i - this.selectionEnd);
        if (this.getText().length() > 0) {
            result = result + this.getText().substring(0, i);
        }
        int end = 0;
        if (k < filtered.length()) {
            result = result + filtered.substring(0, k);
            end = k;
        } else {
            result = result + filtered;
            end = filtered.length();
        }
        if (this.getText().length() > 0 && j < this.getText().length()) {
            result = result + this.getText().substring(j);
        }
        this.setTextWithEvent(result);
        this.moveCursorBy(i - this.selectionEnd + end);
    }

    protected void renderSelectionRect(int xTop, int yTop, int xBot, int yBot) {
        Renderer.drawRectWithSpecialGL(xTop, yTop, xBot, yBot, -16777215, () -> {
            GlStateManager.func_179131_c((float)255.0f, (float)255.0f, (float)255.0f, (float)255.0f);
            GlStateManager.func_179090_x();
            GL11.glEnable((int)3058);
            GL11.glLogicOp((int)5387);
        });
        GL11.glDisable((int)3058);
    }

    public TextBox setBackgroundVisibility(boolean visibleBackground) {
        this.visibleBackground = visibleBackground;
        return this;
    }

    public TextBox setCursorPosition(int pos) {
        this.cursorPos = pos;
        if (this.cursorPos < 0) {
            this.cursorPos = 0;
        }
        if (this.cursorPos > this.getText().length()) {
            this.cursorPos = this.getText().length();
        }
        if (!GuiScreen.func_146272_n()) {
            this.setSelectionPos(this.cursorPos);
        }
        return this;
    }

    public TextBox setDisabledColor(int color) {
        this.disabledColor = color;
        return this;
    }

    public TextBox setDrawUnicode(boolean drawUnicode) {
        this.drawUnicode = drawUnicode;
        return this;
    }

    public TextBox setEnabledColor(int color) {
        this.enabledColor = color;
        return this;
    }

    @Override
    public TextBox setId(String id) {
        this.assignId(id);
        return this;
    }

    public TextBox setIsEnabled(boolean isEnabled) {
        this.isEnabled = isEnabled;
        return this;
    }

    public TextBox setIsFocused(boolean isFocused) {
        if (isFocused && this.text == this.initailText) {
            this.setText("");
        } else if (!isFocused && this.text.isEmpty()) {
            this.setText(this.initailText);
        }
        this.isFocused = isFocused;
        return this;
    }

    public TextBox setIsVisible(boolean isVisible) {
        this.isVisible = isVisible;
        return this;
    }

    public TextBox setMaxLength(int max) {
        this.maxStringLength = max;
        return this;
    }

    public TextBox setSelectionPos(int pos) {
        if (pos < 0) {
            pos = 0;
        }
        if (pos > this.getText().length()) {
            pos = this.getText().length();
        }
        this.selectionEnd = pos;
        return this;
    }

    public TextBox setText(String newText) {
        this.text = newText;
        return this;
    }

    public TextBox setTextChangedListener(TextChangedListener listener) {
        this.textChangedListener = listener;
        return this;
    }

    public TextBox setTextWithEvent(String newText) {
        this.setText(newText);
        if (this.getTextChangedListener() != null) {
            this.getTextChangedListener().onTextChanged(this, newText);
        }
        return this;
    }

    @Override
    public void shiftX(int x) {
        this.setX(this.getX() + x);
    }

    @Override
    public void shiftY(int y) {
        this.setY(this.getY() + y);
    }

    @FunctionalInterface
    public static interface TextChangedListener {
        public void onTextChanged(TextBox var1, String var2);
    }
}

