/*
 * Decompiled with CFR 0.152.
 */
package com.libraries.rabbit.gui.component.display;

import com.libraries.rabbit.gui.component.GuiWidget;
import com.libraries.rabbit.gui.render.Renderer;
import com.libraries.rabbit.gui.utils.DoubleChangeListener;
import com.libraries.rabbit.gui.utils.DoubleListener;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class ProgressBar
extends GuiWidget {
    private double progress;
    private ResourceLocation bg = new ResourceLocation("rabbit", "textures/gui/progressbarbg.png");
    private ResourceLocation fg = new ResourceLocation("rabbit", "textures/gui/progressbarfg.png");
    private DoubleListener progressChanged = new DoubleListener(0.0);
    private boolean visible;

    public ProgressBar(int x, int y, int width, int height) {
        super(x, y, width, height);
        DoubleChangeListener listener = event -> {
            this.progress = event.getDispatcher().getValue();
        };
        this.progressChanged.addDoubleChangeListener(listener);
    }

    public double getProgress() {
        return this.progress;
    }

    public DoubleListener getProgressChangedListener() {
        return this.progressChanged;
    }

    public boolean isVisible() {
        return this.visible;
    }

    @Override
    public void onDraw(int mouseX, int mouseY, float partialTicks) {
        super.onDraw(mouseX, mouseY, partialTicks);
        if (this.visible) {
            this.renderBG();
            this.renderFG();
        }
    }

    private void renderBG() {
        GlStateManager.func_179094_E();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179098_w();
        GlStateManager.func_179147_l();
        GL11.glBlendFunc((int)770, (int)771);
        Minecraft.func_71410_x().field_71446_o.func_110577_a(this.bg);
        Renderer.drawScaledTexturedRect(this.getX(), this.getY(), this.getWidth(), this.getHeight());
        GlStateManager.func_179121_F();
    }

    private void renderFG() {
        GlStateManager.func_179094_E();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179098_w();
        GlStateManager.func_179147_l();
        GL11.glBlendFunc((int)770, (int)771);
        Minecraft.func_71410_x().field_71446_o.func_110577_a(this.fg);
        Renderer.drawScaledTexturedRect(this.getX() + 1, this.getY() + 1, (int)((double)(this.getWidth() - 2) * this.progress), this.getHeight() - 2);
        GlStateManager.func_179121_F();
    }

    public void setProgress(double progress) {
        this.progress = progress;
    }

    public void setProgressChangedListener(DoubleListener progressChanged) {
        this.progressChanged = progressChanged;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }
}

