/*
 * Decompiled with CFR 0.152.
 */
package com.libraries.rabbit.gui.component.display;

import com.google.common.collect.Lists;
import com.libraries.rabbit.gui.component.GuiWidget;
import com.libraries.rabbit.gui.component.IGui;
import com.libraries.rabbit.gui.component.control.Button;
import com.libraries.rabbit.gui.utils.Geometry;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class ScissorPanel
extends GuiWidget {
    List<GuiWidget> panelComponents = new ArrayList<GuiWidget>();
    private boolean isDragging = false;
    private boolean isResizing = false;
    private int dragXDelta;
    private int dragYDelta;
    private int resizeXPos;
    private boolean isVisible;
    private boolean isFocused;
    private int z = 0;

    public ScissorPanel(int xPos, int yPos, int width, int height) {
        this(xPos, yPos, width, height, true);
    }

    public ScissorPanel(int xPos, int yPos, int width, int height, boolean visible) {
        super(xPos, yPos, width, height);
        this.isVisible = visible;
        this.isFocused = false;
    }

    public int getZ() {
        return this.z;
    }

    public boolean isFocused() {
        return this.isFocused;
    }

    public void movePanel(int newX, int newY) {
        float xDelta = this.x - newX;
        float yDelta = this.y - newY;
        if (xDelta == 0.0f && yDelta == 0.0f) {
            return;
        }
        this.panelComponents.forEach(com -> {
            com.setX((int)((float)com.getX() - xDelta));
            com.setY((int)((float)com.getY() - yDelta));
        });
        this.x = newX;
        this.y = newY;
    }

    @Override
    public void onDraw(int xMouse, int yMouse, float partialTicks) {
        if (this.isVisible) {
            if (this.isFocused) {
                if (this.isDragging) {
                    this.movePanel(xMouse - this.dragXDelta, yMouse - this.dragYDelta);
                }
                if (this.isResizing) {
                    this.movePanel(xMouse - this.dragXDelta, this.y);
                    this.resize(this.width + (this.resizeXPos - xMouse), this.height);
                    this.resizeXPos = xMouse;
                }
            }
            GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)this.z);
            GlStateManager.func_179094_E();
            Minecraft mc = Minecraft.func_71410_x();
            GL11.glEnable((int)3089);
            int scale = Geometry.computeScaleFactor();
            GL11.glScissor((int)(this.getX() * scale), (int)(mc.field_71440_d - (this.getY() + this.getHeight()) * scale), (int)(this.getWidth() * scale), (int)(this.getHeight() * scale));
            GlStateManager.func_179117_G();
            this.panelComponents.forEach(com -> com.onDraw(xMouse, yMouse, partialTicks));
            GL11.glDisable((int)3089);
            GlStateManager.func_179121_F();
        }
    }

    @Override
    public void onKeyTyped(char typedChar, int typedIndex) {
        if (this.isVisible && this.isFocused) {
            this.panelComponents.forEach(com -> com.onKeyTyped(typedChar, typedIndex));
        }
    }

    @Override
    public boolean onMouseClicked(int posX, int posY, int mouseButtonIndex, boolean overlap) {
        if (this.isVisible && this.isFocused) {
            super.onMouseClicked(posX, posY, mouseButtonIndex, overlap);
            boolean bl = this.isDragging = !overlap && Geometry.isDotInArea(this.x, this.y + 10, 5, this.height - 10, posX, posY);
            if (this.isDragging) {
                this.dragXDelta = posX - this.x;
                this.dragYDelta = posY - this.y;
            }
            if (this.isResizing) {
                this.dragXDelta = posX - this.x;
                this.dragYDelta = posY - this.y;
                this.resizeXPos = posX;
            }
            this.panelComponents.forEach(com -> {
                if (com.onMouseClicked(posX, posY, mouseButtonIndex, overlap)) {
                    this.isResizing = false;
                    this.isDragging = false;
                }
            });
            return this.isDragging | this.isResizing;
        }
        return super.onMouseClicked(posX, posY, mouseButtonIndex, overlap);
    }

    @Override
    public void onMouseInput() {
        if (this.isVisible && this.isFocused) {
            this.panelComponents.forEach(com -> com.onMouseInput());
        }
    }

    @Override
    public void onMouseRelease(int mouseX, int mouseY) {
        super.onMouseRelease(mouseX, mouseY);
        if (this.isVisible && this.isFocused) {
            this.panelComponents.forEach(com -> com.onMouseRelease(mouseX, mouseY));
            if (this.isDragging) {
                this.isDragging = false;
            }
            if (this.isResizing) {
                this.isResizing = false;
            }
        }
    }

    @Override
    public void onUpdate() {
        if (this.isVisible && this.isFocused) {
            this.panelComponents.forEach(com -> com.onUpdate());
        }
    }

    @Override
    public void registerComponent(IGui component) {
        GuiWidget widget = (GuiWidget)component;
        widget.setX(widget.getX() + this.x);
        widget.setY(widget.getY() + this.y);
        this.panelComponents.add(widget);
    }

    public void resize(int newWidth, int newHeight) {
        float widthDelta = (float)newWidth / (float)this.width;
        float heightDelta = (float)newHeight / (float)this.height;
        this.panelComponents.forEach(com -> {
            if (!(com instanceof Button)) {
                com.setWidth((int)((float)com.getWidth() * widthDelta));
                com.setHeight((int)((float)com.getHeight() * heightDelta));
            }
        });
        this.setSize(newWidth, newHeight);
    }

    public ScissorPanel reverseComponents() {
        this.panelComponents = Lists.reverse(this.panelComponents);
        return this;
    }

    public ScissorPanel setFocused(boolean isFocused) {
        this.isFocused = isFocused;
        return this;
    }

    public ScissorPanel setSize(int width, int height) {
        this.width = width;
        this.height = height;
        return this;
    }

    @Override
    public void setup() {
        this.panelComponents.forEach(com -> com.setup());
    }

    public ScissorPanel setVisible(boolean state) {
        if (!state) {
            this.isFocused = false;
        }
        this.isVisible = state;
        return this;
    }

    public ScissorPanel setZ(int zPos) {
        this.z = zPos;
        return this;
    }
}

