/*
 * Decompiled with CFR 0.152.
 */
package com.libraries.rabbit.gui.component.display;

import com.libraries.rabbit.gui.component.GuiWidget;
import com.libraries.rabbit.gui.component.control.ScrollBar;
import com.libraries.rabbit.gui.component.display.TextLabel;
import com.libraries.rabbit.gui.render.TextAlignment;
import com.libraries.rabbit.gui.render.TextRenderer;
import com.libraries.rabbit.gui.utils.Geometry;
import java.util.List;
import net.minecraft.client.Minecraft;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

public class ScrollTextLabel
extends TextLabel {
    private ScrollBar scrollBar;

    public ScrollTextLabel(int xPos, int yPos, int width, int height, String text) {
        super(xPos, yPos, width, height, text);
    }

    public ScrollTextLabel(int xPos, int yPos, int width, int height, String text, TextAlignment align) {
        super(xPos, yPos, width, height, text, align);
    }

    public ScrollTextLabel(int xPos, int yPos, int width, String text) {
        super(xPos, yPos, width, text);
    }

    private boolean canFit() {
        int content = this.getLines().size() * 10;
        return content < this.height;
    }

    @Override
    protected void drawMultilined() {
        this.scrollBar.setVisiblie(!this.canFit());
        int scale = Geometry.computeScaleFactor();
        this.scrollBar.setHandleMouseWheel(!this.canFit() && this.isUnderMouse(Mouse.getX() / scale, (Minecraft.func_71410_x().field_71440_d - Mouse.getY()) / scale));
        List<String> displayLines = this.getLines();
        int scrollerSize = Math.min(Math.max(this.height / (1 + this.getLines().size()), 10), this.height - 4);
        this.scrollBar.setScrollerSize(scrollerSize);
        for (int i = 0; i < displayLines.size(); ++i) {
            String line = displayLines.get(i);
            int lineY = this.getY() + i * 10 - (int)(10.0f * this.scrollBar.getProgress() * (float)displayLines.size() - (float)(this.height - 10) * this.scrollBar.getProgress() / 1.0f);
            GL11.glEnable((int)3089);
            GL11.glScissor((int)(this.getX() * scale), (int)(Minecraft.func_71410_x().field_71440_d - (this.getY() + this.getHeight()) * scale), (int)(this.getWidth() * scale), (int)(this.getHeight() * scale));
            this.drawAlignedLine(this.getX(), lineY, this.getWidth() - 10, line, this.alignment);
            GL11.glDisable((int)3089);
        }
    }

    private List<String> getLines() {
        return TextRenderer.getFontRenderer().func_78271_c(this.getText(), this.width - 10);
    }

    @Override
    public boolean isUnderMouse(int mouseX, int mouseY) {
        return mouseX >= this.getX() && mouseX <= this.getX() + this.getWidth() && mouseY >= this.getY() && mouseY <= this.getY() + this.getHeight();
    }

    public GuiWidget setScrolledAmount(float amt) {
        if (this.scrollBar != null) {
            this.scrollBar.setScrolledAmt(amt);
        }
        return this;
    }

    @Override
    public void setup() {
        super.setup();
        if (this.isMultilined()) {
            int scrollerSize = Math.min(Math.max(this.height / (1 + this.getLines().size()), 10), this.height - 4);
            this.scrollBar = new ScrollBar(this.getX() + this.width - 10, this.getY(), 10, this.height, scrollerSize).setHandleMouseWheel(false);
            this.registerComponent(this.scrollBar);
        }
    }

    @Override
    public GuiWidget setX(int x) {
        super.setX(x);
        if (this.scrollBar != null) {
            this.scrollBar.setX(x + this.width - 10);
        }
        return this;
    }

    @Override
    public GuiWidget setY(int y) {
        super.setY(y);
        if (this.scrollBar != null) {
            this.scrollBar.setY(y);
        }
        return this;
    }
}

