/*
 * Decompiled with CFR 0.152.
 */
package com.libraries.rabbit.gui.component.display;

import com.libraries.rabbit.gui.render.Renderer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public enum ShapeType {
    RECT((x, y, width, height, color) -> Renderer.drawRect(x, y, x + width, y + height, color)),
    TRIANGLE((x, y, width, height, color) -> Renderer.drawTriangle(x, y + height, x + width / 2, y, x + width, y + height, color)),
    CIRCLE((x, y, width, height, color) -> {
        int side = Math.max(width, height);
        Renderer.drawFilledArc(x + side / 2, y + side / 2, side / 2, 0.0, 360.0, color);
    });

    private ShapeDrawer drawer;

    private ShapeType(ShapeDrawer drawer) {
        this.drawer = drawer;
    }

    public void draw(int x, int y, int width, int height, int color) {
        this.drawer.draw(x, y, width, height, color);
    }

    static interface ShapeDrawer {
        public void draw(int var1, int var2, int var3, int var4, int var5);
    }
}

