/*
 * Decompiled with CFR 0.152.
 */
package com.libraries.rabbit.gui.component.display.entity;

import com.libraries.rabbit.gui.component.GuiWidget;
import com.libraries.rabbit.gui.layout.LayoutComponent;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Mouse;

@SideOnly(value=Side.CLIENT)
public class EntityComponent
extends GuiWidget {
    EntityLivingBase entity;
    boolean dragging;
    boolean canRotate;
    @LayoutComponent
    float rotation = 0.0f;
    @LayoutComponent
    float zoom = 1.0f;

    public EntityComponent(int x, int y, int width, int height, EntityLivingBase entity) {
        this(x, y, width, height, entity, 0, 1.0f);
    }

    public EntityComponent(int x, int y, int width, int height, EntityLivingBase entity, int rotation) {
        this(x, y, width, height, entity, rotation, 1.0f);
    }

    public EntityComponent(int x, int y, int width, int height, EntityLivingBase entity, int rotation, float zoom) {
        this(x, y, width, height, entity, rotation, zoom, true);
    }

    public EntityComponent(int x, int y, int width, int height, EntityLivingBase entity, int rotation, float zoom, boolean canRotate) {
        super(x, y, width, height);
        width = (int)(entity.field_70130_N * 30.0f * zoom);
        height = (int)(entity.field_70131_O * 30.0f * zoom);
        this.entity = entity;
        this.rotation = rotation;
        this.zoom = zoom;
        this.canRotate = canRotate;
    }

    public EntityLivingBase getEntity() {
        return this.entity;
    }

    public float getRotation() {
        return this.rotation;
    }

    public float getZoom() {
        return this.zoom;
    }

    @Override
    public void onDraw(int mouseX, int mouseY, float partialTicks) {
        super.onDraw(mouseX, mouseY, partialTicks);
        GlStateManager.func_179142_g();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)this.x, (float)this.y, (float)100.0f);
        GlStateManager.func_179152_a((float)(30.0f * this.zoom), (float)(30.0f * this.zoom), (float)(30.0f * this.zoom));
        GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        GlStateManager.func_179109_b((float)(-this.entity.field_70130_N / 2.0f), (float)(-this.entity.field_70131_O), (float)0.0f);
        RenderHelper.func_74519_b();
        this.entity.field_70759_as = this.entity.field_70761_aq = this.rotation;
        RenderManager rendermanager = Minecraft.func_71410_x().func_175598_ae();
        rendermanager.func_178633_a(false);
        rendermanager.func_188391_a((Entity)this.entity, 0.0, 0.0, 0.0, 0.0f, 1.0f, false);
        rendermanager.func_178633_a(true);
        GlStateManager.func_179121_F();
        RenderHelper.func_74518_a();
        GlStateManager.func_179101_C();
        GlStateManager.func_179138_g((int)OpenGlHelper.field_77476_b);
        GlStateManager.func_179090_x();
        GlStateManager.func_179138_g((int)OpenGlHelper.field_77478_a);
    }

    @Override
    public boolean onMouseClicked(int posX, int posY, int mouseButtonIndex, boolean overlap) {
        boolean clicked;
        super.onMouseClicked(posX, posY, mouseButtonIndex, overlap);
        this.dragging = clicked = !overlap;
        return clicked;
    }

    @Override
    public void onMouseInput() {
        super.onMouseInput();
        if (this.canRotate && this.dragging) {
            this.rotation = (float)((double)this.rotation + (double)Mouse.getEventDX() * 0.5);
        }
    }

    @Override
    public void onMouseRelease(int mouseX, int mouseY) {
        super.onMouseRelease(mouseX, mouseY);
        this.dragging = false;
    }

    public EntityComponent setEntity(EntityLivingBase entity) {
        this.entity = entity;
        return this;
    }

    public EntityComponent setRotation(float rotation) {
        this.rotation = rotation;
        return this;
    }

    public EntityComponent setZoom(float zoom) {
        this.zoom = zoom;
        return this;
    }
}

