/*
 * Decompiled with CFR 0.152.
 */
package com.libraries.rabbit.gui.component.display.tabs;

import com.libraries.rabbit.gui.RabbitGui;
import com.libraries.rabbit.gui.component.GuiWidget;
import com.libraries.rabbit.gui.render.Renderer;
import com.libraries.rabbit.gui.render.TextRenderer;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;

public abstract class Tab
extends GuiWidget {
    protected final ResourceLocation TABS = new ResourceLocation("rabbit", "textures/gui/sm_notification2.png");
    private boolean isVisible;
    protected boolean isHidden = false;
    protected TabClickListener onClick;
    protected List<String> originalHoverText = new ArrayList<String>();
    protected List<String> hoverText = new ArrayList<String>();
    protected int angle;
    protected boolean drawHoverText = true;
    protected boolean drawToLeft;

    public Tab(int x, int y, int width, int height, int angle) {
        super(x, y, width, height);
        this.angle = angle;
    }

    protected void beginDrawingTab(int mouseX, int mouseY, float partialTicks) {
        if (this.angle != 0) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179147_l();
            GlStateManager.func_179120_a((int)770, (int)771, (int)1, (int)0);
            GlStateManager.func_179109_b((float)this.x, (float)this.y, (float)-1.0f);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179114_b((float)this.angle, (float)0.0f, (float)0.0f, (float)1.0f);
            if (this.isHidden) {
                Minecraft.func_71410_x().func_110434_K().func_110577_a(this.TABS);
                this.drawScaledTexturedRect(0, -this.height + 4, 1, this.width, this.height);
                GlStateManager.func_179114_b((float)(-this.angle), (float)0.0f, (float)0.0f, (float)1.0f);
            } else {
                Minecraft.func_71410_x().func_110434_K().func_110577_a(this.TABS);
                this.drawScaledTexturedRect(0, 0, 1, this.width, this.height);
                GlStateManager.func_179114_b((float)(-this.angle), (float)0.0f, (float)0.0f, (float)1.0f);
            }
        } else if (this.isHidden) {
            Minecraft.func_71410_x().func_110434_K().func_110577_a(this.TABS);
            this.drawScaledTexturedRect(this.x, this.y <= 0 ? this.y - this.height + 4 : this.y + this.height - 4, 1, this.width, this.height);
        } else {
            Minecraft.func_71410_x().func_110434_K().func_110577_a(this.TABS);
            this.drawScaledTexturedRect(this.x, this.y, 1, this.width, this.height);
        }
    }

    public boolean doesDrawHoverText() {
        return this.drawHoverText;
    }

    public void drawHoverText(int mouseX, int mouseY, float partialTicks) {
        if (this.drawHoverText && this.isUnderMouse(mouseX, mouseY)) {
            GlStateManager.func_179094_E();
            this.verifyHoverText(mouseX, mouseY);
            if (this.drawToLeft) {
                int tlineWidth = 0;
                for (String line : this.hoverText) {
                    tlineWidth = TextRenderer.getFontRenderer().func_78256_a(line) > tlineWidth ? TextRenderer.getFontRenderer().func_78256_a(line) : tlineWidth;
                }
                Renderer.drawHoveringText(this.hoverText, mouseX - tlineWidth - 20, mouseY + 12);
            } else {
                Renderer.drawHoveringText(this.hoverText, mouseX, mouseY + 12);
            }
            GlStateManager.func_179121_F();
        }
    }

    protected void drawScaledTexturedRect(int x, int y, int z, int width, int height) {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        bufferbuilder.func_181662_b((double)(x + width), (double)(y + height), (double)z).func_187315_a(1.0, 1.0).func_181675_d();
        bufferbuilder.func_181662_b((double)(x + width), (double)y, (double)z).func_187315_a(1.0, 0.0).func_181675_d();
        bufferbuilder.func_181662_b((double)x, (double)y, (double)z).func_187315_a(0.0, 0.0).func_181675_d();
        bufferbuilder.func_181662_b((double)x, (double)(y + height), (double)z).func_187315_a(0.0, 1.0).func_181675_d();
        tessellator.func_78381_a();
    }

    protected void finishDrawingTab(int mouseX, int mouseY, float partialTicks) {
        if (this.angle != 0) {
            GlStateManager.func_179121_F();
            GlStateManager.func_179117_G();
        }
    }

    public int getAngle() {
        return this.angle;
    }

    public TabClickListener getClickListener() {
        return this.onClick;
    }

    public List<String> getHoverText() {
        return this.originalHoverText;
    }

    public boolean isHidden() {
        return this.isHidden;
    }

    @Override
    public boolean isUnderMouse(int mouseX, int mouseY) {
        if (this.angle == 180) {
            return this.isUnderMouseHorizontal(mouseX + this.width, mouseY);
        }
        if (this.angle == 90) {
            return this.isUnderMouseVertical(mouseX + this.height, mouseY);
        }
        if (this.angle == 270) {
            return this.isUnderMouseVertical(mouseX - this.height, mouseY);
        }
        return this.isUnderMouseHorizontal(mouseX, mouseY);
    }

    private boolean isUnderMouseHorizontal(int mouseX, int mouseY) {
        boolean retVal = false;
        retVal = !this.isHidden ? mouseX >= this.getX() && mouseX <= this.getX() + this.getWidth() && mouseY >= this.getY() && mouseY <= this.getY() + this.getHeight() : (this.angle == 90 ? mouseX >= this.getX() && mouseX <= this.getX() + this.getWidth() && mouseY >= this.getY() && mouseY <= this.getY() + 4 : mouseX >= this.getX() && mouseX <= this.getX() + this.getWidth() && mouseY >= this.getY() + this.getHeight() - 4 && mouseY <= this.getY() + this.getHeight());
        return retVal;
    }

    private boolean isUnderMouseVertical(int mouseX, int mouseY) {
        boolean retVal = false;
        retVal = !this.isHidden ? mouseX >= this.getX() && mouseX <= this.getX() + this.getHeight() && mouseY >= this.getY() && mouseY <= this.getY() + this.getWidth() : (this.angle == 90 ? mouseX >= this.getX() + this.getHeight() - 4 && mouseX <= this.getX() + this.getHeight() && mouseY >= this.getY() && mouseY <= this.getY() + this.getWidth() : mouseX >= this.getX() && mouseX <= this.getX() + 4 && mouseY >= this.getY() && mouseY <= this.getY() + this.getWidth());
        return retVal;
    }

    public boolean isVisible() {
        return this.isVisible;
    }

    @Override
    public boolean onMouseClicked(int posX, int posY, int mouseButtonIndex, boolean overlap) {
        boolean clicked;
        boolean bl = clicked = this.isUnderMouse(posX, posY) && !overlap;
        if (clicked) {
            if (this.getClickListener() != null) {
                this.getClickListener().onClick(this);
            }
            this.playClickSound();
        }
        return clicked;
    }

    protected void playClickSound() {
        Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_184371_a((SoundEvent)SoundEvents.field_187909_gi, (float)1.0f));
    }

    public void setAngle(int angle) {
        this.angle = angle;
    }

    public Tab setClickListener(TabClickListener onClicked) {
        this.onClick = onClicked;
        return this;
    }

    public Tab setDrawHoverText(boolean drawHoverText) {
        this.drawHoverText = drawHoverText;
        return this;
    }

    public Tab setHidden(boolean isHidden) {
        this.isHidden = isHidden;
        return this;
    }

    public Tab setHoverText(List<String> text) {
        this.originalHoverText = text;
        return this;
    }

    @Override
    public Tab setId(String id) {
        this.assignId(id);
        return this;
    }

    public Tab setIsVisible(boolean visible) {
        this.isVisible = visible;
        return this;
    }

    protected void verifyHoverText(int mouseX, int mouseY) {
        int dWidth;
        int tlineWidth = 0;
        for (String line : this.originalHoverText) {
            tlineWidth = TextRenderer.getFontRenderer().func_78256_a(line) > tlineWidth ? TextRenderer.getFontRenderer().func_78256_a(line) : tlineWidth;
        }
        int n = dWidth = RabbitGui.proxy.getCurrentStage() == null ? Minecraft.func_71410_x().field_71443_c : RabbitGui.proxy.getCurrentStage().field_146294_l;
        if (tlineWidth + mouseX > dWidth && mouseX + 1 > dWidth / 2) {
            this.drawToLeft = true;
        }
        ArrayList<String> newHoverText = new ArrayList<String>();
        if (this.drawToLeft) {
            for (String line : this.originalHoverText) {
                int lineWidth = TextRenderer.getFontRenderer().func_78256_a(line) + 12;
                if (lineWidth > mouseX) {
                    String newString = "";
                    for (String substring : line.split(" ")) {
                        if (TextRenderer.getFontRenderer().func_78256_a(newString) + TextRenderer.getFontRenderer().func_78256_a(substring) < mouseX - 12) {
                            newString = newString + substring + " ";
                            continue;
                        }
                        newHoverText.add(newString);
                        newString = substring + " ";
                    }
                    newHoverText.add(newString);
                    continue;
                }
                newHoverText.add(line);
            }
        } else {
            for (String line : this.originalHoverText) {
                int lineWidth = TextRenderer.getFontRenderer().func_78256_a(line) + 12;
                if (lineWidth > dWidth - mouseX) {
                    String newString = "";
                    for (String substring : line.split(" ")) {
                        if (TextRenderer.getFontRenderer().func_78256_a(newString) + TextRenderer.getFontRenderer().func_78256_a(substring) < dWidth - mouseX - 12) {
                            newString = newString + substring + " ";
                            continue;
                        }
                        newHoverText.add(newString);
                        newString = substring + " ";
                    }
                    newHoverText.add(newString);
                    continue;
                }
                newHoverText.add(line);
            }
        }
        this.hoverText = newHoverText;
    }

    @FunctionalInterface
    public static interface TabClickListener {
        public void onClick(Tab var1);
    }
}

