/*
 * Decompiled with CFR 0.152.
 */
package com.libraries.rabbit.gui.component.grid;

import com.libraries.rabbit.gui.component.GuiWidget;
import com.libraries.rabbit.gui.component.control.ScrollBar;
import com.libraries.rabbit.gui.component.grid.Grid;
import com.libraries.rabbit.gui.component.grid.entries.GridEntry;
import com.libraries.rabbit.gui.layout.LayoutComponent;
import com.libraries.rabbit.gui.utils.Geometry;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
@LayoutComponent
public class ScrollableGrid
extends Grid {
    protected ScrollBar scrollBar;

    public ScrollableGrid(int xPos, int yPos, int width, int height, int slotWidth, int slotHeight, List<GridEntry> content) {
        super(xPos, yPos, width, height, slotWidth, slotHeight, content);
    }

    private boolean canFit() {
        return Math.ceil((float)this.content.size() / (float)this.xSlots) * (double)this.slotHeight < (double)this.height;
    }

    @Override
    protected void drawGridContent(int mouseX, int mouseY) {
        this.scrollBar.setVisiblie(!this.canFit());
        this.scrollBar.setHandleMouseWheel(!this.canFit() && this.isUnderMouse(mouseX, mouseY));
        this.scrollBar.setScrollerSize(this.getScrollerSize());
        int scale = Geometry.computeScaleFactor();
        for (int i = 0; i < this.content.size(); ++i) {
            GlStateManager.func_179094_E();
            GL11.glEnable((int)3089);
            Minecraft mc = Minecraft.func_71410_x();
            GL11.glScissor((int)(this.getX() * scale), (int)(mc.field_71440_d - (this.getY() + this.getHeight()) * scale), (int)(this.getWidth() * scale), (int)(this.getHeight() * scale));
            GridEntry entry = (GridEntry)this.content.get(i);
            int slotPosX = this.getX() + i % this.xSlots * this.slotWidth;
            int slotPosY = this.getY() + i / this.xSlots * this.slotHeight - (int)((double)((float)this.slotHeight * this.scrollBar.getProgress()) * Math.ceil(this.content.size()) / (double)this.xSlots) + (int)((double)(this.scrollBar.getProgress() * (float)this.height) * 0.92);
            if (slotPosY < this.getY() + this.height && slotPosY + this.slotHeight > this.getY()) {
                if (!this.isUnderMouse(mouseX, mouseY)) {
                    entry.setDoesDrawHoverText(false);
                } else {
                    entry.setDoesDrawHoverText(true);
                }
                entry.onDraw(this, slotPosX + 1, slotPosY + 1, this.slotWidth - 2, this.slotHeight - 2, mouseX, mouseY);
            }
            GL11.glDisable((int)3089);
            GlStateManager.func_179121_F();
        }
    }

    private int getScrollerSize() {
        return (int)(1.0f * (float)this.height / (float)(this.content.size() / this.xSlots * this.slotHeight) * (float)(this.height - 4)) / 2;
    }

    @Override
    protected void handleMouseClickGrid(int mouseX, int mouseY) {
        for (int i = 0; i < this.content.size(); ++i) {
            boolean clickedOnEntry;
            boolean scrollbarActive;
            GridEntry entry = (GridEntry)this.content.get(i);
            int slotPosX = this.getX() + i % this.xSlots * this.slotWidth;
            int slotPosY = this.getY() + i / this.xSlots * this.slotHeight - (int)((float)this.slotHeight * this.scrollBar.getProgress() * (float)this.content.size() / (float)this.xSlots * 0.925f);
            int slotWidth = this.slotWidth;
            int slotHeight = this.slotHeight;
            boolean bl = scrollbarActive = this.scrollBar.isScrolling() && this.scrollBar.isVisible();
            if (slotPosY + slotHeight > this.getY() + this.height || slotPosY < this.getY() || scrollbarActive || !(clickedOnEntry = Geometry.isDotInArea(slotPosX, slotPosY, slotWidth, slotHeight, mouseX, mouseY))) continue;
            entry.onClick(this, mouseX, mouseY);
        }
    }

    @Override
    public boolean isUnderMouse(int mouseX, int mouseY) {
        return mouseX >= this.getX() && mouseX <= this.getX() + this.getWidth() && mouseY >= this.getY() && mouseY <= this.getY() + this.getHeight();
    }

    @Override
    public void onDraw(int mouseX, int mouseY, float partialTicks) {
        super.onDraw(mouseX, mouseY, partialTicks);
    }

    @Override
    public void setup() {
        super.setup();
        int scrollerSize = this.height / (this.content.isEmpty() ? 1 : this.content.size());
        if (scrollerSize < 10) {
            scrollerSize = 10;
        }
        if (this.content.size() < this.height / this.slotHeight) {
            scrollerSize = this.height - 4;
        }
        this.scrollBar = new ScrollBar(this.getX() + this.width - 10, this.getY(), 10, this.height, scrollerSize);
        this.scrollBar.setScrollWeight((float)this.height / (float)(this.content.size() * this.slotHeight) * 0.8f);
        this.registerComponent(this.scrollBar);
    }

    @Override
    public GuiWidget setX(int x) {
        super.setX(x);
        if (this.scrollBar != null) {
            this.scrollBar.setX(x + this.width - 10);
        }
        return this;
    }

    @Override
    public GuiWidget setY(int y) {
        super.setY(y);
        if (this.scrollBar != null) {
            this.scrollBar.setY(y);
        }
        return this;
    }
}

