/*
 * Decompiled with CFR 0.152.
 */
package com.libraries.rabbit.gui.component.list;

import com.libraries.rabbit.gui.component.GuiWidget;
import com.libraries.rabbit.gui.component.control.ScrollBar;
import com.libraries.rabbit.gui.component.list.DisplayList;
import com.libraries.rabbit.gui.component.list.entries.ListEntry;
import com.libraries.rabbit.gui.layout.LayoutComponent;
import com.libraries.rabbit.gui.utils.Geometry;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
@LayoutComponent
public class ScrollableDisplayList
extends DisplayList {
    protected ScrollBar scrollBar;

    public ScrollableDisplayList(int xPos, int yPos, int width, int height, int slotHeight, List<ListEntry> content) {
        super(xPos, yPos, width, height, slotHeight, content);
    }

    private boolean canFit() {
        return this.content.size() * this.slotHeight < this.height;
    }

    @Override
    protected void drawListContent(int mouseX, int mouseY) {
        this.scrollBar.setVisiblie(!this.canFit());
        this.scrollBar.setHandleMouseWheel(!this.canFit() && this.isUnderMouse(mouseX, mouseY));
        this.scrollBar.setScrollerSize(this.getScrollerSize());
        int scale = Geometry.computeScaleFactor();
        for (int i = 0; i < this.content.size(); ++i) {
            ListEntry entry = (ListEntry)this.content.get(i);
            int slotPosX = this.getX();
            int slotPosY = this.getY() + i * this.slotHeight - (int)((float)this.slotHeight * this.scrollBar.getProgress() * (float)this.content.size() - (float)(this.height - this.slotHeight) * this.scrollBar.getProgress() / 1.0f);
            int slotWidth = this.width;
            int slotHeight = this.slotHeight;
            if (slotPosY >= this.getY() + this.height || slotPosY + slotHeight <= this.getY()) continue;
            GlStateManager.func_179094_E();
            GL11.glEnable((int)3089);
            Minecraft mc = Minecraft.func_71410_x();
            GL11.glScissor((int)(this.getX() * scale), (int)(mc.field_71440_d - (this.getY() + this.getHeight()) * scale), (int)(this.getWidth() * scale), (int)(this.getHeight() * scale));
            GlStateManager.func_179117_G();
            entry.onDraw(this, slotPosX, slotPosY, slotWidth, slotHeight, mouseX, mouseY);
            GL11.glDisable((int)3089);
            GlStateManager.func_179121_F();
        }
    }

    private int getScrollerSize() {
        return (int)Math.min((double)Math.max((int)(1.0f * (float)this.height / (float)(this.content.size() * this.slotHeight) * (float)(this.height - 4)) * 2, 15), (double)this.height * 0.8);
    }

    @Override
    protected void handleMouseClickList(int mouseX, int mouseY, int mouseButtonIndex) {
        for (int i = 0; i < this.content.size(); ++i) {
            boolean clickedOnEntry;
            boolean scrollbarActive;
            ListEntry entry = (ListEntry)this.content.get(i);
            entry.setSelected(false);
            int slotPosX = this.getX();
            int slotPosY = this.getY() + i * this.slotHeight - (int)((float)this.slotHeight * this.scrollBar.getProgress() * (float)this.content.size() - (float)(this.height - this.slotHeight) * this.scrollBar.getProgress() / 1.0f);
            int slotWidth = this.width;
            int slotHeight = this.slotHeight;
            boolean bl = scrollbarActive = this.scrollBar.isScrolling() && this.scrollBar.isVisible();
            if (slotPosY + slotHeight > this.getY() + this.height || slotPosY < this.getY() || scrollbarActive || !(clickedOnEntry = Geometry.isDotInArea(slotPosX, slotPosY, slotWidth, slotHeight, mouseX, mouseY))) continue;
            entry.onClick(this, mouseX, mouseY, mouseButtonIndex);
        }
    }

    @Override
    public boolean isUnderMouse(int mouseX, int mouseY) {
        return mouseX >= this.getX() && mouseX <= this.getX() + this.getWidth() && mouseY >= this.getY() && mouseY <= this.getY() + this.getHeight();
    }

    @Override
    public void onDraw(int mouseX, int mouseY, float partialTicks) {
        super.onDraw(mouseX, mouseY, partialTicks);
    }

    public ScrollableDisplayList setScrollAmount(float amt) {
        amt = MathHelper.func_76131_a((float)amt, (float)0.0f, (float)1.0f);
        this.scrollBar.setProgress(amt);
        return this;
    }

    @Override
    public void setup() {
        super.setup();
        int scrollerSize = this.height / (this.content.isEmpty() ? 1 : this.content.size());
        if (scrollerSize < 10) {
            scrollerSize = 10;
        }
        if (this.content.size() < this.height / this.slotHeight) {
            scrollerSize = this.height - 4;
        }
        this.scrollBar = new ScrollBar(this.getX() + this.width - 10, this.getY(), 10, this.height, scrollerSize).setHandleMouseWheel(false);
        this.scrollBar.setScrollWeight((float)this.height / (float)(this.content.size() * this.slotHeight) * 0.8f);
        this.registerComponent(this.scrollBar);
    }

    @Override
    public GuiWidget setX(int x) {
        super.setX(x);
        if (this.scrollBar != null) {
            this.scrollBar.setX(x + this.width - 10);
        }
        return this;
    }

    @Override
    public GuiWidget setY(int y) {
        super.setY(y);
        if (this.scrollBar != null) {
            this.scrollBar.setY(y);
        }
        return this;
    }
}

